/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.opf;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="opframe", category="")
@Mod.EventBusSubscriber
public class OPFrameConfig {
    @Config.Name(value="limitations")
    @Config.LangKey(value="config.opframe.limitations")
    public static Limitations limitations;
    private static Limitations serverLimitations;

    public static Limitations getGlobalLimitations() {
        return serverLimitations;
    }

    public static void setGlobalLimitations(Limitations globalLimitations) {
        serverLimitations = globalLimitations;
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("opframe")) {
            ConfigManager.sync((String)"opframe", (Config.Type)Config.Type.INSTANCE);
        }
    }

    static {
        serverLimitations = limitations = new Limitations();
    }

    public static class Limitations {
        @Config.Name(value="size-limitation")
        @Config.RangeDouble(min=0.0, max=10000.0)
        @Config.Comment(value={"The maximum size (in blocks) for a frame"})
        @Config.LangKey(value="config.opframe.sizeLimit")
        @Config.RequiresMcRestart
        public double sizeLimitation = 1000.0;
        @Config.Name(value="onlyOperators")
        @Config.LangKey(value="config.opframe.onlyOpped")
        @Config.Comment(value={"True if only operators (opped players) are allowed to edit a frame"})
        public boolean onlyOps = false;
        @Config.Name(value="disableAdventure")
        @Config.LangKey(value="config.opframe.disableAdventure")
        @Config.Comment(value={"If true, players in adventure mode will not be able to edit frames"})
        public boolean disableAdventure = true;
        @Config.Name(value="whitelistEnabled")
        @Config.LangKey(value="config.opframe.enableWhitelist")
        @Config.Comment(value={"If true, only URLs listed in the whitelist can be used for a frame"})
        @Config.RequiresMcRestart
        public boolean whitelistEnabled = false;
        @Config.Name(value="whitelist")
        @Config.LangKey(value="config.opframe.whitelist")
        @Config.Comment(value={"A list of URLs that can be used for frames"})
        @Config.RequiresMcRestart
        public String[] whitelist = new String[]{"imgur.com", "gyazo.com", "prntscr.com", "tinypic.com", "puu.sh", "pinimg.com", "photobucket.com", "staticflickr.com", "flic.kr", "tenor.co", "gfycat.com", "giphy.com", "gph.is", "gifbin.com", "i.redd.it", "media.tumblr.com", "twimg.com", "discordapp.com", "images.discordapp.net", "githubusercontent.com", "googleusercontent.com", "googleapis.com", "wikimedia.org", "ytimg.com"};

        public boolean canUse(EntityPlayer player, String url) {
            return this.canUse(player, url, false);
        }

        public boolean canUse(EntityPlayer player, String url, boolean ignoreToggle) {
            World world = player.field_70170_p;
            if (!world.field_72995_K && (world.func_73046_m().func_71264_H() || player.func_70003_b(world.func_73046_m().func_110455_j(), ""))) {
                return true;
            }
            if (this.whitelistEnabled || ignoreToggle) {
                try {
                    return this.isDomainWhitelisted(new URI(url.toLowerCase(Locale.ROOT)).getHost());
                }
                catch (URISyntaxException e) {
                    return false;
                }
            }
            return true;
        }

        public boolean isDomainWhitelisted(String domain) {
            if (domain != null) {
                for (String url : this.whitelist) {
                    String formattedUrl = url.trim().toLowerCase(Locale.ROOT);
                    if (!domain.endsWith("." + formattedUrl) && !domain.equals(formattedUrl)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean canInteract(EntityPlayer player, World world) {
            boolean isOperator;
            if (this.disableAdventure && ((EntityPlayerMP)player).field_71134_c.func_73081_b() == GameType.ADVENTURE) {
                return false;
            }
            boolean bl = isOperator = world.func_73046_m().func_71264_H() || player.func_70003_b(world.func_73046_m().func_110455_j(), "");
            if (this.onlyOps) {
                return isOperator;
            }
            return isOperator || !this.disableAdventure || player.field_71075_bZ.field_75099_e;
        }
    }
}

