/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.recipes.parts;

import aroma1997.core.recipes.parts.RecipePartBase;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class RecipePartFluid
extends RecipePartBase {
    private FluidStack stack;

    public RecipePartFluid(Fluid fluid) {
        this(fluid, 1000);
    }

    public RecipePartFluid(Fluid fluid, int amount) {
        this.stack = new FluidStack(fluid, amount);
    }

    public RecipePartFluid(FluidStack stack) {
        this.stack = stack.copy();
    }

    @Override
    public boolean doesItemMatch(ItemStack item) {
        if (!item.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return false;
        }
        IFluidHandlerItem handler = (IFluidHandlerItem)item.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (handler == null) {
            return false;
        }
        FluidStack received = handler.drain(this.stack, false);
        return received != null && received.getFluid() == this.stack.getFluid() && received.amount >= this.stack.amount;
    }

    @Override
    public ItemStack getResult(ItemStack in) {
        if (!in.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            return ItemStack.field_190927_a;
        }
        in = in.func_77946_l();
        IFluidHandlerItem handler = (IFluidHandlerItem)in.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        handler.drain(this.stack, true);
        return handler.getContainer();
    }
}

