/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.MMParticle;
import com.bobmowzie.mowziesmobs.client.particle.ParticleFactory;
import com.bobmowzie.mowziesmobs.client.particles.ParticleCloud;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityMagicEffect;
import com.bobmowzie.mowziesmobs.server.entity.frostmaw.EntityFrostmaw;
import com.bobmowzie.mowziesmobs.server.property.MowzieLivingProperties;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.List;
import net.ilexiconn.llibrary.server.entity.EntityPropertiesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityIceBreath
extends EntityMagicEffect {
    private static final int RANGE = 10;
    private static final int ARC = 45;
    private static final int DAMAGE_PER_HIT = 1;

    public EntityIceBreath(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
        if (world.field_72995_K) {
            MowziesMobs.PROXY.playIceBreathSound(this);
        }
    }

    public EntityIceBreath(World world, EntityLivingBase caster) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.caster != null && this.caster.func_110143_aJ() <= 0.0f) {
            this.func_70106_y();
        }
        if (this.field_70173_aa == 1) {
            this.func_184185_a(MMSounds.ENTITY_FROSTMAW_ICEBREATH_START, 1.0f, 0.6f);
        }
        if (this.caster instanceof EntityPlayer) {
            this.field_70177_z = ((EntityPlayer)this.caster).field_70177_z;
            this.field_70125_A = ((EntityPlayer)this.caster).field_70125_A;
            this.field_70165_t = ((EntityPlayer)this.caster).field_70165_t;
            this.field_70163_u = ((EntityPlayer)this.caster).field_70163_u + (double)((EntityPlayer)this.caster).eyeHeight - 0.5;
            this.field_70161_v = ((EntityPlayer)this.caster).field_70161_v;
        }
        float yaw = (float)Math.toRadians(-this.field_70177_z);
        float pitch = (float)Math.toRadians(-this.field_70125_A);
        float spread = 0.25f;
        float speed = 0.56f;
        float xComp = (float)(Math.sin(yaw) * Math.cos(pitch));
        float yComp = (float)Math.sin(pitch);
        float zComp = (float)(Math.cos(yaw) * Math.cos(pitch));
        if (this.field_70170_p.field_72995_K) {
            double zSpeed;
            double ySpeed;
            double xSpeed;
            int i;
            if (this.field_70173_aa % 8 == 0 && this.field_70170_p.field_72995_K) {
                MMParticle.RING.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(Float.valueOf(yaw), Float.valueOf(-pitch), 40, Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(1.0f), Float.valueOf(110.0f * spread), false, Float.valueOf(0.5f * xComp), Float.valueOf(0.5f * yComp), Float.valueOf(0.5f * zComp)));
            }
            for (i = 0; i < 6; ++i) {
                xSpeed = speed * 1.0f * xComp;
                ySpeed = speed * 1.0f * yComp;
                zSpeed = speed * 1.0f * zComp;
                MMParticle.SNOWFLAKE.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(xSpeed, ySpeed, zSpeed, 37.0, 1.0));
            }
            for (i = 0; i < 5; ++i) {
                xSpeed = (double)(speed * xComp) + (double)spread * 0.7 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - xComp * xComp);
                ySpeed = (double)(speed * yComp) + (double)spread * 0.7 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - yComp * yComp);
                zSpeed = (double)(speed * zComp) + (double)spread * 0.7 * (double)(this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * Math.sqrt(1.0f - zComp * zComp);
                double value = this.field_70146_Z.nextFloat() * 0.15f;
                MMParticle.CLOUD.spawn(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(new Object[]{xSpeed, ySpeed, zSpeed, 0.75 + value, 0.75 + value, 1.0, 1, 10.0 + this.field_70146_Z.nextDouble() * 20.0, 40, ParticleCloud.EnumCloudBehavior.GROW}));
            }
        }
        if (this.field_70173_aa > 10) {
            this.hitEntities();
        }
        if (this.field_70173_aa > 65 && !(this.caster instanceof EntityPlayer)) {
            this.func_70106_y();
        }
    }

    public void hitEntities() {
        List<EntityLivingBase> entitiesHit = this.getEntityLivingBaseNearby(10.0, 10.0, 10.0, 10.0);
        float damage = 1.0f;
        if (this.caster instanceof EntityFrostmaw) {
            damage *= MowziesMobs.CONFIG.attackScaleFrostmaw;
        }
        if (this.caster instanceof EntityPlayer) {
            damage *= MowziesMobs.CONFIG.attackScaleIceCrystal;
        }
        for (EntityLivingBase entityHit : entitiesHit) {
            boolean pitchCheck;
            if (entityHit == this.caster) continue;
            float entityHitYaw = (float)((Math.atan2(entityHit.field_70161_v - this.field_70161_v, entityHit.field_70165_t - this.field_70165_t) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingYaw = this.field_70177_z % 360.0f;
            if (entityHitYaw < 0.0f) {
                entityHitYaw += 360.0f;
            }
            if (entityAttackingYaw < 0.0f) {
                entityAttackingYaw += 360.0f;
            }
            float entityRelativeYaw = entityHitYaw - entityAttackingYaw;
            float xzDistance = (float)Math.sqrt((entityHit.field_70161_v - this.field_70161_v) * (entityHit.field_70161_v - this.field_70161_v) + (entityHit.field_70165_t - this.field_70165_t) * (entityHit.field_70165_t - this.field_70165_t));
            float entityHitPitch = (float)(Math.atan2(entityHit.field_70163_u - this.field_70163_u, xzDistance) * 57.29577951308232 % 360.0);
            float entityAttackingPitch = -this.field_70125_A % 360.0f;
            if (entityHitPitch < 0.0f) {
                entityHitPitch += 360.0f;
            }
            if (entityAttackingPitch < 0.0f) {
                entityAttackingPitch += 360.0f;
            }
            float entityRelativePitch = entityHitPitch - entityAttackingPitch;
            float entityHitDistance = (float)Math.sqrt((entityHit.field_70161_v - this.field_70161_v) * (entityHit.field_70161_v - this.field_70161_v) + (entityHit.field_70165_t - this.field_70165_t) * (entityHit.field_70165_t - this.field_70165_t) + (entityHit.field_70163_u - this.field_70163_u) * (entityHit.field_70163_u - this.field_70163_u));
            boolean inRange = entityHitDistance <= 10.0f;
            boolean yawCheck = entityRelativeYaw <= 22.0f && entityRelativeYaw >= -22.0f || entityRelativeYaw >= 338.0f || entityRelativeYaw <= -338.0f;
            boolean bl = pitchCheck = entityRelativePitch <= 22.0f && entityRelativePitch >= -22.0f || entityRelativePitch >= 338.0f || entityRelativePitch <= -338.0f;
            if (!inRange || !yawCheck || !pitchCheck) continue;
            entityHit.func_70097_a(DamageSource.func_76354_b((Entity)this.caster, null), damage);
            MowzieLivingProperties property = (MowzieLivingProperties)EntityPropertiesHandler.INSTANCE.getProperties((Entity)entityHit, MowzieLivingProperties.class);
            if (property == null) continue;
            property.freezeProgress = (float)((double)property.freezeProgress + 0.13);
        }
    }

    public List<EntityLivingBase> getEntityLivingBaseNearby(double distanceX, double distanceY, double distanceZ, double radius) {
        return this.getEntitiesNearby(EntityLivingBase.class, distanceX, distanceY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getEntitiesNearby(Class<T> entityClass, double dX, double dY, double dZ, double r) {
        return this.field_70170_p.func_175647_a(entityClass, this.func_174813_aQ().func_72314_b(dX, dY, dZ), e -> e != this && (double)this.func_70032_d((Entity)e) <= r && e.field_70163_u <= this.field_70163_u + dY);
    }

    @Override
    protected void func_70037_a(NBTTagCompound compound) {
    }

    @Override
    protected void func_70014_b(NBTTagCompound compound) {
    }
}

