/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.item.upgrade;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.item.ItemSimple;

public class UpgradeLighting
extends ItemSimple
implements IUpgrade {
    public UpgradeLighting() {
        super("upgrade_lighting", 1);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.addAll(Arrays.asList(I18n.func_135052_a((String)"vsb.txt.upgrade.lighting.desc", (Object[])new Object[0]).split("\\|")));
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity ticker) {
        BlockPos playerPos = ticker.func_180425_c();
        int light = ticker.field_70170_p.func_175699_k(playerPos);
        if (light <= 7 && ticker.field_70170_p.func_175623_d(playerPos)) {
            int torchSlot = -1;
            for (int i = 0; i < backpack.getInventory().getSlots(); ++i) {
                ItemStack is = backpack.getInventory().getStackInSlot(i);
                if (is.func_190926_b() || !(is.func_77973_b() instanceof ItemBlock) || !(((ItemBlock)is.func_77973_b()).func_179223_d() instanceof BlockTorch)) continue;
                torchSlot = i;
                break;
            }
            if (torchSlot != -1) {
                ItemStack torch = backpack.getInventory().getStackInSlot(torchSlot);
                BlockTorch torchBlock = (BlockTorch)((ItemBlock)torch.func_77973_b()).func_179223_d();
                ArrayList possibleFacings = Lists.newArrayList();
                for (EnumFacing facing : EnumFacing.values()) {
                    if (facing == EnumFacing.UP) continue;
                    BlockPos at = playerPos.func_177972_a(facing);
                    IBlockState blockAt = ticker.field_70170_p.func_180495_p(at);
                    if (facing == EnumFacing.DOWN) {
                        if (!blockAt.func_177230_c().canPlaceTorchOnTop(blockAt, (IBlockAccess)ticker.field_70170_p, at)) continue;
                        possibleFacings.add(facing);
                        continue;
                    }
                    if (blockAt.func_193401_d((IBlockAccess)ticker.field_70170_p, at, facing.func_176734_d()) != BlockFaceShape.SOLID) continue;
                    possibleFacings.add(facing);
                }
                if (!possibleFacings.isEmpty()) {
                    EnumFacing randomFacing = (EnumFacing)possibleFacings.get(ticker.field_70170_p.field_73012_v.nextInt(possibleFacings.size()));
                    ticker.field_70170_p.func_175656_a(playerPos, torchBlock.func_180642_a(ticker.field_70170_p, playerPos, randomFacing, 0.0f, 0.0f, 0.0f, 0, (EntityLivingBase)ticker));
                    backpack.getInventory().extractItem(torchSlot, 1, false);
                }
            }
        }
    }

    @Override
    public void onPulse(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, Entity pulsar) {
    }

    @Override
    public boolean onItemPickup(@Nullable IBackpackWrapper container, IBackpackWrapper backpack, IUpgradeWrapper self, EntityItem item, Entity picker) {
        return false;
    }

    @Override
    public void onInstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public void onUninstalled(IBackpackWrapper backpack, IUpgradeWrapper self) {
    }

    @Override
    public boolean canInstall(IBackpackWrapper backpack, IUpgradeWrapper self) {
        return !Arrays.stream(backpack.getReadonlyUpdatesArray()).filter(Objects::nonNull).map(IUpgradeWrapper::getSelf).anyMatch(i -> i.func_77973_b() == self.getSelf().func_77973_b());
    }

    @Override
    public boolean hasSyncTag() {
        return false;
    }
}

