/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.client;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.data.VSBItems;
import v0id.vsb.client.render.RenderLayerBackpack;
import v0id.vsb.item.ItemBackpack;

@Mod.EventBusSubscriber(modid="v0idssmartbackpacks", value={Side.CLIENT})
public class ClientRegistry {
    public static KeyBinding key_openBackpack;
    public static KeyBinding key_removeBackpack;
    public static KeyBinding key_changeHotbar;

    static void onPreInit() {
        key_openBackpack = new KeyBinding("vsb.kb.openBackpack", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 48, "key.categories.inventory");
        key_removeBackpack = new KeyBinding("vsb.kb.removeBackpack", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.SHIFT, 48, "key.categories.inventory");
        key_changeHotbar = new KeyBinding("vsb.kb.changeHotbar", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, 37, "key.categories.inventory");
        net.minecraftforge.fml.client.registry.ClientRegistry.registerKeyBinding((KeyBinding)key_openBackpack);
        net.minecraftforge.fml.client.registry.ClientRegistry.registerKeyBinding((KeyBinding)key_removeBackpack);
        net.minecraftforge.fml.client.registry.ClientRegistry.registerKeyBinding((KeyBinding)key_changeHotbar);
    }

    static void onInit() {
        Minecraft.func_71410_x().getItemColors().func_186730_a((is, layer) -> {
            if (is.func_77973_b() instanceof ItemBackpack && layer == 0) {
                IBackpack backpack = IBackpack.of(is);
                return backpack != null ? backpack.createWrapper().getColor() : -1;
            }
            return -1;
        }, new Item[]{VSBItems.BASIC_BACKPACK, VSBItems.REINFORCED_BACKPACK, VSBItems.ADVANCED_BACKPACK, VSBItems.ULTIMATE_BACKPACK});
    }

    static void onPostInit() {
        Map skinMap = Minecraft.func_71410_x().func_175598_ae().getSkinMap();
        for (RenderPlayer renderer : skinMap.values()) {
            renderer.func_177094_a((LayerRenderer)new RenderLayerBackpack());
        }
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
        ClientRegistry.registerSimpleModel(VSBItems.BASIC_BACKPACK);
        ClientRegistry.registerSimpleModel(VSBItems.REINFORCED_BACKPACK);
        ClientRegistry.registerSimpleModel(VSBItems.ADVANCED_BACKPACK);
        ClientRegistry.registerSimpleModel(VSBItems.ULTIMATE_BACKPACK);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_BASE);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_DAMAGE_BAR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_NESTING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_FILTER);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_PULLING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_COMPRESSOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_SORTING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_VOID);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_PUSHING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_SMELTING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_GRINDING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_ENERGY_BASIC);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_ENERGY_ADVANCED);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_ENERGY_ULTIMATE);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_ENERGY_CREATIVE);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_FURNACE_GENERATOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_SOLAR_GENERATOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_WIND_GENERATOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_KINETIC_GENERATOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_NUCLEAR_GENERATOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_EM_GENERATOR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_INDUCTION_COIL);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_CHARGING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_FEEDING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_WATER_SPRING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_ENDER_STORAGE);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_SOULBOUND);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_AIR_BAG);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_MENDING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_LIMITING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_DEPOSITING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_HOTBAR);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_MAGNET);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_QUIVER);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_EXPERIENCE);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_ENDER_CHEST);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_SHARING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_LIGHTING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_CRAFTING);
        ClientRegistry.registerSimpleModel(VSBItems.UPGRADE_FILTER_REGEX);
        ClientRegistry.registerSimpleModel(VSBItems.REINFORCED_LEATHER);
        ClientRegistry.registerSimpleModel(VSBItems.DRAGON_SCALES);
    }

    private static void registerStaticModel(IForgeRegistryEntry<?> entry) {
        ClientRegistry.registerStaticModel(entry, "inventory");
    }

    private static void registerStaticModel(IForgeRegistryEntry<?> entry, String variant) {
        ModelResourceLocation staticLocation = new ModelResourceLocation(entry.getRegistryName(), variant);
        Item item = entry instanceof Block ? Item.func_150898_a((Block)((Block)entry)) : (Item)entry;
        ModelLoader.setCustomMeshDefinition((Item)item, i -> staticLocation);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{staticLocation});
    }

    private static void registerModelWithVariants(IForgeRegistryEntry<?> entry, int maxVariants, Function<Integer, String> variantProvider) {
        Item item = entry instanceof Block ? Item.func_150898_a((Block)((Block)entry)) : (Item)entry;
        for (int i = 0; i < maxVariants; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(entry.getRegistryName(), variantProvider.apply(i)));
        }
    }

    private static void registerSimpleModel(IForgeRegistryEntry<?> entry) {
        ClientRegistry.registerSimpleModel(entry, "inventory");
    }

    private static void registerSimpleModel(IForgeRegistryEntry<?> entry, String variant) {
        ModelLoader.setCustomModelResourceLocation((Item)(entry instanceof Block ? Item.func_150898_a((Block)((Block)entry)) : (Item)entry), (int)0, (ModelResourceLocation)new ModelResourceLocation(entry.getRegistryName(), variant));
    }
}

