/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.capability;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import v0id.api.vsb.capability.IFilter;
import v0id.vsb.util.VSBUtils;

public class Filter
implements IFilter {
    private final ItemStackHandler inventory = new ItemStackHandler(18);
    private boolean oreDict;
    private boolean ignoreMeta;
    private boolean ignoreNBT;
    private boolean isWhitelist;

    @Override
    public IItemHandler getItems() {
        return this.inventory;
    }

    @Override
    public boolean accepts(ItemStack is) {
        if (is.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            boolean nbtEquals;
            ItemStack stack = this.inventory.getStackInSlot(i);
            IFilter filter = IFilter.of(stack);
            if (filter != null) {
                boolean accepts = filter.accepts(is);
                if (accepts != filter.isWhitelist()) continue;
                return accepts == this.isWhitelist;
            }
            if (this.oreDict && VSBUtils.isOreDictionaryMatch(is, stack)) {
                return this.isWhitelist;
            }
            boolean itemEquals = is.func_77973_b() == stack.func_77973_b();
            boolean metaEquals = is.func_77952_i() == stack.func_77952_i() || this.ignoreMeta;
            boolean bl = nbtEquals = ItemStack.func_77970_a((ItemStack)is, (ItemStack)stack) || this.ignoreNBT;
            if (!itemEquals || !metaEquals || !nbtEquals) continue;
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }

    @Override
    public boolean isOreDictionary() {
        return this.oreDict;
    }

    @Override
    public void setOreDictionary(boolean b) {
        this.oreDict = b;
    }

    @Override
    public boolean ignoresMetadata() {
        return this.ignoreMeta;
    }

    @Override
    public void setIgnoresMeta(boolean b) {
        this.ignoreMeta = b;
    }

    @Override
    public boolean ignoresNBT() {
        return this.ignoreNBT;
    }

    @Override
    public void setIgnoresNBT(boolean b) {
        this.ignoreNBT = b;
    }

    @Override
    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    @Override
    public void setWhitelist(boolean b) {
        this.isWhitelist = b;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        ret.func_74757_a("ore", this.oreDict);
        ret.func_74757_a("meta", this.ignoreMeta);
        ret.func_74757_a("nbt", this.ignoreNBT);
        ret.func_74757_a("whitelist", this.isWhitelist);
        return ret;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.checkV2();
        this.oreDict = nbt.func_74767_n("ore");
        this.ignoreMeta = nbt.func_74767_n("meta");
        this.ignoreNBT = nbt.func_74767_n("nbt");
        this.isWhitelist = nbt.func_74767_n("whitelist");
    }

    private void checkV2() {
        if (this.inventory.getSlots() == 9) {
            ItemStack[] stacks = VSBUtils.capabilityToArray((IItemHandler)this.inventory, ItemStack.class, s -> s);
            this.inventory.setSize(18);
            for (int i = 0; i < stacks.length; ++i) {
                this.inventory.setStackInSlot(i, stacks[i]);
            }
        }
    }
}

