/*
 * Decompiled with CFR 0.152.
 */
package v0id.vsb.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import v0id.api.vsb.capability.IBackpack;
import v0id.api.vsb.item.EnumBackpackType;
import v0id.api.vsb.item.IBackpackWrapper;
import v0id.api.vsb.item.IUpgrade;
import v0id.api.vsb.item.IUpgradeWrapper;
import v0id.vsb.util.VSBUtils;

public class Backpack
implements IBackpack {
    private final NBTItemHandler inventory;
    private final NBTItemHandler upgrades;
    private final EnergyStorageNBT energyStorage;
    private final ItemStack self;
    private final EnumBackpackType backpackType;
    private final Wrapper wrapper;
    private int color;
    private final NBTTagCompound upgradesClientTag = new NBTTagCompound();
    private int ticksLived;
    private int maxEnergy;

    public Backpack() {
        this.inventory = null;
        this.upgrades = null;
        this.self = null;
        this.backpackType = null;
        this.wrapper = null;
        this.energyStorage = null;
    }

    public Backpack(ItemStack owner, EnumBackpackType type) {
        this.inventory = new NBTItemHandler(owner, type.getInventorySize());
        this.upgrades = new NBTItemHandler(owner, type.getUpgradesSize());
        this.energyStorage = new EnergyStorageNBT(owner){

            public int getMaxEnergyStored() {
                return Backpack.this.maxEnergy;
            }

            @Override
            public int getEnergyStored() {
                return super.getEnergyStored() > this.getMaxEnergyStored() ? this.getMaxEnergyStored() : super.getEnergyStored();
            }
        };
        this.self = owner;
        this.backpackType = type;
        this.wrapper = new Wrapper();
    }

    @Override
    public IItemHandler getInventory() {
        return this.inventory;
    }

    @Override
    public IItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Override
    public IBackpackWrapper createWrapper() {
        return this.wrapper;
    }

    @Override
    public IUpgradeWrapper createUpgradeWrapper(ItemStack upgrade) {
        return new UpgradeWrapper(upgrade);
    }

    @Override
    public void onTick(@Nullable IBackpackWrapper container, @Nullable Entity ticker) {
        if (++this.ticksLived % 10 == 0) {
            for (IUpgradeWrapper upgradeWrapper : this.wrapper.getReadonlyUpdatesArray()) {
                if (upgradeWrapper == null) continue;
                upgradeWrapper.getUpgrade().onPulse(container, this.wrapper, upgradeWrapper, ticker);
            }
        }
        for (IUpgradeWrapper upgradeWrapper : this.wrapper.getReadonlyUpdatesArray()) {
            if (upgradeWrapper == null) continue;
            upgradeWrapper.getUpgrade().onTick(container, this.wrapper, upgradeWrapper, ticker);
        }
    }

    @Override
    public void copyAllDataFrom(IBackpack backpack) {
        if (backpack instanceof Backpack) {
            int i;
            Backpack back = (Backpack)backpack;
            for (i = 0; i < back.inventory.getSlots(); ++i) {
                this.inventory.setStackInSlot(i, back.inventory.getStackInSlot(i));
            }
            for (i = 0; i < back.upgrades.getSlots(); ++i) {
                this.upgrades.setStackInSlot(i, back.upgrades.getStackInSlot(i));
            }
            this.maxEnergy = back.maxEnergy;
            this.energyStorage.setEnergyStored(back.energyStorage.getEnergyStored());
            this.color = back.color;
        }
    }

    @Override
    public IEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        ret.func_74782_a("upgrades", (NBTBase)this.upgrades.serializeNBT());
        ret.func_74768_a("color", this.color);
        ret.func_74768_a("maxEnergy", this.maxEnergy);
        ret.func_74768_a("energy", this.energyStorage.getEnergyStored());
        return ret;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt.func_74775_l("inventory"));
        this.upgrades.deserializeNBT(nbt.func_74775_l("upgrades"));
        this.color = nbt.func_74762_e("color");
        this.maxEnergy = nbt.func_74762_e("maxEnergy");
        this.energyStorage.extractEnergy(Integer.MAX_VALUE, false);
        this.energyStorage.receiveEnergy(nbt.func_74762_e("energy"), false);
    }

    @Override
    public NBTTagCompound serializeSync() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("color", this.color);
        tag.func_74782_a("upgrades", (NBTBase)this.upgrades.serializeNBT());
        tag.func_74768_a("energyMax", this.maxEnergy);
        tag.func_74768_a("energy", this.energyStorage.getEnergyStored());
        return tag;
    }

    @Override
    public void deserializeSync(NBTTagCompound tag) {
        this.color = tag.func_74762_e("color");
        this.upgrades.deserializeNBT(tag.func_74775_l("upgrades"));
        this.maxEnergy = tag.func_74762_e("energyMax");
        this.energyStorage.extractEnergy(Integer.MAX_VALUE, false);
        this.energyStorage.receiveEnergy(tag.func_74762_e("energy"), false);
    }

    private class EnergyStorageNBT
    extends EnergyStorage {
        private final ItemStack stack;

        private EnergyStorageNBT(ItemStack stack) {
            super(0);
            this.stack = stack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.getMaxEnergyStored() <= 0) {
                return 0;
            }
            int energyReceived = Math.min(this.getMaxEnergyStored() - this.getEnergyStored(), Math.min(this.getMaxEnergyStored(), maxReceive));
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() + energyReceived);
            }
            return energyReceived;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (this.getMaxEnergyStored() <= 0) {
                return 0;
            }
            int energyExtracted = Math.min(this.getEnergyStored(), Math.min(this.maxExtract, this.getMaxEnergyStored()));
            if (!simulate) {
                this.setEnergyStored(this.getEnergyStored() - energyExtracted);
            }
            return energyExtracted;
        }

        public int getEnergyStored() {
            return this.stack.func_77942_o() ? this.stack.func_77978_p().func_74762_e("vsb:energy") : 0;
        }

        void setEnergyStored(int value) {
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
            this.stack.func_77978_p().func_74768_a("vsb:energy", value);
        }
    }

    private class NBTItemHandler
    implements IItemHandler,
    IItemHandlerModifiable,
    INBTSerializable<NBTTagCompound> {
        private final ItemStack stack;
        private final int slots;
        private final ItemStackHandler inventory;

        private NBTItemHandler(ItemStack stack, int slots) {
            this.stack = stack;
            this.slots = slots;
            this.inventory = new ItemStackHandler(slots){

                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    NBTItemHandler.this.markDirty();
                }
            };
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if (stack.func_77978_p().func_74764_b("vsb:nbtItemHandler")) {
                this.inventory.deserializeNBT(stack.func_77978_p().func_74775_l("vsb:nbtItemHandler"));
            }
        }

        public int getSlots() {
            return this.slots;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.inventory.getStackInSlot(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.inventory.setStackInSlot(slot, stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.inventory.insertItem(slot, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.inventory.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.inventory.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.inventory.isItemValid(slot, stack);
        }

        public void markDirty() {
            if (!this.stack.func_77942_o()) {
                this.stack.func_77982_d(new NBTTagCompound());
            }
            this.stack.func_77978_p().func_74782_a("vsb:nbtItemHandler", (NBTBase)this.inventory.serializeNBT());
        }

        public NBTTagCompound serializeNBT() {
            return this.inventory.serializeNBT();
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("vsb:nbtItemHandler")) {
                this.inventory.deserializeNBT(nbt.func_74775_l("vsb:nbtItemHandler"));
            } else {
                this.inventory.deserializeNBT(nbt);
            }
        }
    }

    private class Wrapper
    implements IBackpackWrapper {
        private Wrapper() {
        }

        @Override
        public IBackpack getSelfAsCapability() {
            return Backpack.this;
        }

        @Override
        public IUpgradeWrapper[] getReadonlyUpdatesArray() {
            return VSBUtils.capabilityToArray(Backpack.this.upgrades, IUpgradeWrapper.class, i -> i.func_77973_b() instanceof IUpgrade ? new UpgradeWrapper((ItemStack)i) : null);
        }

        @Override
        public ItemStack[] getReadonlyInventory() {
            return VSBUtils.capabilityToArray(Backpack.this.inventory, ItemStack.class, i -> i);
        }

        @Override
        public ItemStack getSelf() {
            return Backpack.this.self;
        }

        @Override
        public IItemHandler getInventory() {
            return Backpack.this.inventory;
        }

        @Override
        public IItemHandler getUpgradesInventory() {
            return Backpack.this.upgrades;
        }

        @Override
        public EnumBackpackType getBackpackType() {
            return Backpack.this.backpackType;
        }

        @Override
        public int getMaxUpgrades() {
            return Backpack.this.backpackType.getUpgradesSize();
        }

        @Override
        public NBTTagCompound getUpgradesSyncTag() {
            return Backpack.this.upgradesClientTag;
        }

        @Override
        public int getColor() {
            return Backpack.this.color;
        }

        @Override
        public void setColor(int newColor) {
            Backpack.this.color = newColor;
        }

        @Override
        public int getMaxEnergy() {
            return Backpack.this.maxEnergy;
        }

        @Override
        public void setMaxEnergy(int i) {
            Backpack.this.maxEnergy = i;
        }

        @Override
        public void markInventoryDirty() {
            Backpack.this.inventory.markDirty();
        }
    }

    private class UpgradeWrapper
    implements IUpgradeWrapper {
        private final ItemStack upgrade;

        private UpgradeWrapper(ItemStack upgrade) {
            this.upgrade = upgrade;
        }

        @Override
        public IBackpackWrapper getContainer() {
            return Backpack.this.createWrapper();
        }

        @Override
        public IUpgrade getUpgrade() {
            return (IUpgrade)this.upgrade.func_77973_b();
        }

        @Override
        public ItemStack getSelf() {
            return this.upgrade;
        }
    }
}

