/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.item.torchmagic;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.item.core.BaseTool;
import com.lothrazar.cyclicmagic.item.torchmagic.EntityTorchBolt;
import com.lothrazar.cyclicmagic.registry.ItemRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilEntity;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilSound;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class ItemTorchThrower
extends BaseTool
implements IHasRecipe,
IContent {
    private static final float VELOCITY_DEFAULT = 1.5f;
    private static final float INACCURACY_DEFAULT = 1.0f;
    private static final float PITCHOFFSET = 0.0f;
    private static final int COOLDOWN = 8;
    private boolean enabled;

    public ItemTorchThrower() {
        super(256);
    }

    @Override
    public String getContentName() {
        return "tool_torch_launcher";
    }

    @Override
    public void register() {
        ItemRegistry.register(this, this.getContentName());
        EntityTorchBolt.register();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean("TorchLauncher", "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            EntityTorchBolt thing = new EntityTorchBolt(world, (EntityLivingBase)player, true);
            thing.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
            world.func_72838_d((Entity)thing);
        }
        UtilSound.playSound(player, player.func_180425_c(), SoundEvents.field_187511_aA, SoundCategory.PLAYERS);
        UtilEntity.setCooldownItem(player, this, 8);
        super.onUse(stack, player, world, hand);
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Item)this), " gc", " cg", "l  ", Character.valueOf('g'), "ingotGold", Character.valueOf('c'), "blockCoal", Character.valueOf('l'), "logWood");
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof EntityPlayer) {
            ItemStack torches;
            EntityPlayer player = (EntityPlayer)entityIn;
            if (stack.func_77951_h() && !(torches = this.findAmmo(player, Item.func_150898_a((Block)Blocks.field_150478_aa))).func_190926_b()) {
                torches.func_190918_g(1);
                UtilItemStack.repairItem(player, stack);
            }
        }
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = new ItemStack(Blocks.field_150402_ci);
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }
}

