/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclicmagic.block.imbue;

import com.lothrazar.cyclicmagic.IContent;
import com.lothrazar.cyclicmagic.ModCyclic;
import com.lothrazar.cyclicmagic.block.core.BlockBaseHasTile;
import com.lothrazar.cyclicmagic.block.core.IBlockHasTESR;
import com.lothrazar.cyclicmagic.block.imbue.ImbueTESR;
import com.lothrazar.cyclicmagic.block.imbue.RecipeImbue;
import com.lothrazar.cyclicmagic.block.imbue.TileEntityImbue;
import com.lothrazar.cyclicmagic.data.IHasRecipe;
import com.lothrazar.cyclicmagic.guide.GuideCategory;
import com.lothrazar.cyclicmagic.item.dynamite.ExplosionBlockSafe;
import com.lothrazar.cyclicmagic.registry.BlockRegistry;
import com.lothrazar.cyclicmagic.registry.RecipeRegistry;
import com.lothrazar.cyclicmagic.util.UtilChat;
import com.lothrazar.cyclicmagic.util.UtilItemStack;
import com.lothrazar.cyclicmagic.util.UtilNBT;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockImbue
extends BlockBaseHasTile
implements IBlockHasTESR,
IHasRecipe,
IContent {
    static final String NBT_IMBUE = "CYCLIC_IMBUE";
    private static final String NBT_IMBUE_CHARGE = "CYCLIC_CHARGE";
    static List<RecipeImbue> recipes = new ArrayList<RecipeImbue>();
    private boolean enabled;

    public BlockImbue() {
        super(Material.field_151576_e);
        this.setTranslucent();
        RecipeImbue.initAllRecipes();
    }

    public TileEntity createTileEntity(World worldIn, IBlockState state) {
        return new TileEntityImbue();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return false;
        }
        boolean success = false;
        ItemStack held = player.func_184586_b(hand);
        TileEntityImbue te = (TileEntityImbue)world.func_175625_s(pos);
        if (held.func_190926_b()) {
            if (!te.func_70301_a(0).func_190926_b()) {
                player.func_184611_a(hand, te.func_70301_a(0));
                te.func_70299_a(0, ItemStack.field_190927_a);
                success = true;
            } else {
                for (int i = 1; i < te.func_70302_i_(); ++i) {
                    if (te.func_70301_a(i).func_190926_b()) continue;
                    UtilItemStack.dropItemStackInWorld(world, pos, te.func_70301_a(i));
                    te.func_70299_a(i, ItemStack.field_190927_a);
                    return true;
                }
                UtilChat.addChatMessage(player, "imbue.recipes");
                for (RecipeImbue irecipe : recipes) {
                    UtilChat.addChatMessage(player, irecipe.toString());
                }
            }
        } else if (held.func_77973_b() instanceof ItemBow && te.func_70301_a(0).func_190926_b()) {
            te.func_70299_a(0, held);
            player.func_184611_a(hand, ItemStack.field_190927_a);
            success = true;
        } else {
            for (int slot = 1; slot < te.func_70302_i_(); ++slot) {
                if (!te.func_70301_a(slot).func_190926_b()) continue;
                te.func_70299_a(slot, held);
                player.func_184611_a(hand, ItemStack.field_190927_a);
                success = true;
                break;
            }
        }
        return success || super.func_180639_a(world, pos, state, player, hand, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityImbue.class, (TileEntitySpecialRenderer)new ImbueTESR());
    }

    public static ImbueFlavor getImbueType(ItemStack held) {
        if (held.func_77978_p() == null) {
            return null;
        }
        if (!held.func_77978_p().func_74764_b(NBT_IMBUE)) {
            return null;
        }
        int val = held.func_77978_p().func_74762_e(NBT_IMBUE);
        return ImbueFlavor.values()[val];
    }

    public static void setImbue(ItemStack held, RecipeImbue found) {
        UtilNBT.getItemStackNBT(held).func_74768_a(NBT_IMBUE, found.flavor.ordinal());
    }

    public static void setImbueCharge(ItemStack held, int found) {
        UtilNBT.getItemStackNBT(held).func_74768_a(NBT_IMBUE_CHARGE, found);
    }

    public static int getImbueCharge(ItemStack held) {
        if (held.func_77978_p() == null) {
            return 0;
        }
        return held.func_77978_p().func_74762_e(NBT_IMBUE_CHARGE);
    }

    @SubscribeEvent
    public void onProjectileImpactEvent(ProjectileImpactEvent.Arrow event) {
        Entity trg = event.getRayTraceResult().field_72308_g;
        if (trg instanceof EntityLivingBase && event.getArrow().getEntityData().func_74764_b(NBT_IMBUE)) {
            EntityLivingBase target = (EntityLivingBase)trg;
            int imbue = event.getArrow().getEntityData().func_74762_e(NBT_IMBUE);
            ImbueFlavor flavor = ImbueFlavor.values()[imbue];
            World world = target.field_70170_p;
            switch (flavor) {
                case GLOWING: {
                    break;
                }
                case EXPLOSION: {
                    ExplosionBlockSafe explosion = new ExplosionBlockSafe(world, event.getArrow().field_70250_c, trg.field_70165_t, trg.field_70163_u, trg.field_70161_v, MathHelper.func_76136_a((Random)world.field_73012_v, (int)1, (int)4), false, true);
                    explosion.func_77278_a();
                    explosion.func_77279_a(false);
                    break;
                }
                case FIRE: {
                    target.func_70015_d(MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)6));
                    break;
                }
                case LEVITATE: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 100, 1));
                    break;
                }
                case NONE: {
                    break;
                }
                case INVISIBILITY: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 100, 1));
                    break;
                }
                case POISON: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 100, 1));
                    break;
                }
                case SLOWNESS: {
                    target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 2));
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityArrow && event.getEntity() != null && !event.getEntity().field_70128_L) {
            EntityArrow arrow = (EntityArrow)event.getEntity();
            if (arrow.field_70250_c instanceof EntityPlayer) {
                EntityPlayer source = (EntityPlayer)arrow.field_70250_c;
                ItemStack bow = source.func_184614_ca();
                ImbueFlavor flavor = BlockImbue.getImbueType(bow);
                int charge = BlockImbue.getImbueCharge(bow);
                if (charge > 0 && flavor != null) {
                    arrow.getEntityData().func_74768_a(NBT_IMBUE, flavor.ordinal());
                    BlockImbue.setImbueCharge(bow, charge - 1);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onItemTooltipEvent(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        ImbueFlavor type = BlockImbue.getImbueType(itemStack);
        if (type == null) {
            return;
        }
        int charge = BlockImbue.getImbueCharge(itemStack);
        if (charge <= 0) {
            itemStack.func_77978_p().func_82580_o(NBT_IMBUE);
            itemStack.func_77978_p().func_82580_o(NBT_IMBUE_CHARGE);
            return;
        }
        event.getToolTip().add(UtilChat.lang("imbue.prefix") + type.getColor() + UtilChat.lang("imbue.type." + type.toString()) + TextFormatting.RESET + " [" + charge + "]");
    }

    public static void addRecipe(RecipeImbue imb) {
        recipes.add(imb);
    }

    @Override
    public String getContentName() {
        return "imbuer";
    }

    @Override
    public void syncConfig(Configuration config) {
        this.enabled = config.getBoolean(this.getContentName(), "cyclicmagic.content", true, " Set false to delete - requires restart");
    }

    @Override
    public void register() {
        ModCyclic.instance.events.register(this);
        BlockRegistry.registerBlock((Block)this, "imbuer", GuideCategory.BLOCK);
        BlockRegistry.registerTileEntity(TileEntityImbue.class, this.getContentName() + "_te");
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public IRecipe addRecipe() {
        return RecipeRegistry.addShapedRecipe(new ItemStack((Block)this, 1), "sbs", "bdb", "sbs", Character.valueOf('d'), "dyeBlue", Character.valueOf('s'), "gemEmerald", Character.valueOf('b'), "glowstone");
    }

    static enum ImbueFlavor {
        NONE,
        LEVITATE,
        EXPLOSION,
        FIRE,
        INVISIBILITY,
        POISON,
        SLOWNESS,
        GLOWING;


        public String toString() {
            return this.name().toLowerCase();
        }

        public TextFormatting getColor() {
            switch (this) {
                case EXPLOSION: {
                    return TextFormatting.GREEN;
                }
                case FIRE: {
                    return TextFormatting.GOLD;
                }
                case GLOWING: {
                    return TextFormatting.YELLOW;
                }
                case INVISIBILITY: {
                    return TextFormatting.BLUE;
                }
                case LEVITATE: {
                    return TextFormatting.AQUA;
                }
                case POISON: {
                    return TextFormatting.DARK_GREEN;
                }
                case SLOWNESS: {
                    return TextFormatting.LIGHT_PURPLE;
                }
            }
            return TextFormatting.BLACK;
        }
    }
}

