/*
 * Decompiled with CFR 0.152.
 */
package de.lellson.roughmobs2.features;

import de.lellson.roughmobs2.ai.combat.RoughAIFlameTouch;
import de.lellson.roughmobs2.config.RoughConfig;
import de.lellson.roughmobs2.features.EntityFeatures;
import de.lellson.roughmobs2.misc.FeatureHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;

public class BlazeFeatures
extends EntityFeatures {
    private boolean pushAttackersAway;
    private boolean flameTouch;
    private float deathExplosionStrength;

    public BlazeFeatures() {
        super("blaze", EntityBlaze.class);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.pushAttackersAway = RoughConfig.getBoolean(this.name, "PushAttackersAway", true, "Set to false to prevent %ss from pushing attackers away");
        this.flameTouch = RoughConfig.getBoolean(this.name, "FlameTouch", true, "Set to false to prevent %ss from igniting entities which touch their hitbox");
        this.deathExplosionStrength = RoughConfig.getFloat(this.name, "DeathExplosionStrength", 1.0f, 0.0f, 32767.0f, "Explosion strength of the explosions, which %ss create on death\nSet to 0 to disable this feature");
    }

    @Override
    public void addAI(EntityJoinWorldEvent event, Entity entity, EntityAITasks tasks, EntityAITasks targetTasks) {
        if (entity instanceof EntityLiving && this.flameTouch) {
            tasks.func_75776_a(1, (EntityAIBase)new RoughAIFlameTouch((EntityLiving)entity));
        }
    }

    @Override
    public void onDefend(Entity target, Entity attacker, Entity immediateAttacker, LivingAttackEvent event) {
        if (this.pushAttackersAway && attacker instanceof EntityLivingBase && attacker == immediateAttacker) {
            FeatureHelper.knockback(target, (EntityLivingBase)attacker, 1.0f, 0.05f);
            attacker.func_70097_a(DamageSource.field_76377_j, 4.0f);
            attacker.func_70015_d(8);
            FeatureHelper.playSound(target, SoundEvents.field_187646_bt, 0.7f, 1.0f);
        }
    }

    @Override
    public void onDeath(Entity deadEntity, DamageSource source) {
        if (this.deathExplosionStrength > 0.0f && !(source.func_76346_g() instanceof FakePlayer)) {
            deadEntity.field_70170_p.func_72876_a(deadEntity, deadEntity.field_70165_t, deadEntity.field_70163_u, deadEntity.field_70161_v, this.deathExplosionStrength, true);
        }
    }
}

