/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.block;

import epicsquid.mysticallib.LibRegistry;
import epicsquid.mysticallib.block.CustomStateMapper;
import epicsquid.mysticallib.block.IBlock;
import epicsquid.mysticallib.item.ItemBlockSlab;
import epicsquid.mysticallib.model.CustomModelBlock;
import epicsquid.mysticallib.model.CustomModelLoader;
import epicsquid.mysticallib.model.ICustomModeledObject;
import epicsquid.mysticallib.model.IModeledObject;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import epicsquid.mysticallib.model.block.BakedModelSlab;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSlabBase
extends BlockSlab
implements IBlock,
IModeledObject,
ICustomModeledObject {
    public static BlockSlabBase dummy = new BlockSlabBase(Material.field_151579_a, SoundType.field_185856_i, 0.0f, "null", Blocks.field_150350_a.func_176223_P(), false, Blocks.field_150350_a);
    private final Item itemBlock;
    public List<ItemStack> drops = null;
    private boolean isOpaque = false;
    private boolean hasCustomModel = false;
    @Nonnull
    private BlockRenderLayer layer = BlockRenderLayer.SOLID;
    private boolean isFlammable = false;
    private boolean isDouble;
    private IBlockState parent;
    public String name = "";
    public Block slab = null;

    public BlockSlabBase(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name, @Nonnull IBlockState parent, boolean isDouble, @Nullable Block slab) {
        super(mat);
        this.isDouble = isDouble;
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149672_a(type);
        this.func_149711_c(hardness);
        this.func_149713_g(0);
        this.setOpacity(false);
        this.field_149787_q = false;
        this.parent = parent;
        this.slab = slab;
        this.itemBlock = !isDouble ? (Item)new ItemBlockSlab((Block)this, slab).setRegistryName(LibRegistry.getActiveModid(), name) : null;
    }

    @Nonnull
    public IBlockState getParent() {
        return this.parent;
    }

    @Nonnull
    public BlockSlabBase setFlammable(boolean flammable) {
        this.isFlammable = flammable;
        return this;
    }

    @Nonnull
    public BlockSlabBase setResistance(float resistance) {
        super.func_149752_b(resistance);
        return this;
    }

    public void func_149666_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> items) {
        if (tab == this.func_149708_J() && !this.isDouble) {
            items.add((Object)new ItemStack((Block)this, 1));
        }
    }

    @Nonnull
    public Block func_149647_a(@Nonnull CreativeTabs tab) {
        if (!this.isDouble) {
            this.itemBlock.func_77637_a(tab);
        }
        return super.func_149647_a(tab);
    }

    public void getDrops(@Nonnull NonNullList<ItemStack> drops, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull IBlockState state, int fortune) {
        if (this.isDouble) {
            drops.add((Object)new ItemStack(Item.func_150898_a((Block)this.slab), 1));
            drops.add((Object)new ItemStack(Item.func_150898_a((Block)this.slab), 1));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    @Nonnull
    public BlockSlabBase setModelCustom(boolean custom) {
        this.hasCustomModel = custom;
        return this;
    }

    @Nonnull
    public BlockSlabBase setHarvestReqs(@Nonnull String tool, int level) {
        this.setHarvestLevel(tool, level);
        return this;
    }

    @Nonnull
    public BlockSlabBase setOpacity(boolean isOpaque) {
        this.isOpaque = isOpaque;
        return this;
    }

    @Nonnull
    public BlockSlabBase setLayer(@Nonnull BlockRenderLayer layer) {
        this.layer = layer;
        return this;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return this.isOpaque;
    }

    public boolean hasCustomModel() {
        return this.hasCustomModel;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    public void setSlab(@Nonnull Block slab) {
        this.slab = slab;
    }

    public boolean isFlammable(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return this.isFlammable || super.isFlammable(world, pos, face);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.isFlammable ? 100 : super.getFlammability(world, pos, face);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        if (this.hasCustomModel) {
            ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new CustomStateMapper());
        }
        if (!this.hasCustomModel) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "handlers"));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initCustomModel() {
        if (this.hasCustomModel) {
            ResourceLocation defaultTex = new ResourceLocation(this.parent.func_177230_c().getRegistryName().func_110624_b() + ":blocks/" + this.parent.func_177230_c().getRegistryName().func_110623_a());
            if (this.isDouble) {
                CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.getRegistryName().func_110623_a()), new CustomModelBlock(this.getModelClass(1), defaultTex, defaultTex));
                CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.getRegistryName().func_110623_a() + "#handlers"), new CustomModelBlock(this.getModelClass(1), defaultTex, defaultTex));
            } else {
                CustomModelLoader.blockmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":models/block/" + this.getRegistryName().func_110623_a()), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
                CustomModelLoader.itemmodels.put(new ResourceLocation(this.getRegistryName().func_110624_b() + ":" + this.getRegistryName().func_110623_a() + "#handlers"), new CustomModelBlock(this.getModelClass(), defaultTex, defaultTex));
            }
        }
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return this.getModelClass(0);
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass(int type) {
        if (type == 1) {
            return BakedModelBlock.class;
        }
        return BakedModelSlab.class;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return this.layer;
    }

    @Override
    @Nullable
    public Item getItemBlock() {
        return this.itemBlock;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        IBlockState iblockstate = this.func_176223_P();
        if (!this.func_176552_j()) {
            iblockstate = iblockstate.func_177226_a((IProperty)field_176554_a, (Comparable)(meta == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }
        return iblockstate;
    }

    public int func_176201_c(@Nullable IBlockState state) {
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.BOTTOM ? 0 : 1;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a});
    }

    @Nonnull
    public String func_150002_b(int meta) {
        return super.func_149739_a();
    }

    public boolean func_176552_j() {
        return this.isDouble;
    }

    @Nonnull
    public IProperty<?> func_176551_l() {
        return field_176554_a;
    }

    @Nonnull
    public Comparable<?> func_185674_a(@Nonnull ItemStack stack) {
        return 0;
    }
}

