/*
 * Decompiled with CFR 0.152.
 */
package net.samtrion.compactdrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGeometry;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.dynamic.StatusModelData;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.samtrion.compactdrawers.item.ItemCompactDrawer;

public abstract class BlockCompactDrawerBase
extends BlockDrawers {
    private final int drawerCapacity;
    private final String registryName;
    @SideOnly(value=Side.CLIENT)
    private StatusModelData statusInfo;

    protected BlockCompactDrawerBase(String registryName, String blockName, int drawerCapacity) {
        super(Material.field_151576_e, registryName, BlockCompactDrawerBase.checkBlockName(blockName));
        this.func_149672_a(SoundType.field_185851_d);
        this.registryName = registryName;
        this.drawerCapacity = drawerCapacity;
    }

    private static String checkBlockName(String blockName) {
        return (blockName.startsWith("compactdrawers.") ? blockName : "compactdrawers." + blockName).toLowerCase();
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.func_149686_d(state)) {
            return true;
        }
        TileEntityDrawers tile = this.getTileEntity(world, pos);
        return tile != null && tile.getDirection() == face.func_176734_d().func_176745_a();
    }

    public int getDrawerBaseStorage() {
        return this.drawerCapacity;
    }

    public IDrawerGeometry getDrawerGeometry(IBlockState state, PropertyEnum<?> slots) {
        return (IDrawerGeometry)state.func_177229_b(slots);
    }

    protected int getDrawerSlot(int drawerCount, int side, float hitX, float hitY, float hitZ) {
        if (drawerCount == 2 && !this.hitTop(hitY)) {
            return 1;
        }
        if (drawerCount == 3) {
            if (!this.hitTop(hitY)) {
                return this.hitLeft(side, hitX, hitZ) ? 1 : 2;
            }
        } else if (drawerCount == 4) {
            if (!this.hitTop(hitY)) {
                return this.hitLeft(side, hitX, hitZ) ? 2 : 3;
            }
            if (!this.hitLeft(side, hitX, hitZ)) {
                return 1;
            }
        }
        return 0;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public String getName() {
        return this.registryName;
    }

    public StatusModelData getStatusInfo(IBlockState state) {
        return this.statusInfo;
    }

    public void func_149666_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        list.add((Object)ItemCompactDrawer.createStackWithNBT(new ItemStack((Block)this, 1, 0)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initDynamic() {
        ResourceLocation location = new ResourceLocation("compactdrawers", "models/dynamic/" + this.registryName + ".json");
        IBlockState state = this.func_176223_P();
        this.statusInfo = new StatusModelData(this.getDrawerCount(state), location);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.func_149662_c(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.isHalfDepth(state);
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.func_149686_d(state)) {
            return true;
        }
        TileEntityDrawers tile = this.getTileEntity(blockAccess, pos);
        if (tile != null && tile.getDirection() == side.func_176745_a()) {
            return true;
        }
        return super.func_176225_a(state, blockAccess, pos, side);
    }
}

