/*
 * Decompiled with CFR 0.152.
 */
package arcaratus.bloodarsenal.tile;

import arcaratus.bloodarsenal.ConfigHandler;
import arcaratus.bloodarsenal.energy.EnergyStorage;
import arcaratus.bloodarsenal.tile.TileInventory;
import arcaratus.bloodarsenal.util.BloodArsenalUtils;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileBloodCapacitor
extends TileInventory
implements ITickable {
    private EnergyStorage energyStorage;
    public int amountRecv;
    public int amountSend;

    public TileBloodCapacitor() {
        super(2, "blood_capacitor");
        this.energyStorage = new EnergyStorage(ConfigHandler.values.bloodCapacitorStorage);
        this.amountRecv = ConfigHandler.values.bloodCapacitorTransfer;
        this.amountSend = ConfigHandler.values.bloodCapacitorTransfer;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
            this.transferEnergy();
        }
    }

    protected void transferEnergy() {
        for (int i = 0; i < 6 && this.energyStorage.getEnergyStored() > 0; ++i) {
            this.energyStorage.modifyEnergyStored(-BloodArsenalUtils.insertEnergyIntoAdjacentEnergyReceiver((TileEntity)this, EnumFacing.field_82609_l[i], Math.min(this.amountSend, this.energyStorage.getEnergyStored()), false));
        }
    }

    public final void setEnergyStored(int quantity) {
        this.energyStorage.setEnergyStored(quantity);
    }

    @Override
    public void deserialize(NBTTagCompound nbt) {
        super.deserialize(nbt);
        this.energyStorage.readFromNBT(nbt);
        this.amountRecv = nbt.func_74762_e("Recv");
        this.amountSend = nbt.func_74762_e("Send");
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound nbt) {
        super.serialize(nbt);
        this.energyStorage.writeToNBT(nbt);
        nbt.func_74768_a("Recv", this.amountRecv);
        nbt.func_74768_a("Send", this.amountSend);
        return nbt;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, from);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing from) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new IEnergyStorage(){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    return TileBloodCapacitor.this.receiveEnergy(maxReceive, simulate);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public int getEnergyStored() {
                    return TileBloodCapacitor.this.getEnergyStored();
                }

                public int getMaxEnergyStored() {
                    return TileBloodCapacitor.this.getMaxEnergyStored();
                }

                public boolean canExtract() {
                    return false;
                }

                public boolean canReceive() {
                    return true;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

