/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.utils;

import com.google.common.collect.Lists;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.utils.Chance;
import insane96mcp.mpr.json.utils.JItem;
import insane96mcp.mpr.json.utils.RangeMinMax;
import insane96mcp.mpr.lib.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class JEnchantment
implements IJsonObject {
    public String id;
    public RangeMinMax level;
    public Chance chance;

    public String toString() {
        return String.format("Enchantment{id: %s, level: %s, chance: %s}", this.id, this.level, this.chance);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.id == null) {
            throw new InvalidJsonException("Missing Enchantment ID for " + this, file);
        }
        if (this.id != "random" && Enchantment.func_180305_b((String)this.id) == null) {
            Logger.Warning("Failed to find enchantment with id " + this.id);
        }
        if (this.level != null) {
            this.level.Validate(file);
        } else {
            Logger.Debug("Missing Enchantment Level for " + this + ". Will default to 1");
            this.level = new RangeMinMax(1, 1);
        }
        if (this.chance == null) {
            throw new InvalidJsonException("Missing chance for " + this, file);
        }
        this.chance.Validate(file);
    }

    public static void Apply(EntityLiving entity, World world, Random random, JItem item, ItemStack itemStack) {
        for (JEnchantment jEnchantment : item.enchantments) {
            if (!jEnchantment.chance.ChanceMatches(entity, world, random)) continue;
            if (jEnchantment.id.equals("random")) {
                ArrayList list = Lists.newArrayList();
                for (Enchantment enchantment : Enchantment.field_185264_b) {
                    if (itemStack.func_77973_b() != Items.field_151134_bR && !enchantment.func_92089_a(itemStack)) continue;
                    list.add(enchantment);
                }
                if (list.isEmpty()) {
                    Logger.Warning("Couldn't find a compatible enchantment for " + item);
                    continue;
                }
                Enchantment choosenEnch = (Enchantment)list.get(random.nextInt(list.size()));
                int level = MathHelper.func_76136_a((Random)random, (int)choosenEnch.func_77319_d(), (int)choosenEnch.func_77325_b());
                if (itemStack.func_77973_b() == Items.field_151134_bR) {
                    ItemEnchantedBook.func_92115_a((ItemStack)itemStack, (EnchantmentData)new EnchantmentData(choosenEnch, level));
                    continue;
                }
                itemStack.func_77966_a(choosenEnch, level);
                continue;
            }
            int level = MathHelper.func_76136_a((Random)random, (int)((int)jEnchantment.level.GetMin()), (int)((int)jEnchantment.level.GetMax()));
            itemStack.func_77966_a(Enchantment.func_180305_b((String)jEnchantment.id), level);
        }
    }
}

