/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.utils;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.utils.RangeMinMax;
import insane96mcp.mpr.lib.Logger;
import java.io.File;
import java.util.UUID;
import net.minecraft.inventory.EntityEquipmentSlot;

public class ItemAttribute
implements IJsonObject {
    public String modifier;
    @SerializedName(value="attribute_name")
    public String attributeName;
    public EnumOperation operation;
    public RangeMinMax amount;
    public UUID id;
    public EntityEquipmentSlot slot;

    public String toString() {
        return String.format("ItemAttribute{modifier: %s, attributeName: %s, operation: %s, amount: %s, id: %s, slot: %s}", new Object[]{this.modifier, this.attributeName, this.operation, this.amount, this.id, this.slot});
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.modifier == null) {
            throw new InvalidJsonException("Missing modifier name for " + this, file);
        }
        if (this.attributeName == null) {
            throw new InvalidJsonException("Missing attribute name for " + this, file);
        }
        if (this.operation == null) {
            throw new InvalidJsonException("Missing modifier operation for " + this, file);
        }
        if (this.amount == null) {
            throw new InvalidJsonException("Missing Amount for " + this, file);
        }
        this.amount.Validate(file);
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        if (this.slot == null) {
            Logger.Debug("Missing Equipment Slot for " + this + ". Will now default to the item equipment slot");
        }
    }

    public static enum EnumOperation {
        ADDITION,
        MULTIPLY_BASE,
        MULTIPLY_TOTAL;

    }
}

