/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.Mob;
import insane96mcp.mpr.json.utils.Chance;
import insane96mcp.mpr.json.utils.RangeMinMax;
import insane96mcp.mpr.json.utils.Utils;
import insane96mcp.mpr.lib.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class JPotionEffect
implements IJsonObject {
    public String id;
    public RangeMinMax amplifier;
    public Chance chance;
    public boolean ambient;
    @SerializedName(value="hide_particles")
    public boolean hideParticles;
    public List<Integer> dimensions;
    private List<String> biomes;
    public transient List<Biome> biomesList;

    public String toString() {
        return String.format("PotionEffect{id: %s, amplifier: %s, chance: %s, ambient: %s, hideParticles: %s, dimensions: %s, biomes: %s}", this.id, this.amplifier, this.chance, this.ambient, this.hideParticles, this.dimensions, this.biomes);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.id == null) {
            throw new InvalidJsonException("Missing Potion Effect Id for " + this.toString(), file);
        }
        if (Potion.func_180142_b((String)this.id) == null) {
            throw new InvalidJsonException("Potion effect with Id " + this.id + " does not exist", file);
        }
        if (this.amplifier == null) {
            Logger.Debug("Missing Amplifier from " + this.toString() + ". Creating a new one with min and max set to 0");
            this.amplifier = new RangeMinMax(0, 0);
        }
        this.amplifier.Validate(file);
        if (this.chance != null) {
            this.chance.Validate(file);
        }
        if (this.ambient && this.hideParticles) {
            Logger.Info("Particles are hidden, but ambient is enabled. This might be an unintended behaviour for " + this.toString());
        }
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Integer>();
        }
        this.biomesList = new ArrayList<Biome>();
        if (this.biomes == null) {
            this.biomes = new ArrayList<String>();
        } else {
            for (String biome : this.biomes) {
                ResourceLocation biomeLoc = new ResourceLocation(biome);
                Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)biomeLoc);
                this.biomesList.add(b);
            }
        }
    }

    public static void Apply(EntityLiving entity, World world, Random random) {
        if (world.field_72995_K) {
            return;
        }
        for (Mob mob : Mob.mobs) {
            if (!Utils.MatchesEntity(entity, world, random, mob)) continue;
            for (JPotionEffect potionEffect : mob.potionEffects) {
                if (!potionEffect.chance.ChanceMatches(entity, world, random) || !Utils.doesDimensionMatch((Entity)entity, potionEffect.dimensions) || !Utils.doesBiomeMatch(entity, potionEffect.biomesList)) continue;
                int minAmplifier = (int)potionEffect.amplifier.GetMin();
                int maxAmplifier = (int)potionEffect.amplifier.GetMax();
                Potion potion = Potion.func_180142_b((String)potionEffect.id);
                PotionEffect effect = new PotionEffect(potion, 1000000, MathHelper.func_76136_a((Random)random, (int)minAmplifier, (int)maxAmplifier), potionEffect.ambient, !potionEffect.hideParticles);
                entity.func_70690_d(effect);
            }
        }
    }
}

