/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json;

import com.google.gson.Gson;
import insane96mcp.mpr.MobsPropertiesRandomness;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.lib.Logger;
import insane96mcp.mpr.utils.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class Group
implements IJsonObject {
    public static ArrayList<Group> groups = new ArrayList();
    public String name;
    public List<String> mobs;

    public static boolean DoesGroupExist(String name) {
        for (Group group : groups) {
            if (!group.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return String.format("Group{name: %s, mobs: %s}", this.name, this.mobs);
    }

    public static boolean LoadGroups() {
        File groupsFolder = new File(MobsPropertiesRandomness.configPath + "groups");
        if (!groupsFolder.exists()) {
            groupsFolder.mkdir();
        }
        groups.clear();
        boolean correctlyReloaded = true;
        Gson gson = new Gson();
        ArrayList<File> gropusFiles = Utils.ListFilesForFolder(groupsFolder);
        for (File file : gropusFiles) {
            if (file.getName().startsWith("_")) continue;
            try {
                Logger.Debug("Reading file " + file.getName());
                FileReader fileReader = new FileReader(file);
                Group group = (Group)gson.fromJson((Reader)fileReader, Group.class);
                Logger.Debug(group.toString());
                group.Validate(file);
                groups.add(group);
            }
            catch (Exception e) {
                correctlyReloaded = false;
                Logger.Error("Failed to parse file with name " + file.getName());
                Logger.Error(e.toString());
                e.printStackTrace();
            }
        }
        if (correctlyReloaded) {
            Logger.Info("Reloaded All Groups");
        } else {
            Logger.Info("Reloaded All Groups with errors");
        }
        return correctlyReloaded;
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.name == null) {
            throw new InvalidJsonException("Missing group name", file);
        }
        if (Group.DoesGroupExist(this.name)) {
            throw new InvalidJsonException("Group name " + this.name + " already exist", file);
        }
        if (this.mobs == null || this.mobs.isEmpty()) {
            throw new InvalidJsonException("Group " + this.name + " is missing or has no mobs in the list", file);
        }
    }
}

