/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.MobsPropertiesRandomness;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.Mob;
import insane96mcp.mpr.json.utils.Difficulty;
import insane96mcp.mpr.json.utils.RangeMinMax;
import insane96mcp.mpr.json.utils.Utils;
import insane96mcp.mpr.lib.Logger;
import insane96mcp.mpr.lib.Properties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Attribute
implements IJsonObject {
    public String id;
    public RangeMinMax modifier;
    @SerializedName(value="is_flat")
    public boolean isFlat;
    @SerializedName(value="affected_by_difficulty")
    public boolean affectedByDifficulty;
    public Difficulty difficulty;
    public List<Integer> dimensions;
    private List<String> biomes;
    public transient List<Biome> biomesList;

    public String toString() {
        return String.format("Attribute{id: %s, modifier: %s, isFlat: %b, affectedByDifficulty: %b, difficulty: %s, dimensions: %s, biomes: %s}", this.id, this.modifier, this.isFlat, this.affectedByDifficulty, this.difficulty, this.dimensions, this.biomes);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.id == null) {
            throw new InvalidJsonException("Missing Attribute Id for " + this.toString(), file);
        }
        if (this.modifier == null) {
            throw new InvalidJsonException("Missing Modifier (Min/Max) Id for " + this.toString(), file);
        }
        this.modifier.Validate(file);
        if (!this.affectedByDifficulty) {
            if (this.difficulty == null) {
                Logger.Debug("Difficulty Object is missing, affected_by_difficulty will be false for " + this.toString());
            } else {
                Logger.Debug("Difficulty Object is present, affected_by_difficulty will be true for " + this.toString());
                this.affectedByDifficulty = true;
                this.difficulty.Validate(file);
            }
        } else if (this.difficulty == null) {
            this.difficulty = new Difficulty();
        }
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Integer>();
        }
        this.biomesList = new ArrayList<Biome>();
        if (this.biomes == null) {
            this.biomes = new ArrayList<String>();
        } else {
            for (String biome : this.biomes) {
                ResourceLocation biomeLoc = new ResourceLocation(biome);
                Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)biomeLoc);
                this.biomesList.add(b);
            }
        }
    }

    public static void Apply(EntityLiving entity, World world, Random random) {
        if (world.field_72995_K) {
            return;
        }
        for (Mob mob : Mob.mobs) {
            if (!Utils.MatchesEntity(entity, world, random, mob)) continue;
            for (Attribute attribute : mob.attributes) {
                IAttributeInstance attributeInstance;
                if (!Utils.doesDimensionMatch((Entity)entity, attribute.dimensions) || !Utils.doesBiomeMatch(entity, attribute.biomesList)) continue;
                float min = attribute.modifier.GetMin();
                float max = attribute.modifier.GetMax();
                if (attribute.affectedByDifficulty) {
                    EnumDifficulty difficulty = world.func_175659_aa();
                    if (!attribute.difficulty.isLocalDifficulty) {
                        switch (difficulty) {
                            case EASY: {
                                if (!attribute.difficulty.affectsMaxOnly) {
                                    min *= Properties.config.difficulty.easyMultiplier;
                                }
                                max *= Properties.config.difficulty.easyMultiplier;
                                break;
                            }
                            case NORMAL: {
                                if (!attribute.difficulty.affectsMaxOnly) {
                                    min *= Properties.config.difficulty.normalMultiplier;
                                }
                                max *= Properties.config.difficulty.normalMultiplier;
                                break;
                            }
                            case HARD: {
                                if (!attribute.difficulty.affectsMaxOnly) {
                                    min *= Properties.config.difficulty.hardMultiplier;
                                }
                                max *= Properties.config.difficulty.hardMultiplier;
                                break;
                            }
                        }
                    } else {
                        if (!attribute.difficulty.affectsMaxOnly) {
                            min *= world.func_175649_E(entity.func_180425_c()).func_180168_b();
                        }
                        max *= world.func_175649_E(entity.func_180425_c()).func_180168_b();
                    }
                    max *= attribute.difficulty.multiplier;
                }
                if ((attributeInstance = entity.func_110140_aT().func_111152_a(attribute.id)) == null) {
                    Logger.Warning("Attribute " + attribute.id + " not found for the entity, skipping the attribute");
                    continue;
                }
                float amount = MathHelper.func_151240_a((Random)random, (float)min, (float)max);
                amount = attribute.isFlat ? (float)((double)amount - attributeInstance.func_111126_e()) : (amount /= 100.0f);
                AttributeModifier modifier = new AttributeModifier(UUID.randomUUID(), MobsPropertiesRandomness.RESOURCE_PREFIX + attribute.id, (double)amount, attribute.isFlat ? 0 : 1);
                attributeInstance.func_111121_a(modifier);
                if (!attribute.id.equals("generic.maxHealth")) continue;
                entity.func_70606_j((float)attributeInstance.func_111126_e());
            }
        }
    }
}

