/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.compat;

import com.elytradev.architecture.common.tile.TileShape;
import com.elytradev.probe.api.IProbeData;
import com.elytradev.probe.api.IProbeDataProvider;
import com.elytradev.probe.api.impl.ProbeData;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ProbeDataCompat {
    public static Capability<?> PROBE_CAPABILITY;

    @CapabilityInject(value=IProbeDataProvider.class)
    public static void onProbeDataInjected(Capability<?> capability) {
        PROBE_CAPABILITY = capability;
        MinecraftForge.EVENT_BUS.register(ProbeDataCompat.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(final AttachCapabilitiesEvent<TileEntity> e) {
        if (PROBE_CAPABILITY != null && e.getObject() instanceof TileShape) {
            e.addCapability(new ResourceLocation("architecturecraft", "ShapeProbe"), new ICapabilityProvider(){
                TileShape shape;
                IProbeDataProvider probeDataProvider;
                {
                    this.shape = (TileShape)((Object)e.getObject());
                    this.probeDataProvider = data -> {
                        this.genData(this.shape.baseBlockState, "tooltip.architecturecraft.basematerial", data);
                        this.genData(this.shape.secondaryBlockState, "tooltip.architecturecraft.secondarymaterial", data);
                    };
                }

                public void genData(IBlockState state, String key, List<IProbeData> data) {
                    if (state != null && !(state.func_177230_c() instanceof BlockAir)) {
                        ProbeData probeData = new ProbeData();
                        probeData = probeData.withLabel((ITextComponent)new TextComponentTranslation(key, new Object[]{state.func_177230_c().func_149732_F()}));
                        Item item = Item.func_150898_a((Block)state.func_177230_c());
                        if (item != null) {
                            ItemStack stack = new ItemStack(item);
                            stack.func_77964_b(state.func_177230_c().func_180651_a(state));
                            probeData = probeData.withInventory(ImmutableList.of((Object)stack));
                        }
                        data.add((IProbeData)probeData);
                    }
                }

                public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                    return capability == PROBE_CAPABILITY;
                }

                @Nullable
                public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                    if (capability == PROBE_CAPABILITY) {
                        return (T)this.probeDataProvider;
                    }
                    return null;
                }
            });
        }
    }
}

