/*
 * Decompiled with CFR 0.152.
 */
package com.elytradev.architecture.common.helpers;

import com.elytradev.architecture.common.block.BlockShape;
import com.elytradev.architecture.common.helpers.Vector3;
import com.elytradev.architecture.common.tile.TileShape;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class Utils {
    public static Random random = new Random();

    public static int playerTurn(EntityLivingBase player) {
        return MathHelper.func_76128_c((double)((double)player.field_70177_z * 4.0 / 360.0 + 0.5)) & 3;
    }

    public static int lookTurn(Vector3 look) {
        double a = Math.atan2(look.x, look.z);
        return (int)Math.round(a * 2.0 / Math.PI) & 3;
    }

    public static boolean playerIsInCreativeMode(EntityPlayer player) {
        return player instanceof EntityPlayerMP && ((EntityPlayerMP)player).field_71134_c.func_73083_d();
    }

    public static TextureAtlasSprite getSpriteForBlockState(IBlockState state) {
        if (state != null) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
        }
        return null;
    }

    public static TextureAtlasSprite getSpriteForPos(IBlockAccess world, BlockPos pos, boolean renderPrimary) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState == null) {
            return null;
        }
        if (blockState.func_177230_c() instanceof BlockShape) {
            TileShape shape = TileShape.get(world, pos);
            if (renderPrimary) {
                return Utils.getSpriteForBlockState(shape.baseBlockState);
            }
            return Utils.getSpriteForBlockState(shape.secondaryBlockState);
        }
        if (!renderPrimary) {
            return null;
        }
        return Utils.getSpriteForBlockState(blockState);
    }

    public static String displayNameOfBlock(Block block, int meta) {
        String name = null;
        Item item = Item.func_150898_a((Block)block);
        if (item != null) {
            ItemStack stack = new ItemStack(item, 1, meta);
            name = stack.func_82833_r();
        }
        if (name == null) {
            name = block.func_149732_F();
        }
        return "Cut from " + name;
    }

    public static AxisAlignedBB unionOfBoxes(List<AxisAlignedBB> list) {
        AxisAlignedBB box = list.get(0);
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            box = box.func_111270_a(list.get(i));
        }
        return box;
    }
}

