/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.tasks;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.party.IParty;
import betterquesting.api.questing.party.IPartyDatabase;
import betterquesting.api.questing.tasks.IProgression;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.ItemComparison;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.storage.DBEntry;
import bq_standard.NbtBlockType;
import bq_standard.client.gui.tasks.PanelTaskBlockBreak;
import bq_standard.core.BQ_Standard;
import bq_standard.tasks.factory.FactoryTaskBlockBreak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

public class TaskBlockBreak
implements ITask,
IProgression<int[]> {
    private final List<UUID> completeUsers = new ArrayList<UUID>();
    private final HashMap<UUID, int[]> userProgress = new HashMap();
    public final List<NbtBlockType> blockTypes = new ArrayList<NbtBlockType>();

    public TaskBlockBreak() {
        this.blockTypes.add(new NbtBlockType());
    }

    public ResourceLocation getFactoryID() {
        return FactoryTaskBlockBreak.INSTANCE.getRegistryName();
    }

    public boolean isComplete(UUID uuid) {
        return this.completeUsers.contains(uuid);
    }

    public void setComplete(UUID uuid) {
        if (!this.completeUsers.contains(uuid)) {
            this.completeUsers.add(uuid);
        }
    }

    public String getUnlocalisedName() {
        return "bq_standard.task.block_break";
    }

    public void detect(EntityPlayer player, IQuest quest) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = quest == null || (Boolean)quest.getProperty(NativeProps.GLOBAL) == false ? this.getPartyProgress(playerID) : this.getGlobalProgress();
        for (int j = 0; j < this.blockTypes.size(); ++j) {
            NbtBlockType block = this.blockTypes.get(j);
            if (block == null || progress[j] >= block.n) continue;
            return;
        }
        this.setComplete(playerID);
        QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
        if (qc != null) {
            qc.markQuestDirty(((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getID((Object)quest));
        }
    }

    public void onBlockBreak(DBEntry<IQuest> quest, EntityPlayer player, IBlockState state, BlockPos pos) {
        UUID playerID = QuestingAPI.getQuestingUUID((EntityPlayer)player);
        if (this.isComplete(playerID)) {
            return;
        }
        int[] progress = this.getUsersProgress(playerID);
        TileEntity tile = state.func_177230_c().hasTileEntity(state) ? player.field_70170_p.func_175625_s(pos) : null;
        NBTTagCompound tags = tile == null ? null : tile.func_189515_b(new NBTTagCompound());
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            boolean oreMatch;
            NbtBlockType targetBlock = this.blockTypes.get(i);
            if (progress[i] >= targetBlock.n) continue;
            int tmpMeta = targetBlock.m < 0 || targetBlock.m == Short.MAX_VALUE ? Short.MAX_VALUE : state.func_177230_c().func_176201_c(state);
            boolean bl = oreMatch = targetBlock.oreDict.length() > 0 && OreDictionary.getOres((String)targetBlock.oreDict).contains((Object)new ItemStack(state.func_177230_c(), 1, tmpMeta));
            if (!oreMatch && (state.func_177230_c() != targetBlock.b || targetBlock.m >= 0 && state.func_177230_c().func_176201_c(state) != targetBlock.m) || !ItemComparison.CompareNBTTag((NBTBase)targetBlock.tags, (NBTBase)tags, (boolean)true)) continue;
            int n = i;
            progress[n] = progress[n] + 1;
            this.setUserProgress(player.func_110124_au(), progress);
            QuestCache qc = (QuestCache)player.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            if (qc == null) break;
            qc.markQuestDirty(quest.getID());
            break;
        }
        this.detect(player, (IQuest)quest.getValue());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList bAry = new NBTTagList();
        for (NbtBlockType block : this.blockTypes) {
            bAry.func_74742_a((NBTBase)block.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("blocks", (NBTBase)bAry);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.blockTypes.clear();
        NBTTagList bList = nbt.func_150295_c("blocks", 10);
        for (int i = 0; i < bList.func_74745_c(); ++i) {
            NbtBlockType block = new NbtBlockType();
            block.readFromNBT(bList.func_150305_b(i));
            this.blockTypes.add(block);
        }
        if (nbt.func_150297_b("blockID", 8)) {
            Block targetBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("blockID")));
            targetBlock = targetBlock != Blocks.field_150350_a ? targetBlock : Blocks.field_150364_r;
            int targetMeta = nbt.func_74762_e("blockMeta");
            NBTTagCompound targetNbt = nbt.func_74775_l("blockNBT");
            int targetNum = nbt.func_74762_e("amount");
            NbtBlockType leg = new NbtBlockType();
            leg.b = targetBlock;
            leg.m = targetMeta;
            leg.tags = targetNbt;
            leg.n = targetNum;
            this.blockTypes.add(leg);
        }
    }

    public void readProgressFromNBT(NBTTagCompound nbt, boolean merge) {
        this.completeUsers.clear();
        NBTTagList cList = nbt.func_150295_c("completeUsers", 8);
        for (int i = 0; i < cList.func_74745_c(); ++i) {
            try {
                this.completeUsers.add(UUID.fromString(cList.func_150307_f(i)));
                continue;
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load UUID for task", (Throwable)e);
            }
        }
        this.userProgress.clear();
        NBTTagList pList = nbt.func_150295_c("userProgress", 10);
        for (int n = 0; n < pList.func_74745_c(); ++n) {
            UUID uuid;
            NBTTagCompound pTag = pList.func_150305_b(n);
            try {
                uuid = UUID.fromString(pTag.func_74779_i("uuid"));
            }
            catch (Exception e) {
                BQ_Standard.logger.log(Level.ERROR, "Unable to load user progress for task", (Throwable)e);
                continue;
            }
            int[] data = new int[this.blockTypes.size()];
            NBTTagList dNbt = pTag.func_150295_c("data", 3);
            for (int i = 0; i < data.length && i < dNbt.func_74745_c(); ++i) {
                try {
                    data[i] = dNbt.func_186858_c(i);
                    continue;
                }
                catch (Exception e) {
                    BQ_Standard.logger.log(Level.ERROR, "Incorrect task progress format", (Throwable)e);
                }
            }
            this.userProgress.put(uuid, data);
        }
    }

    public NBTTagCompound writeProgressToNBT(NBTTagCompound nbt, List<UUID> users) {
        NBTTagList jArray = new NBTTagList();
        for (UUID uuid : this.completeUsers) {
            jArray.func_74742_a((NBTBase)new NBTTagString(uuid.toString()));
        }
        nbt.func_74782_a("completeUsers", (NBTBase)jArray);
        NBTTagList progArray = new NBTTagList();
        for (Map.Entry<UUID, int[]> entry : this.userProgress.entrySet()) {
            NBTTagCompound pJson = new NBTTagCompound();
            pJson.func_74778_a("uuid", entry.getKey().toString());
            NBTTagList pArray = new NBTTagList();
            for (int i : entry.getValue()) {
                pArray.func_74742_a((NBTBase)new NBTTagInt(i));
            }
            pJson.func_74782_a("data", (NBTBase)pArray);
            progArray.func_74742_a((NBTBase)pJson);
        }
        nbt.func_74782_a("userProgress", (NBTBase)progArray);
        return nbt;
    }

    public void resetUser(UUID uuid) {
        this.completeUsers.remove(uuid);
        this.userProgress.remove(uuid);
    }

    public void resetAll() {
        this.completeUsers.clear();
        this.userProgress.clear();
    }

    public float getParticipation(UUID uuid) {
        if (this.blockTypes.size() <= 0) {
            return 1.0f;
        }
        float total = 0.0f;
        int[] progress = this.getUsersProgress(uuid);
        for (int i = 0; i < this.blockTypes.size(); ++i) {
            NbtBlockType block = this.blockTypes.get(i);
            total += (float)progress[i] / (float)block.n;
        }
        return total / (float)this.blockTypes.size();
    }

    @SideOnly(value=Side.CLIENT)
    public IGuiPanel getTaskGui(IGuiRect rect, IQuest quest) {
        return new PanelTaskBlockBreak(rect, quest, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getTaskEditor(GuiScreen screen, IQuest quest) {
        return null;
    }

    public void setUserProgress(UUID uuid, int[] progress) {
        this.userProgress.put(uuid, progress);
    }

    public int[] getUsersProgress(UUID ... users) {
        int[] progress = new int[this.blockTypes.size()];
        for (UUID uuid : users) {
            int[] tmp = this.userProgress.get(uuid);
            if (tmp == null || tmp.length != this.blockTypes.size()) continue;
            for (int n = 0; n < progress.length; ++n) {
                int n2 = n;
                progress[n2] = progress[n2] + tmp[n];
            }
        }
        return progress.length != this.blockTypes.size() ? new int[this.blockTypes.size()] : progress;
    }

    public int[] getPartyProgress(UUID uuid) {
        UUID[] uUIDArray;
        IParty party = ((IPartyDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.PARTY_DB)).getUserParty(uuid);
        if (party == null) {
            UUID[] uUIDArray2 = new UUID[1];
            uUIDArray = uUIDArray2;
            uUIDArray2[0] = uuid;
        } else {
            uUIDArray = party.getMembers().toArray(new UUID[0]);
        }
        return this.getUsersProgress(uUIDArray);
    }

    public int[] getGlobalProgress() {
        int[] total = new int[this.blockTypes.size()];
        for (int[] up : this.userProgress.values()) {
            if (up == null || up.length != total.length) continue;
            for (int i = 0; i < up.length; ++i) {
                int n = i;
                total[n] = total[n] + up[i];
            }
        }
        return total;
    }
}

