/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.client.gui.tasks;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.IValueIO;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.panels.CanvasEmpty;
import betterquesting.api2.client.gui.panels.IGuiPanel;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelItemSlot;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.tasks.TaskBlockBreak;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.TextFormatting;

public class PanelTaskBlockBreak
extends CanvasEmpty {
    private final IQuest quest;
    private final TaskBlockBreak task;

    public PanelTaskBlockBreak(IGuiRect rect, IQuest quest, TaskBlockBreak task) {
        super(rect);
        this.quest = quest;
        this.task = task;
    }

    public void initPanel() {
        super.initPanel();
        UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        int[] progress = this.quest == null || (Boolean)this.quest.getProperty(NativeProps.GLOBAL) == false ? this.task.getPartyProgress(uuid) : this.task.getGlobalProgress();
        boolean isComplete = this.task.isComplete(uuid);
        CanvasScrolling cvList = new CanvasScrolling((IGuiRect)new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 8, 0), 0));
        this.addPanel((IGuiPanel)cvList);
        PanelVScrollBar scList = new PanelVScrollBar((IGuiRect)new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(-8, 0, 0, 0), 0));
        this.addPanel((IGuiPanel)scList);
        cvList.setScrollDriverY((IValueIO)scList);
        int listW = cvList.getTransform().getWidth();
        for (int i = 0; i < this.task.blockTypes.size(); ++i) {
            BigItemStack stack = this.task.blockTypes.get(i).getItemStack();
            if (stack == null) continue;
            PanelItemSlot slot = new PanelItemSlot((IGuiRect)new GuiRectangle(0, i * 36, 36, 36, 0), -1, stack, true, true);
            cvList.addPanel((IGuiPanel)slot);
            StringBuilder sb = new StringBuilder();
            sb.append(stack.getBaseStack().func_82833_r());
            if (stack.hasOreDict()) {
                sb.append(" (").append(stack.getOreDict()).append(")");
            }
            sb.append("\n").append(progress[i]).append("/").append(stack.stackSize).append("\n");
            if (progress[i] >= stack.stackSize || isComplete) {
                sb.append(TextFormatting.GREEN).append(QuestTranslation.translate((String)"betterquesting.tooltip.complete", (Object[])new Object[0]));
            } else {
                sb.append(TextFormatting.RED).append(QuestTranslation.translate((String)"betterquesting.tooltip.incomplete", (Object[])new Object[0]));
            }
            PanelTextBox text = new PanelTextBox((IGuiRect)new GuiRectangle(40, i * 36, listW - 40, 36, 0), sb.toString());
            text.setColor(PresetColor.TEXT_MAIN.getColor());
            cvList.addPanel((IGuiPanel)text);
        }
    }
}

