/*
 * Decompiled with CFR 0.152.
 */
package bq_standard;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import bq_standard.ScoreBQ;
import bq_standard.network.StandardPacketType;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ScoreboardBQ {
    static ConcurrentHashMap<String, ScoreBQ> objectives = new ConcurrentHashMap();

    public static int getScore(UUID uuid, String scoreName) {
        ScoreBQ score = objectives.get(scoreName);
        if (score == null) {
            return 0;
        }
        return score.getScore(uuid);
    }

    public static void setScore(EntityPlayer player, String scoreName, int value) {
        ScoreBQ score = objectives.get(scoreName);
        if (score == null) {
            score = new ScoreBQ();
            objectives.put(scoreName, score);
        }
        score.setScore(QuestingAPI.getQuestingUUID((EntityPlayer)player), value);
        if (player instanceof EntityPlayerMP) {
            ScoreboardBQ.SendToClient((EntityPlayerMP)player);
        }
    }

    public static void SendToClient(EntityPlayerMP player) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74782_a("data", (NBTBase)ScoreboardBQ.writeJson(new NBTTagList()));
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToPlayer(new QuestingPacket(StandardPacketType.SCORE_SYNC.GetLocation(), tags), player);
    }

    public static void readJson(NBTTagList json) {
        objectives.clear();
        for (int i = 0; i < json.func_74745_c(); ++i) {
            NBTTagCompound jObj;
            String name;
            NBTBase element = json.func_179238_g(i);
            if (element.func_74732_a() != 10 || (name = (jObj = json.func_150305_b(i)).func_74779_i("name")).length() <= 0) continue;
            ScoreBQ score = new ScoreBQ();
            score.readJson(jObj.func_150295_c("scores", 10));
            objectives.put(name, score);
        }
    }

    public static NBTTagList writeJson(NBTTagList json) {
        for (Map.Entry<String, ScoreBQ> entry : objectives.entrySet()) {
            NBTTagCompound jObj = new NBTTagCompound();
            jObj.func_74778_a("name", entry.getKey());
            jObj.func_74782_a("scores", (NBTBase)entry.getValue().writeJson(new NBTTagList()));
            json.func_74742_a((NBTBase)jObj);
        }
        return json;
    }
}

