/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.tconstruct.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeDefinition;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.recipehandler.PrototypedIngredientAlternativesList;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;
import slimeknights.tconstruct.library.TinkerRegistry;

public class TileDryingRackRecipeHandler
implements IRecipeHandler {
    private static final TileDryingRackRecipeHandler INSTANCE = new TileDryingRackRecipeHandler();
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_INPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});
    private static final Set<IngredientComponent<?, ?>> COMPONENTS_OUTPUT = Sets.newHashSet((Object[])new IngredientComponent[]{IngredientComponent.ITEMSTACK});

    public static TileDryingRackRecipeHandler getInstance() {
        return INSTANCE;
    }

    private TileDryingRackRecipeHandler() {
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeInputComponents() {
        return COMPONENTS_INPUT;
    }

    @Override
    public Set<IngredientComponent<?, ?>> getRecipeOutputComponents() {
        return COMPONENTS_OUTPUT;
    }

    @Override
    public boolean isValidSizeInput(IngredientComponent<?, ?> component, int size) {
        return component == IngredientComponent.ITEMSTACK && size == 1;
    }

    @Override
    public Collection<IRecipeDefinition> getRecipes() {
        return TinkerRegistry.getAllDryingRecipes().stream().map(recipe -> {
            IdentityHashMap inputs = Maps.newIdentityHashMap();
            IdentityHashMap outputs = Maps.newIdentityHashMap();
            inputs.put(IngredientComponent.ITEMSTACK, recipe.input.getInputs().stream().map(input -> new PrototypedIngredientAlternativesList(Lists.newArrayList((Object[])new IPrototypedIngredient[]{new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)input, 15)}))).collect(Collectors.toList()));
            outputs.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{recipe.getResult()}));
            return new RecipeDefinition(inputs, new MixedIngredients(outputs));
        }).collect(Collectors.toList());
    }

    @Override
    @Nullable
    public IMixedIngredients simulate(IMixedIngredients input) {
        ItemStack itemStack = input.getFirstNonEmpty(IngredientComponent.ITEMSTACK);
        ItemStack result = TinkerRegistry.getDryingResult((ItemStack)itemStack);
        if (result.func_190926_b()) {
            return null;
        }
        IdentityHashMap ingredientsMap = Maps.newIdentityHashMap();
        ingredientsMap.put(IngredientComponent.ITEMSTACK, Lists.newArrayList((Object[])new ItemStack[]{result}));
        return new MixedIngredients(ingredientsMap);
    }
}

