/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.ingredient.storage;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageWrapperHandler;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.ingredient.collection.FilteredIngredientCollectionIterator;

public class IngredientComponentStorageWrapperHandlerEnergyStorage
implements IIngredientComponentStorageWrapperHandler<Integer, Boolean, IEnergyStorage> {
    private final IngredientComponent<Integer, Boolean> ingredientComponent;

    public IngredientComponentStorageWrapperHandlerEnergyStorage(IngredientComponent<Integer, Boolean> ingredientComponent) {
        this.ingredientComponent = Objects.requireNonNull(ingredientComponent);
    }

    @Override
    public IIngredientComponentStorage<Integer, Boolean> wrapComponentStorage(IEnergyStorage storage) {
        return new ComponentStorageWrapper(this.getComponent(), storage);
    }

    @Override
    public IEnergyStorage wrapStorage(IIngredientComponentStorage<Integer, Boolean> componentStorage) {
        return new EnergyStorageWrapper(componentStorage);
    }

    @Override
    @Nullable
    public IEnergyStorage getStorage(ICapabilityProvider capabilityProvider, @Nullable EnumFacing facing) {
        if (capabilityProvider.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            return (IEnergyStorage)capabilityProvider.getCapability(CapabilityEnergy.ENERGY, facing);
        }
        return null;
    }

    @Override
    public IngredientComponent<Integer, Boolean> getComponent() {
        return this.ingredientComponent;
    }

    public static class EnergyStorageWrapper
    implements IEnergyStorage {
        private final IIngredientComponentStorage<Integer, Boolean> storage;

        public EnergyStorageWrapper(IIngredientComponentStorage<Integer, Boolean> storage) {
            this.storage = storage;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive - this.storage.insert(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return this.storage.extract(maxExtract, simulate);
        }

        public int getEnergyStored() {
            int total = 0;
            for (Integer stored : this.storage) {
                total = Math.addExact(total, stored);
            }
            return total;
        }

        public int getMaxEnergyStored() {
            return Helpers.castSafe((long)this.storage.getMaxQuantity());
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }

    public static class ComponentStorageWrapper
    implements IIngredientComponentStorage<Integer, Boolean> {
        private final IngredientComponent<Integer, Boolean> ingredientComponent;
        private final IEnergyStorage storage;

        public ComponentStorageWrapper(IngredientComponent<Integer, Boolean> ingredientComponent, IEnergyStorage storage) {
            this.ingredientComponent = ingredientComponent;
            this.storage = storage;
        }

        @Override
        public IngredientComponent<Integer, Boolean> getComponent() {
            return this.ingredientComponent;
        }

        @Override
        public Iterator<Integer> iterator() {
            return Iterators.forArray((Object[])new Integer[]{this.storage.getEnergyStored()});
        }

        @Override
        public Iterator<Integer> iterator(@Nonnull Integer prototype, Boolean matchFlags) {
            return new FilteredIngredientCollectionIterator(this.iterator(), this.getComponent().getMatcher(), (Object)prototype, (Object)matchFlags);
        }

        @Override
        public long getMaxQuantity() {
            return this.storage.getMaxEnergyStored();
        }

        @Override
        public Integer insert(@Nonnull Integer ingredient, boolean simulate) {
            return ingredient - this.storage.receiveEnergy(ingredient.intValue(), simulate);
        }

        @Override
        public Integer extract(@Nonnull Integer prototype, Boolean matchFlags, boolean simulate) {
            int extractable;
            if (matchFlags.booleanValue() && (extractable = this.storage.extractEnergy(prototype.intValue(), true)) != prototype) {
                return 0;
            }
            return this.storage.extractEnergy(prototype.intValue(), simulate);
        }

        @Override
        public Integer extract(long maxQuantity, boolean simulate) {
            return this.storage.extractEnergy(Helpers.castSafe((long)maxQuantity), simulate);
        }
    }
}

