/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.BoxSingleQuad;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRedstoneLantern
extends XUBlockStatic {
    static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    final int[][] TEXTURE_NUMBER_BOUNDS = new int[][]{{0, 0, 5}, {6, 0, 5}, {12, 0, 5}, {18, 0, 5}, {24, 0, 5}, {0, 8, 5}, {6, 8, 5}, {12, 8, 5}, {18, 8, 5}, {24, 8, 5}, {0, 16, 9}, {10, 16, 9}, {20, 16, 9}, {0, 24, 9}, {10, 24, 9}, {20, 24, 9}};

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addWorldProperties(new IProperty[]{POWER}).build();
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        int v = (Integer)state.func_177229_b((IProperty)POWER);
        BoxModel model = new BoxModel();
        float eps = 1.0E-4f;
        float par5 = 0.0625f + eps;
        float par7 = 0.9375f - eps;
        model.addBox(par5, par5, par5, par7, par7, par7, "redstone_lantern").setLayer(BlockRenderLayer.CUTOUT);
        float x01 = 0.065625f;
        float x11 = 0.934375f;
        Box redstone_box = new Box(x01, x01, x01, x11, x11, x11).setTexture("redstone_lantern");
        redstone_box.setTextureBounds(new float[][]{{15.0f, v, 16.0f, v + 1}, {15.0f, v, 16.0f, v + 1}, {15.0f, v, 16.0f, v + 1}, {15.0f, v, 16.0f, v + 1}, {15.0f, v, 16.0f, v + 1}, {15.0f, v, 16.0f, v + 1}});
        model.add(redstone_box);
        int[] bounds = this.TEXTURE_NUMBER_BOUNDS[v];
        int x = bounds[0];
        int y = bounds[1];
        int w = bounds[2];
        int h = 7;
        float u0 = (float)x / 32.0f;
        float u1 = (float)(x + w) / 32.0f;
        float v0 = 1.0f - (float)(y + h) / 32.0f;
        float v1 = 1.0f - (float)y / 32.0f;
        float x0 = (float)(16 - w) / 16.0f / 2.0f;
        float x1 = (float)(16 + w) / 16.0f / 2.0f;
        float z0 = (float)(16 - h) / 16.0f / 2.0f;
        float z1 = (float)(16 + h) / 16.0f / 2.0f;
        for (EnumFacing facing : EnumFacing.values()) {
            model.add(new BoxSingleQuad(new UV(x0, 0.0625f, z0, u0, v0), new UV(x1, 0.0625f, z0, u1, v0), new UV(x1, 0.0625f, z1, u1, v1), new UV(x0, 0.0625f, z1, u0, v1)).setTexture("redstone_lantern_numbers").rotateToSide(facing).setLayer(BlockRenderLayer.CUTOUT));
        }
        return model;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public boolean onBlockActivatedBase(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            int value;
            state = playerIn.func_70093_af() ? state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf((value = (Integer)state.func_177229_b((IProperty)POWER) - 1) < 0 ? 15 : value)) : state.func_177231_a((IProperty)POWER);
            worldIn.func_180501_a(pos, state, 3);
            float f = 0.5f + 0.1f * (float)((Integer)state.func_177229_b((IProperty)POWER)).intValue() / 15.0f;
            worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
            CompatHelper.notifyNeighborsOfStateChange(worldIn, pos, this);
            for (EnumFacing facing : EnumFacing.values()) {
                CompatHelper.notifyNeighborsOfStateChange(worldIn, pos.func_177972_a(facing), this);
            }
        }
        return true;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        EnumFacing compFacing;
        IBlockState state;
        Block block;
        EnumFacing.Axis axis = side.func_176740_k();
        if (axis != EnumFacing.Axis.Y && ((block = (state = blockAccess.func_180495_p(pos.func_177972_a(side.func_176734_d()))).func_177230_c()) == Blocks.field_150455_bV || block == Blocks.field_150441_bU) && (compFacing = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D)).func_176740_k() != axis) {
            return (Integer)blockState.func_177229_b((IProperty)POWER);
        }
        return 0;
    }
}

