/*
 * Decompiled with CFR 0.152.
 */
package net.daveyx0.multimob.common.capabilities;

import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.daveyx0.multimob.common.capabilities.ITameableEntity;
import net.daveyx0.multimob.util.EntityUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class TameableEntityHandler
implements ITameableEntity {
    protected UUID ownerID;
    protected boolean isTamed;
    protected int followState;

    public TameableEntityHandler() {
        this.ownerID = null;
        this.isTamed = false;
        this.followState = 0;
    }

    public TameableEntityHandler(UUID id) {
        this.ownerID = id;
        this.isTamed = true;
        this.followState = 0;
    }

    @Override
    @Nullable
    public EntityLivingBase getOwner(EntityLivingBase entityIn) {
        try {
            UUID uuid = this.getOwnerId();
            if (uuid != null) {
                EntityPlayer player = entityIn.field_70170_p.func_152378_a(uuid);
                if (player != null) {
                    return player;
                }
                EntityLivingBase entity = EntityUtil.getLoadedEntityByUUID(uuid, entityIn.field_70170_p);
                if (entity != null) {
                    return entity;
                }
                return null;
            }
            return null;
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase thisEntity, EntityLivingBase entityIn) {
        return entityIn == this.getOwner(thisEntity);
    }

    @Override
    public void setOwner(UUID id) {
        this.ownerID = id;
    }

    @Override
    public boolean isTamed() {
        return this.isTamed;
    }

    @Override
    public void setTamed(boolean set) {
        this.isTamed = set;
    }

    @Override
    public UUID getOwnerId() {
        return this.ownerID;
    }

    @Override
    public int getFollowState() {
        return this.followState;
    }

    @Override
    public void setFollowState(int set) {
        this.followState = set;
    }

    private static class Factory
    implements Callable<ITameableEntity> {
        private Factory() {
        }

        @Override
        public ITameableEntity call() throws Exception {
            return new TameableEntityHandler();
        }
    }
}

