/*
 * Decompiled with CFR 0.152.
 */
package lex.world.gen.feature;

import java.util.Random;
import lex.config.Config;
import lex.world.gen.feature.Feature;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FeaturePool
extends Feature {
    private IBlockState blockToSpawn;
    private IBlockState blockToSurround;

    public FeaturePool(Config config) {
        super(config);
        this.blockToSpawn = config.getBlock("blockToSpawn", Blocks.field_180401_cv.func_176223_P());
        this.blockToSurround = config.getBlock("blockToSurround", Blocks.field_180401_cv.func_176223_P());
    }

    public FeaturePool(int genAttempts, float genProbability, boolean randomizeGenAttempts, int minGenHeight, int maxGenHeight, IBlockState blockToSpawn, IBlockState blockToSurround) {
        super(genAttempts, genProbability, randomizeGenAttempts, minGenHeight, maxGenHeight);
        this.blockToSpawn = blockToSpawn;
        this.blockToSurround = blockToSurround;
    }

    @Override
    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.blockToSpawn.func_177230_c() == Blocks.field_180401_cv || this.blockToSurround.func_177230_c() == Blocks.field_180401_cv) {
            return false;
        }
        pos = pos.func_177982_a(-8, 0, -8);
        while (pos.func_177956_o() > this.minGenHeight && world.func_175623_d(pos)) {
            pos = pos.func_177977_b();
        }
        if (pos.func_177956_o() <= 4 || pos.func_177956_o() < this.minGenHeight) {
            return false;
        }
        pos = pos.func_177979_c(4);
        boolean[] hasSpace = new boolean[2048];
        int i = rand.nextInt(4) + 4;
        for (int j = 0; j < i; ++j) {
            double d0 = rand.nextDouble() * 6.0 + 3.0;
            double d1 = rand.nextDouble() * 4.0 + 2.0;
            double d2 = rand.nextDouble() * 6.0 + 3.0;
            double d3 = rand.nextDouble() * (16.0 - d0 - 2.0) + 1.0 + d0 / 2.0;
            double d4 = rand.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = rand.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            for (int l = 1; l < 15; ++l) {
                for (int i1 = 1; i1 < 15; ++i1) {
                    for (int j1 = 1; j1 < 7; ++j1) {
                        double d6 = ((double)l - d3) / (d0 / 2.0);
                        double d7 = ((double)j1 - d4) / (d1 / 2.0);
                        double d8 = ((double)i1 - d5) / (d2 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        hasSpace[(l * 16 + i1) * 8 + j1] = true;
                    }
                }
            }
        }
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l2 = 0; l2 < 16; ++l2) {
                for (int k = 0; k < 8; ++k) {
                    boolean flag;
                    boolean bl = flag = !hasSpace[(k1 * 16 + l2) * 8 + k] && (k1 < 15 && hasSpace[((k1 + 1) * 16 + l2) * 8 + k] || k1 > 0 && hasSpace[((k1 - 1) * 16 + l2) * 8 + k] || l2 < 15 && hasSpace[(k1 * 16 + l2 + 1) * 8 + k] || l2 > 0 && hasSpace[(k1 * 16 + (l2 - 1)) * 8 + k] || k < 7 && hasSpace[(k1 * 16 + l2) * 8 + k + 1] || k > 0 && hasSpace[(k1 * 16 + l2) * 8 + (k - 1)]);
                    if (!flag) continue;
                    Material material = world.func_180495_p(pos.func_177982_a(k1, k, l2)).func_185904_a();
                    if (k >= 4 && material.func_76224_d()) {
                        return false;
                    }
                    if (k >= 4 || material.func_76220_a() || world.func_180495_p(pos.func_177982_a(k1, k, l2)) == this.blockToSpawn) continue;
                    return false;
                }
            }
        }
        for (int l1 = 0; l1 < 16; ++l1) {
            for (int i3 = 0; i3 < 16; ++i3) {
                for (int i4 = 0; i4 < 8; ++i4) {
                    if (!hasSpace[(l1 * 16 + i3) * 8 + i4]) continue;
                    world.func_180501_a(pos.func_177982_a(l1, i4, i3), i4 >= 4 ? Blocks.field_150350_a.func_176223_P() : this.blockToSpawn, 2);
                }
            }
        }
        for (int j2 = 0; j2 < 16; ++j2) {
            for (int k3 = 0; k3 < 16; ++k3) {
                for (int k4 = 0; k4 < 8; ++k4) {
                    boolean flag1;
                    boolean bl = flag1 = !hasSpace[(j2 * 16 + k3) * 8 + k4] && (j2 < 15 && hasSpace[((j2 + 1) * 16 + k3) * 8 + k4] || j2 > 0 && hasSpace[((j2 - 1) * 16 + k3) * 8 + k4] || k3 < 15 && hasSpace[(j2 * 16 + k3 + 1) * 8 + k4] || k3 > 0 && hasSpace[(j2 * 16 + (k3 - 1)) * 8 + k4] || k4 < 7 && hasSpace[(j2 * 16 + k3) * 8 + k4 + 1] || k4 > 0 && hasSpace[(j2 * 16 + k3) * 8 + (k4 - 1)]);
                    if (!flag1 || k4 >= 4 && rand.nextInt(2) == 0 || !world.func_180495_p(pos.func_177982_a(j2, k4, k3)).func_185904_a().func_76220_a()) continue;
                    world.func_180501_a(pos.func_177982_a(j2, k4, k3), this.blockToSurround, 2);
                }
            }
        }
        return true;
    }
}

