/*
 * Decompiled with CFR 0.152.
 */
package lex.item;

import lex.item.ItemBlockLibEx;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ItemBlockEdible
extends ItemBlockLibEx {
    private final int healAmount;
    private final float saturation;
    private final boolean isWolfFood;
    private boolean alwaysEdible;
    private PotionEffect potionId;
    private float potionEffectProbability;

    public ItemBlockEdible(Block block, int healAmount, float saturation, boolean isWolfFood) {
        super(block);
        this.healAmount = healAmount;
        this.saturation = saturation;
        this.isWolfFood = isWolfFood;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            player.func_71024_bL().func_75122_a(this.healAmount, this.saturation);
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.onFoodEaten(stack, world, player);
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        stack.func_190918_g(1);
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.EAT;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_71043_e(this.alwaysEdible)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    protected void onFoodEaten(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K && this.potionId != null && world.field_73012_v.nextFloat() < this.potionEffectProbability) {
            player.func_70690_d(new PotionEffect(this.potionId));
        }
    }

    public int getHealAmount(ItemStack stack) {
        return this.healAmount;
    }

    public float getSaturation(ItemStack stack) {
        return this.saturation;
    }

    public boolean isWolfsFood() {
        return this.isWolfFood;
    }

    public ItemBlockEdible setPotionEffect(PotionEffect effect, float probability) {
        this.potionId = effect;
        this.potionEffectProbability = probability;
        return this;
    }

    public ItemBlockEdible setAlwaysEdible() {
        this.alwaysEdible = true;
        return this;
    }
}

