/*
 * Decompiled with CFR 0.152.
 */
package openblocks.enchantments.flimflams;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.Config;
import openblocks.api.FlimFlamDescriptionSimple;
import openblocks.api.IFlimFlamAction;
import openblocks.api.IFlimFlamDescription;
import openblocks.api.IFlimFlamRegistry;
import openmods.Log;
import openmods.access.ApiSingleton;
import openmods.config.properties.ConfigurationChange;

@ApiSingleton
public class FlimFlamRegistry
implements IFlimFlamRegistry {
    public static FlimFlamRegistry instance = new FlimFlamRegistry();
    private static final List<IFlimFlamDescription> FLIM_FLAMS = Lists.newArrayList();
    private static final List<IFlimFlamDescription> UNMODIFIABLE_VIEW = Collections.unmodifiableList(FLIM_FLAMS);
    private static final Map<String, IFlimFlamDescription> FLIM_FLAMS_BY_NAME = Maps.newHashMap();
    public static final FlimFlamChecker BLACKLIST = new FlimFlamChecker();

    @Override
    public FlimFlamDescriptionSimple registerFlimFlam(String name, int cost, int weight, IFlimFlamAction effect) {
        FlimFlamDescriptionSimple meta = new FlimFlamDescriptionSimple(name, cost, weight, effect);
        this.registerFlimFlam(name, meta);
        return meta;
    }

    @Override
    public void registerFlimFlam(String name, IFlimFlamDescription meta) {
        FLIM_FLAMS.add(meta);
        FLIM_FLAMS_BY_NAME.put(name, meta);
    }

    @Override
    public List<IFlimFlamDescription> getFlimFlams() {
        return UNMODIFIABLE_VIEW;
    }

    @Override
    public IFlimFlamDescription getFlimFlamByName(String name) {
        return FLIM_FLAMS_BY_NAME.get(name);
    }

    @Override
    public List<String> getAllFlimFlamsNames() {
        return ImmutableList.copyOf(FLIM_FLAMS_BY_NAME.keySet());
    }

    public static class FlimFlamChecker {
        private Set<String> flimFlamList;

        private void loadList() {
            this.flimFlamList = Sets.newHashSet();
            HashSet validNames = Sets.newHashSet(instance.getAllFlimFlamsNames());
            for (String s : Config.flimFlamList) {
                if (validNames.contains(s)) {
                    this.flimFlamList.add(s);
                    continue;
                }
                Log.warn((String)"Trying to blacklist unknown flimflam name '%s'", (Object[])new Object[]{s});
            }
            Log.debug((String)"Blacklisting/Whitelisting flim-flams %s", (Object[])new Object[]{this.flimFlamList});
        }

        public boolean isBlacklisted(IFlimFlamDescription effect) {
            if (Config.safeFlimFlams && !effect.isSafe()) {
                return true;
            }
            if (this.flimFlamList == null) {
                this.loadList();
            }
            boolean onList = this.flimFlamList.contains(effect.name());
            return Config.flimFlamWhitelist ^ onList;
        }

        @SubscribeEvent
        public void onReconfig(ConfigurationChange.Post evt) {
            if (evt.check("tomfoolery", "flimFlamBlacklist")) {
                this.flimFlamList = null;
            }
        }

        public void init() {
            this.loadList();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }
}

