/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.proxy;

import java.awt.Color;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import zabi.minecraft.extraalchemy.client.ModKeybinds;
import zabi.minecraft.extraalchemy.client.PotionDescriptionTooltipHandler;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.proxy.Proxy;

public class ClientProxy
extends Proxy {
    @Override
    public void updatePlayerPotion(EntityPlayer e, PotionEffect fx) {
        e.func_70690_d(new PotionEffect(fx));
    }

    @Override
    public void registerEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)new ModKeybinds());
    }

    @Override
    public void registerItemDescriptions() {
        MinecraftForge.EVENT_BUS.register((Object)new PotionDescriptionTooltipHandler());
    }

    @Override
    public void registerColorHandler() {
        ItemColors colors = Minecraft.func_71410_x().getItemColors();
        colors.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 0 ? PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)stack)) : -1;
            }
        }, new Item[]{ModItems.breakable_potion, ModItems.modified_potion});
        colors.func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 0 ? this.getMedalColor(stack) : -1;
            }

            private int getMedalColor(ItemStack stack) {
                if (!PotionUtils.func_185189_a((ItemStack)stack).isEmpty()) {
                    return PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)stack));
                }
                return ClientProxy.this.getRainbow(0xFFFFFF);
            }
        }, new Item[]{ModItems.supporter_medal});
    }

    @Override
    public void registerItemModel(Item i) {
        ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation(i.getRegistryName().toString()), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)mrl);
    }

    @Override
    public int getRainbow(int defaultColor) {
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71439_g != null) {
            return Color.HSBtoRGB((float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 180L) / 180.0f, 1.0f, 1.0f);
        }
        return defaultColor;
    }

    @Override
    public boolean isShiftingInInv() {
        return GuiScreen.func_146272_n();
    }

    @Override
    public void playDispelSound() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        player.func_130014_f_().func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation("entity.elder_guardian.curse")), SoundCategory.AMBIENT, 1.5f, 8.0f, false);
    }

    @Override
    public EntityPlayer getSP() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

