/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.items;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import zabi.minecraft.extraalchemy.items.ModItems;
import zabi.minecraft.extraalchemy.lib.Log;

public class ItemSupporterMedal
extends Item {
    public static final ArrayList<String> contributorsUUIDs = new ArrayList();
    private static final String GAVE_MEDAL_TAG = "gave_medal_ea";

    public ItemSupporterMedal() {
        this.func_77625_d(1);
        this.func_77637_a(null);
        this.setRegistryName(new ResourceLocation("extraalchemy", "supporter_medal"));
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (!"true".equals(System.getProperty("eanosupport"))) {
            Thread poller = new Thread(new ContributorsPoll());
            poller.setDaemon(true);
            poller.setName("Extra Alchemy Contributor Poll");
            poller.start();
        } else {
            Log.i("Contributors fetching disabled :'( ");
        }
    }

    public String func_77653_i(ItemStack stack) {
        String name;
        String string = name = stack.func_77978_p() != null ? stack.func_77978_p().func_74779_i("supporter") : "cheater";
        if (name.equals("cheater")) {
            return "This medal is for contributors only!";
        }
        return "Thank you " + name + "!";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String name;
        String string = name = stack.func_77978_p() != null ? stack.func_77978_p().func_74779_i("supporter") : "cheater";
        if (name.equals("")) {
            return;
        }
        if (name.equals("cheater")) {
            tooltip.add("If you really want this medal support the mod!");
            tooltip.add("(Support means helping in ANY way, e.g. translating, donating, texturing...)");
            tooltip.add("https://minecraft.curseforge.com/projects/extra-alchemy");
        } else {
            if (!this.func_77636_d(stack)) {
                tooltip.add("Thanks " + name + " for supporting Extra Alchemy!");
            } else {
                tooltip.add(TextFormatting.RED + "Hello Master");
            }
            if (!PotionUtils.func_185189_a((ItemStack)stack).isEmpty()) {
                tooltip.add("Right click to clear the color");
            }
        }
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean func_77636_d(ItemStack stack) {
        String name;
        String string = name = stack.func_77978_p() != null ? stack.func_77978_p().func_74779_i("supporter") : "";
        return name.equals("zabi94");
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack itemStackIn = player.func_184586_b(hand);
        if (itemStackIn.func_77942_o() && !PotionUtils.func_185189_a((ItemStack)itemStackIn).isEmpty()) {
            itemStackIn.func_77978_p().func_82580_o("Potion");
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        return super.func_77659_a(worldIn, player, hand);
    }

    @SubscribeEvent
    public void onPlayerJoiningFirst(EntityJoinWorldEvent evt) {
        EntityPlayer p;
        if (!evt.getWorld().field_72995_K && evt.getEntity() instanceof EntityPlayer && !(p = (EntityPlayer)evt.getEntity()).func_184216_O().contains(GAVE_MEDAL_TAG)) {
            this.giveMedal(p);
        }
    }

    public boolean giveMedal(EntityPlayer p) {
        if (contributorsUUIDs.contains(p.func_110124_au().toString().replace("-", ""))) {
            ItemStack medal = new ItemStack(ModItems.supporter_medal);
            medal.func_77982_d(new NBTTagCompound());
            medal.func_77978_p().func_74778_a("supporter", p.getDisplayNameString());
            EntityItem ent = new EntityItem(p.func_130014_f_(), p.field_70165_t, p.field_70163_u + 1.0, p.field_70161_v, medal);
            p.func_130014_f_().func_72838_d((Entity)ent);
            p.func_184211_a(GAVE_MEDAL_TAG);
            return true;
        }
        return false;
    }

    public static class ContributorsPoll
    implements Runnable {
        private static final String CONTRIBUTORS_URL = "http://zabi.altervista.org/minecraft/extraalchemy/ringraziamenti";

        @Override
        public void run() {
            InputStream in = null;
            try {
                in = new URL(CONTRIBUTORS_URL).openStream();
                List contributorData = IOUtils.readLines((InputStream)in, (Charset)Charset.defaultCharset());
                contributorData.parallelStream().filter(s -> !s.startsWith("#")).forEach(s -> {
                    contributorsUUIDs.add((String)s);
                    Log.d("Supporter UUID: " + s);
                });
                Log.i("Contributors updated! Found " + contributorData.size() / 2 + " contributors");
            }
            catch (IOException e) {
                Log.d("error during contributors poll: ");
                Log.d(e);
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

