/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.network.packet;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.evilcraft.core.fluid.WorldSharedTankCache;

public class UpdateWorldSharedTankClientCachePacket
extends PacketCodec {
    @CodecField
    private String tankID = null;
    @CodecField
    private String fluidName = null;
    @CodecField
    private NBTTagCompound fluidTag = null;
    @CodecField
    private int fluidAmount = 0;

    public UpdateWorldSharedTankClientCachePacket() {
    }

    public boolean isAsync() {
        return true;
    }

    public UpdateWorldSharedTankClientCachePacket(String tankID, FluidStack fluidStack) {
        this.tankID = tankID;
        if (fluidStack == null) {
            this.fluidName = "";
            this.fluidTag = null;
            this.fluidAmount = -1;
        } else {
            this.fluidName = fluidStack.getFluid().getName();
            this.fluidTag = fluidStack.tag;
            this.fluidAmount = fluidStack.amount;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void actionClient(World world, EntityPlayer player) {
        Fluid fluid;
        FluidStack fluidStack = null;
        if (this.fluidAmount >= 0 && this.fluidName != null && (fluid = FluidRegistry.getFluid((String)this.fluidName)) != null) {
            fluidStack = new FluidStack(fluid, this.fluidAmount, this.fluidTag);
        }
        WorldSharedTankCache.getInstance().setTankContent(this.tankID, fluidStack);
    }

    public void actionServer(World world, EntityPlayerMP player) {
    }
}

