/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.RecipeSorter;
import org.cyclops.cyclopscore.capability.fluid.IFluidHandlerItemCapacity;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.init.RecipeHandler;
import org.cyclops.cyclopscore.recipe.custom.Recipe;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeInput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeOutput;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeProperties;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsRecipeComponent;
import org.cyclops.cyclopscore.recipe.event.IRecipeOutputObserver;
import org.cyclops.cyclopscore.recipe.event.ObservableShapedRecipe;
import org.cyclops.cyclopscore.recipe.xml.IRecipeConditionHandler;
import org.cyclops.cyclopscore.recipe.xml.IRecipeTypeHandler;
import org.cyclops.evilcraft.Configs;
import org.cyclops.evilcraft.api.broom.IBroomPart;
import org.cyclops.evilcraft.block.BoxOfEternalClosure;
import org.cyclops.evilcraft.block.BoxOfEternalClosureConfig;
import org.cyclops.evilcraft.block.DarkTank;
import org.cyclops.evilcraft.block.DarkTankConfig;
import org.cyclops.evilcraft.block.DisplayStand;
import org.cyclops.evilcraft.block.DisplayStandConfig;
import org.cyclops.evilcraft.block.EntangledChalice;
import org.cyclops.evilcraft.block.EntangledChaliceConfig;
import org.cyclops.evilcraft.block.EntangledChaliceItem;
import org.cyclops.evilcraft.block.EnvironmentalAccumulator;
import org.cyclops.evilcraft.block.EnvironmentalAccumulatorConfig;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.item.ItemBlockFluidContainer;
import org.cyclops.evilcraft.core.recipe.BloodExtractorCombinationRecipe;
import org.cyclops.evilcraft.core.recipe.BroomPartCombinationRecipe;
import org.cyclops.evilcraft.core.recipe.DeadBushRecipe;
import org.cyclops.evilcraft.core.recipe.DisplayStandRecipe;
import org.cyclops.evilcraft.core.recipe.ItemBlockFluidContainerCombinationRecipe;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeComponent;
import org.cyclops.evilcraft.core.recipe.custom.EnvironmentalAccumulatorRecipeProperties;
import org.cyclops.evilcraft.core.recipe.xml.BloodInfuserRecipeTypeHandler;
import org.cyclops.evilcraft.core.recipe.xml.EnvironmentalAccumulatorRecipeTypeHandler;
import org.cyclops.evilcraft.core.weather.WeatherType;
import org.cyclops.evilcraft.enchantment.EnchantmentPoisonTip;
import org.cyclops.evilcraft.enchantment.EnchantmentPoisonTipConfig;
import org.cyclops.evilcraft.fluid.Poison;
import org.cyclops.evilcraft.fluid.PoisonConfig;
import org.cyclops.evilcraft.item.BiomeExtract;
import org.cyclops.evilcraft.item.BiomeExtractConfig;
import org.cyclops.evilcraft.item.BloodExtractorConfig;
import org.cyclops.evilcraft.item.BroomConfig;
import org.cyclops.evilcraft.item.CorruptedTearConfig;
import org.cyclops.evilcraft.item.DarkGem;
import org.cyclops.evilcraft.item.DarkGemConfig;
import org.cyclops.evilcraft.item.InvertedPotentia;
import org.cyclops.evilcraft.item.InvertedPotentiaConfig;
import org.cyclops.evilcraft.item.PotentiaSphereConfig;
import org.cyclops.evilcraft.item.VeinSword;
import org.cyclops.evilcraft.item.VeinSwordConfig;
import org.cyclops.evilcraft.item.VengeancePickaxe;
import org.cyclops.evilcraft.item.VengeancePickaxeConfig;
import org.cyclops.evilcraft.item.WeatherContainer;
import org.cyclops.evilcraft.item.WeatherContainerConfig;

public class ExtendedRecipeHandler
extends RecipeHandler {
    public ExtendedRecipeHandler(ModBase mod, String ... fileNames) {
        super(mod, fileNames);
    }

    protected void registerHandlers(Map<String, IRecipeTypeHandler> recipeTypeHandlers, Map<String, IRecipeConditionHandler> recipeConditionHandlers) {
        super.registerHandlers(recipeTypeHandlers, recipeConditionHandlers);
        recipeTypeHandlers.put("evilcraft:bloodinfuser", (IRecipeTypeHandler)new BloodInfuserRecipeTypeHandler());
        recipeTypeHandlers.put("evilcraft:environmentalaccumulator", (IRecipeTypeHandler)new EnvironmentalAccumulatorRecipeTypeHandler());
    }

    protected void registerRecipeSorters() {
        super.registerRecipeSorters();
        RecipeSorter.register((String)"evilcraftcontainercombination", ItemBlockFluidContainerCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftbloodextractorcombination", BloodExtractorCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftbroomcombination", BroomPartCombinationRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"evilcraftdisplaystand", DisplayStandRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
    }

    protected void loadPredefineds(Map<String, ItemStack> predefinedItems, Set<String> predefinedValues) {
        IFluidHandlerItemCapacity fluidHandler;
        super.loadPredefineds(predefinedItems, predefinedValues);
        if (Configs.isEnabled(EnchantmentPoisonTipConfig.class)) {
            ItemStack poisonTipEnchant = new ItemStack(Items.field_151134_bR);
            EnchantmentPoisonTip enchant = EnchantmentPoisonTip.getInstance();
            ItemEnchantedBook.func_92115_a((ItemStack)poisonTipEnchant, (EnchantmentData)new EnchantmentData((Enchantment)enchant, enchant.func_77319_d()));
            predefinedItems.put("evilcraft:enchanted_book_poison_tip", poisonTipEnchant);
        }
        if (Configs.isEnabled(WeatherContainerConfig.class)) {
            ItemStack lightningWeatherContainer = new ItemStack((Item)WeatherContainer.getInstance(), 1, WeatherContainer.WeatherContainerTypes.LIGHTNING.ordinal());
            predefinedItems.put("evilcraft:lightning_weather_container", lightningWeatherContainer);
        }
        if (Configs.isEnabled(InvertedPotentiaConfig.class)) {
            ItemStack invertedPotentiaEmpowered = new ItemStack((Item)InvertedPotentia.getInstance(), 1, 1);
            predefinedItems.put("evilcraft:inverted_potentia_empowered", invertedPotentiaEmpowered);
        }
        if (Configs.isEnabled(VengeancePickaxeConfig.class)) {
            ItemStack vengeancePickaxeFortune = VengeancePickaxe.createCraftingResult();
            predefinedItems.put("evilcraft:vengeance_pickaxe_fortune", vengeancePickaxeFortune);
        }
        if (Configs.isEnabled(BoxOfEternalClosureConfig.class)) {
            predefinedItems.put("evilcraft:box_of_eternal_closure_filled", BoxOfEternalClosure.boxOfEternalClosureFilled);
        }
        if (Configs.isEnabled(InvertedPotentiaConfig.class)) {
            ItemStack empoweredInvertedPotentia = new ItemStack((Item)InvertedPotentia.getInstance());
            InvertedPotentia.getInstance().empower(empoweredInvertedPotentia);
            predefinedItems.put("evilcraft:empowered_inverted_potentia", empoweredInvertedPotentia);
        }
        if (Configs.isEnabled(DarkTankConfig.class)) {
            ItemStack darkTankx9 = new ItemStack((Block)DarkTank.getInstance());
            fluidHandler = FluidHelpers.getFluidHandlerItemCapacity((ItemStack)darkTankx9);
            fluidHandler.setCapacity(fluidHandler.getCapacity() * 9);
            predefinedItems.put("evilcraft:dark_tankx9", darkTankx9);
        }
        if (PotentiaSphereConfig.enderPearlRecipe) {
            predefinedValues.add("evilcraft:ender_pearl_recipe");
        }
        if (Configs.isEnabled(VeinSwordConfig.class)) {
            ItemStack veinSwordLooting = VeinSword.createCraftingResult();
            predefinedItems.put("evilcraft:vein_sword_looting", veinSwordLooting);
        }
        if (WeatherContainerConfig.shapelessRecipes) {
            predefinedValues.add("evilcraft:shapeless_recipes");
        }
        if (Configs.isEnabled(BroomConfig.class)) {
            for (IBroomPart broomPart : BroomParts.REGISTRY.getParts()) {
                String id = String.format("%s:%s:%s", broomPart.getId().func_110624_b(), "broompart", broomPart.getId().func_110623_a());
                ItemStack itemStack = (ItemStack)Iterables.getFirst(BroomParts.REGISTRY.getItemsFromPart(broomPart), (Object)ItemStack.field_190927_a);
                if (itemStack.func_190926_b()) continue;
                predefinedItems.put(id, itemStack);
            }
        }
        predefinedItems.put("evilcraft:potion_weakness", PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionType.func_185168_a((String)"weakness")));
        if (Configs.isEnabled(PoisonConfig.class)) {
            ItemStack poisonBucket = new ItemStack(Items.field_151133_ar);
            fluidHandler = FluidUtil.getFluidHandler((ItemStack)poisonBucket);
            fluidHandler.fill(new FluidStack((Fluid)Poison.getInstance(), 1000), true);
            predefinedItems.put("evilcraft:bucket_poison", fluidHandler.getContainer());
        }
        ItemStack potionPoison = new ItemStack((Item)Items.field_151068_bn);
        PotionUtils.func_185188_a((ItemStack)potionPoison, (PotionType)PotionType.func_185168_a((String)"poison"));
        predefinedItems.put("minecraft:potion_poison", potionPoison);
    }

    protected void registerCustomRecipes() {
        super.registerCustomRecipes();
        if (Configs.isEnabled(EntangledChaliceConfig.class) && Configs.isEnabled(DarkGemConfig.class) && Configs.isEnabled(CorruptedTearConfig.class)) {
            Item tear = CorruptedTearConfig._instance.getItemInstance();
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "entangled_chalice"), (IRecipe)new ObservableShapedRecipe("", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)tear), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)DarkGem.getInstance()), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)DarkGem.getInstance()), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)Items.field_151043_k)}), new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 2), new IRecipeOutputObserver(){

                public ItemStack getRecipeOutput(InventoryCrafting craftingGrid, ItemStack output) {
                    ItemStack newStack = output.func_77946_l();
                    EntangledChaliceItem.FluidHandler fluidHandler = (EntangledChaliceItem.FluidHandler)FluidUtil.getFluidHandler((ItemStack)newStack);
                    if (!MinecraftHelpers.isClientSide()) {
                        fluidHandler.setNextTankID();
                    }
                    return fluidHandler.getContainer();
                }
            }));
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "entangled_chalice_1"), (IRecipe)new ObservableShapedRecipe("", 3, 3, NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)tear), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)DarkGem.getInstance()), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 1, Short.MAX_VALUE)}), Ingredient.func_193367_a((Item)DarkGem.getInstance()), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)Items.field_151043_k), Ingredient.func_193367_a((Item)Items.field_151043_k)}), new ItemStack(Item.func_150898_a((Block)EntangledChalice.getInstance()), 2), new IRecipeOutputObserver(){

                public ItemStack getRecipeOutput(InventoryCrafting craftingGrid, ItemStack output) {
                    ItemStack newStack = output.func_77946_l();
                    String tankID = ((EntangledChaliceItem.FluidHandler)FluidUtil.getFluidHandler((ItemStack)craftingGrid.func_70301_a(4))).getTankID();
                    ((EntangledChaliceItem.FluidHandler)FluidUtil.getFluidHandler((ItemStack)newStack)).setTankID(tankID);
                    return newStack;
                }
            }));
        }
        if (Configs.isEnabled(DarkTankConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                ItemBlockFluidContainer tankItem = (ItemBlockFluidContainer)Item.func_150898_a((Block)DarkTank.getInstance());
                CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "dark_tank_" + i), (IRecipe)new ItemBlockFluidContainerCombinationRecipe(i, tankItem, DarkTankConfig.maxTankSize));
            }
        }
        if (Configs.isEnabled(BloodExtractorConfig.class) && Configs.isEnabled(DarkTankConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "blood_extractor_" + i), (IRecipe)new BloodExtractorCombinationRecipe(i));
            }
        }
        if (Configs.isEnabled(BroomConfig.class)) {
            for (int i = 1; i < 9; ++i) {
                CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "broom_part_" + i), (IRecipe)new BroomPartCombinationRecipe(i));
            }
        }
        if (Configs.isEnabled(EnvironmentalAccumulatorConfig.class)) {
            ItemStack emptyContainer;
            ItemStack outputStack = null;
            String recipeName = null;
            if (Configs.isEnabled(WeatherContainerConfig.class)) {
                emptyContainer = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.EMPTY, 1);
                WeatherType[] weatherInputs = new WeatherType[]{WeatherType.CLEAR, WeatherType.LIGHTNING, WeatherType.RAIN};
                WeatherType[] weatherOutputs = new WeatherType[]{WeatherType.RAIN, WeatherType.RAIN, WeatherType.CLEAR};
                for (int i = 0; i < weatherInputs.length; ++i) {
                    recipeName = "weather_container" + weatherInputs[i].getClass().getSimpleName();
                    outputStack = WeatherContainer.createItemStack(WeatherContainer.WeatherContainerTypes.getWeatherContainerType(weatherInputs[i]), 1);
                    EnvironmentalAccumulator.getInstance().getRecipeRegistry().registerRecipe(recipeName, (IRecipeInput)new EnvironmentalAccumulatorRecipeComponent(emptyContainer, weatherInputs[i]), (IRecipeOutput)new EnvironmentalAccumulatorRecipeComponent(outputStack, weatherOutputs[i]), (IRecipeProperties)new EnvironmentalAccumulatorRecipeProperties());
                }
            }
            if (Configs.isEnabled(BiomeExtractConfig.class) && BiomeExtractConfig.hasRecipes) {
                emptyContainer = new ItemStack((Item)BiomeExtract.getInstance());
                ItemStack filledContainer = BiomeExtract.getInstance().createItemStack(null, 1);
                filledContainer.func_77964_b(Short.MAX_VALUE);
                EnvironmentalAccumulator.getInstance().getRecipeRegistry().registerRecipe(recipeName, (IRecipeInput)new EnvironmentalAccumulatorRecipeComponent(emptyContainer, WeatherType.ANY), (IRecipeOutput)new EnvironmentalAccumulatorRecipeComponent(filledContainer, WeatherType.ANY), (IRecipeProperties)new EnvironmentalAccumulatorRecipeProperties(1000, BiomeExtractConfig.envirAccCooldownTime, -1.0, null, new EnvironmentalAccumulatorRecipeProperties.IEAResultOverride(){

                    @Override
                    public ItemStack getResult(IBlockAccess world, BlockPos pos, ItemStack originalResult) {
                        World worldSafe = (World)world;
                        Biome biome = worldSafe.func_180494_b(pos);
                        if (BiomeExtractConfig._instance.isCraftingBlacklisted(Biome.func_185362_a((Biome)biome))) {
                            return BiomeExtract.getInstance().createItemStack(null, 1);
                        }
                        return BiomeExtract.getInstance().createItemStack(biome, 1);
                    }
                }));
            }
            if (Configs.isEnabled(DisplayStandConfig.class)) {
                this.getTaggedRecipes().put((Object)"craftingRecipe:display_stands", (Object)new Recipe((IRecipeInput)new IngredientsRecipeComponent(NonNullList.func_191196_a()), (IRecipeOutput)new IngredientRecipeComponent(DisplayStand.getInstance().getTypedDisplayStandItem(Blocks.field_150344_f.func_176223_P())), (IRecipeProperties)new DummyPropertiesComponent()));
                CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "display_stand"), (IRecipe)new DisplayStandRecipe((List<ItemStack>)OreDictionary.getOres((String)"plankWood")));
            }
            this.getTaggedRecipes().put((Object)"craftingRecipe:deadbush", (Object)new Recipe((IRecipeInput)new IngredientsRecipeComponent(NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151097_aZ), new OreIngredient("treeSapling")})), (IRecipeOutput)new IngredientRecipeComponent(new ItemStack((Block)Blocks.field_150330_I)), (IRecipeProperties)new DummyPropertiesComponent()));
            CraftingHelpers.registerRecipe((ResourceLocation)new ResourceLocation(this.getMod().getModId(), "deadbush"), (IRecipe)new DeadBushRecipe());
        }
    }
}

