/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.items;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.ItemFluidContainer;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import rustic.client.models.FluidBottleModel;
import rustic.common.blocks.fluids.FluidBooze;
import rustic.common.blocks.fluids.FluidDrinkable;
import rustic.common.blocks.fluids.ModFluids;
import rustic.common.items.ModItems;
import rustic.core.Rustic;

public class ItemFluidBottle
extends ItemFluidContainer {
    public static List<Fluid> VALID_FLUIDS = new ArrayList<Fluid>();
    public static final String FLUID_NBT_KEY = "Fluid";
    private final ItemStack empty;

    public static void addFluid(Fluid fluid) {
        VALID_FLUIDS.add(fluid);
    }

    public ItemFluidBottle() {
        super(1000);
        this.setRegistryName("fluid_bottle");
        this.func_77655_b("rustic.fluid_bottle");
        this.func_77637_a(Rustic.farmingTab);
        GameRegistry.findRegistry(Item.class).register((IForgeRegistryEntry)this);
        this.empty = new ItemStack(Items.field_151069_bo);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ItemMeshDefinition meshDefinition = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return FluidBottleModel.LOCATION;
            }
        };
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)meshDefinition);
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{FluidBottleModel.LOCATION});
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack func_190903_i() {
        NBTTagCompound nbt = new FluidStack(ModFluids.OLIVE_OIL, 1000).writeToNBT(new NBTTagCompound());
        ItemStack stack = super.func_190903_i();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(FLUID_NBT_KEY, (NBTBase)nbt);
        stack.func_77982_d(nbt);
        return stack;
    }

    @Nonnull
    public ItemStack getFilledBottle(Fluid fluid) {
        ItemStack bottle = new ItemStack((Item)this);
        if (VALID_FLUIDS.contains(fluid) && FluidRegistry.getFluidName((Fluid)fluid) != null) {
            NBTTagCompound fluidTag = new NBTTagCompound();
            FluidStack fluidStack = new FluidStack(fluid, this.getCapacity());
            fluidStack.writeToNBT(fluidTag);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(FLUID_NBT_KEY, (NBTBase)fluidTag);
            bottle.func_77982_d(tag);
        }
        return bottle;
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        Fluid fluid;
        EntityPlayer entityplayer = entityLiving instanceof EntityPlayer ? (EntityPlayer)entityLiving : null;
        FluidStack fluidstack = this.getFluid(stack);
        Fluid fluid2 = fluid = fluidstack.getFluid() != null ? fluidstack.getFluid() : null;
        if (!worldIn.field_72995_K && fluid instanceof FluidDrinkable && entityplayer != null) {
            ((FluidDrinkable)fluid).onDrank(worldIn, entityplayer, stack, fluidstack);
        }
        if (entityplayer != null) {
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        if (entityplayer == null || !entityplayer.field_71075_bZ.field_75098_d) {
            if (stack.func_190926_b()) {
                return new ItemStack(Items.field_151069_bo);
            }
            if (entityplayer != null) {
                entityplayer.field_71071_by.func_70441_a(new ItemStack(Items.field_151069_bo));
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.getFluid(stack) != null && this.getFluid(stack).getFluid() != null && this.getFluid(stack).getFluid() instanceof FluidDrinkable) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nullable
    public FluidStack getFluid(@Nonnull ItemStack container) {
        if (container.func_77942_o() && container.func_77978_p().func_74764_b(FLUID_NBT_KEY)) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l(FLUID_NBT_KEY));
        }
        return null;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean hasContainerItem(@Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return this.empty;
    }

    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            return this.empty.func_82833_r();
        }
        String unloc = this.func_77667_c(stack);
        return I18n.func_74837_a((String)(unloc + ".name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (Fluid fluid : VALID_FLUIDS) {
                ItemStack stack = this.getFilledBottle(fluid);
                if (fluid instanceof FluidBooze && stack.func_77942_o() && stack.func_77978_p().func_74764_b(FLUID_NBT_KEY)) {
                    NBTTagCompound fluidTag = stack.func_77978_p().func_74775_l(FLUID_NBT_KEY);
                    if (!fluidTag.func_74764_b("Tag")) {
                        fluidTag.func_74782_a("Tag", (NBTBase)new NBTTagCompound());
                    }
                    if (!fluidTag.func_74775_l("Tag").func_74764_b("Quality")) {
                        fluidTag.func_74775_l("Tag").func_74776_a("Quality", 0.75f);
                    }
                }
                subItems.add((Object)stack);
            }
        }
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable NBTTagCompound nbt) {
        FluidHandlerItemStack.SwapEmpty handler = new FluidHandlerItemStack.SwapEmpty(stack, this.empty, this.capacity){

            public boolean canFillFluidType(FluidStack fluidstack) {
                return VALID_FLUIDS.contains(fluidstack.getFluid());
            }

            public int fill(FluidStack resource, boolean doFill) {
                if (resource == null || resource.amount < 1000 || this.getFluid() != null || !this.canFillFluidType(resource)) {
                    return 0;
                }
                if (doFill) {
                    this.setFluid(resource.copy());
                }
                return 1000;
            }

            protected void setFluid(@Nullable FluidStack fluid) {
                if (fluid == null) {
                    this.container = new ItemStack(Items.field_151069_bo);
                } else {
                    this.container = new ItemStack((Item)ModItems.FLUID_BOTTLE);
                    FluidStack fs = fluid.copy();
                    fs.amount = 1000;
                    NBTTagCompound fluidTag = fs.writeToNBT(new NBTTagCompound());
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74782_a(ItemFluidBottle.FLUID_NBT_KEY, (NBTBase)fluidTag);
                    this.container.func_77982_d(tag);
                }
            }

            public FluidStack drain(FluidStack resource, boolean doDrain) {
                if (resource == null || resource.amount < 1000) {
                    return null;
                }
                return super.drain(resource, doDrain);
            }

            public FluidStack drain(int maxDrain, boolean doDrain) {
                if (maxDrain < 1000) {
                    return null;
                }
                return super.drain(maxDrain, doDrain);
            }

            @Nonnull
            public ItemStack getContainer() {
                FluidStack contained = this.getFluid();
                if (contained == null || contained.getFluid() == null || contained.amount <= 0) {
                    return new ItemStack(Items.field_151069_bo);
                }
                return this.container;
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)((Object)(capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY ? this : null));
            }
        };
        return handler;
    }
}

