/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.tileentity;

import java.util.BitSet;
import java.util.List;
import me.desht.pneumaticcraft.common.tileentity.TileEntityBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidTank;

public abstract class FastFluidTESR<T extends TileEntityBase>
extends FastTESR<T> {
    private static final float FLUID_ALPHA = 0.9f;

    public void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        if (!te.func_145831_w().func_72863_F().func_186025_d(te.func_174877_v().func_177958_n() >> 4, te.func_174877_v().func_177952_p() >> 4).func_76621_g()) {
            for (TankRenderInfo tankRenderInfo : this.getTanksToRender(te)) {
                this.doRender(te, x, y, z, buffer, tankRenderInfo);
            }
        }
    }

    private void doRender(T te, double x, double y, double z, BufferBuilder buffer, TankRenderInfo tankRenderInfo) {
        IFluidTank tank = tankRenderInfo.tank;
        if (tank.getFluidAmount() == 0) {
            return;
        }
        Fluid f = tank.getFluid().getFluid();
        TextureAtlasSprite still = Minecraft.func_71410_x().func_147117_R().func_110572_b(f.getStill().toString());
        float u1 = still.func_94209_e();
        float v1 = still.func_94206_g();
        float u2 = still.func_94212_f();
        float v2 = still.func_94210_h();
        buffer.func_178969_c(x, y, z);
        AxisAlignedBB bounds = this.getRenderBounds(tank, tankRenderInfo.bounds);
        if (tankRenderInfo.shouldRender(EnumFacing.DOWN)) {
            int downCombined = this.func_178459_a().func_175626_b(te.func_174877_v().func_177977_b(), 0);
            int downLMa = downCombined >> 16 & 0xFFFF;
            int downLMb = downCombined & 0xFFFF;
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v2).func_187314_a(downLMa, downLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v1).func_187314_a(downLMa, downLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v1).func_187314_a(downLMa, downLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v2).func_187314_a(downLMa, downLMb).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(EnumFacing.UP)) {
            int upCombined = this.func_178459_a().func_175626_b(te.func_174877_v().func_177984_a(), 0);
            int upLMa = upCombined >> 16 & 0xFFFF;
            int upLMb = upCombined & 0xFFFF;
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v2).func_187314_a(upLMa, upLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v2).func_187314_a(upLMa, upLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v1).func_187314_a(upLMa, upLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v1).func_187314_a(upLMa, upLMb).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(EnumFacing.NORTH)) {
            int northCombined = this.func_178459_a().func_175626_b(te.func_174877_v().func_177978_c(), 0);
            int northLMa = northCombined >> 16 & 0xFFFF;
            int northLMb = northCombined & 0xFFFF;
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v1).func_187314_a(northLMa, northLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v2).func_187314_a(northLMa, northLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v2).func_187314_a(northLMa, northLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v1).func_187314_a(northLMa, northLMb).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(EnumFacing.SOUTH)) {
            int southCombined = this.func_178459_a().func_175626_b(te.func_174877_v().func_177968_d(), 0);
            int southLMa = southCombined >> 16 & 0xFFFF;
            int southLMb = southCombined & 0xFFFF;
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v1).func_187314_a(southLMa, southLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v2).func_187314_a(southLMa, southLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v2).func_187314_a(southLMa, southLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v1).func_187314_a(southLMa, southLMb).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(EnumFacing.WEST)) {
            int westCombined = this.func_178459_a().func_175626_b(te.func_174877_v().func_177976_e(), 0);
            int westLMa = westCombined >> 16 & 0xFFFF;
            int westLMb = westCombined & 0xFFFF;
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v2).func_187314_a(westLMa, westLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v2).func_187314_a(westLMa, westLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v1).func_187314_a(westLMa, westLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v1).func_187314_a(westLMa, westLMb).func_181675_d();
        }
        if (tankRenderInfo.shouldRender(EnumFacing.EAST)) {
            int eastCombined = this.func_178459_a().func_175626_b(te.func_174877_v().func_177974_f(), 0);
            int eastLMa = eastCombined >> 16 & 0xFFFF;
            int eastLMb = eastCombined & 0xFFFF;
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v1).func_187314_a(eastLMa, eastLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v1).func_187314_a(eastLMa, eastLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u2, (double)v2).func_187314_a(eastLMa, eastLMb).func_181675_d();
            buffer.func_181662_b(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f).func_181666_a(1.0f, 1.0f, 1.0f, 0.9f).func_187315_a((double)u1, (double)v2).func_187314_a(eastLMa, eastLMb).func_181675_d();
        }
    }

    private AxisAlignedBB getRenderBounds(IFluidTank tank, AxisAlignedBB tankBounds) {
        float percent = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double tankHeight = tankBounds.field_72337_e - tankBounds.field_72338_b;
        double y1 = tankBounds.field_72338_b;
        double y2 = tankBounds.field_72338_b + tankHeight * (double)percent;
        if (tank.getFluid().getFluid().getDensity() < 0) {
            double yOff = tankBounds.field_72337_e - y2;
            y1 += yOff;
            y2 += yOff;
        }
        return new AxisAlignedBB(tankBounds.field_72340_a, y1, tankBounds.field_72339_c, tankBounds.field_72336_d, y2, tankBounds.field_72334_f);
    }

    static AxisAlignedBB rotateY(AxisAlignedBB in, int rot) {
        switch (rot) {
            case 90: {
                return new AxisAlignedBB(1.0 - in.field_72339_c, in.field_72338_b, in.field_72340_a, 1.0 - in.field_72334_f, in.field_72337_e, in.field_72336_d);
            }
            case 180: {
                return new AxisAlignedBB(1.0 - in.field_72340_a, in.field_72338_b, 1.0 - in.field_72339_c, 1.0 - in.field_72336_d, in.field_72337_e, 1.0 - in.field_72334_f);
            }
            case 270: {
                return new AxisAlignedBB(in.field_72339_c, in.field_72338_b, 1.0 - in.field_72340_a, in.field_72334_f, in.field_72337_e, 1.0 - in.field_72336_d);
            }
        }
        throw new IllegalArgumentException("rot must be 90, 180 or 270");
    }

    abstract List<TankRenderInfo> getTanksToRender(T var1);

    class TankRenderInfo {
        final IFluidTank tank;
        final AxisAlignedBB bounds;
        final BitSet faces = new BitSet(6);

        TankRenderInfo(IFluidTank tank, AxisAlignedBB bounds, EnumFacing ... renderFaces) {
            this.tank = tank;
            this.bounds = bounds;
            if (renderFaces.length == 0) {
                this.faces.set(0, 6, true);
            } else {
                for (EnumFacing face : renderFaces) {
                    this.faces.set(face.func_176745_a(), true);
                }
            }
        }

        TankRenderInfo without(EnumFacing face) {
            this.faces.clear(face.func_176745_a());
            return this;
        }

        boolean shouldRender(EnumFacing face) {
            return this.faces.get(face.func_176745_a());
        }
    }
}

