/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.tileEntities.machines;

import com.mjr.extraplanets.blocks.machines.AdvancedRefinery;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.wrappers.FluidHandlerWrapper;
import micdoodle8.mods.galacticraft.core.wrappers.IFluidHandlerWrapper;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityAdvancedRefinery
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IFluidHandlerWrapper {
    private final int tankCapacity = 48000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank oilTank = new FluidTank(this.tankCapacity);
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public static final int PROCESS_TIME_REQUIRED = 1;
    public static final int OUTPUT_PER_SECOND = 2;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);

    public TileEntityAdvancedRefinery() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.oilTank.setFluid(new FluidStack(GCFluids.fluidOil, 0));
        this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, 0));
    }

    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            FluidStack liquid = FluidUtil.getFluidContained((ItemStack)((ItemStack)this.stacks.get(1)));
            if (FluidUtil.isFluidFuzzy((FluidStack)liquid, (String)"oil")) {
                FluidUtil.loadFromContainer((FluidTank)this.oilTank, (Fluid)GCFluids.fluidOil, this.stacks, (int)1, (int)liquid.amount);
            }
            this.checkFluidTankTransfer(2, this.fuelTank);
            if (this.canProcess() && this.hasEnoughEnergyToRun) {
                if (this.processTicks == 0) {
                    this.processTicks = this.getProcessTimeRequired();
                } else if (--this.processTicks <= 0) {
                    this.smeltItem();
                    this.processTicks = this.canProcess() ? this.getProcessTimeRequired() : 0;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private int getProcessTimeRequired() {
        return this.poweredByTierGC > 1 ? 1 : 1;
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidUtil.tryFillContainerFuel((FluidTank)tank, this.stacks, (int)slot);
    }

    public int getScaledOilLevel(int i) {
        return this.oilTank.getFluidAmount() * i / this.oilTank.getCapacity();
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluidAmount() * i / this.fuelTank.getCapacity();
    }

    public boolean canProcess() {
        if (this.oilTank.getFluidAmount() <= 0) {
            return false;
        }
        if (this.fuelTank.getFluidAmount() >= this.fuelTank.getCapacity()) {
            return false;
        }
        return !this.getDisabled(0);
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int oilAmount = this.oilTank.getFluidAmount();
            int fuelSpace = this.fuelTank.getCapacity() - this.fuelTank.getFluidAmount();
            int amountToDrain = Math.min(Math.min(oilAmount, fuelSpace), 2);
            this.oilTank.drain(amountToDrain, true);
            this.fuelTank.fill(FluidRegistry.getFluidStack((String)(ConfigManagerCore.useOldFuelFluidID ? "fuelgc" : "fuel"), (int)amountToDrain), true);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        this.stacks = this.readStandardItemsFromNBT(nbt);
        if (nbt.func_74764_b("oilTank")) {
            this.oilTank.readFromNBT(nbt.func_74775_l("oilTank"));
        }
        if (this.oilTank.getFluid() != null && this.oilTank.getFluid().getFluid() != GCFluids.fluidOil) {
            this.oilTank.setFluid(new FluidStack(GCFluids.fluidOil, this.oilTank.getFluidAmount()));
        }
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid() != GCFluids.fluidFuel) {
            this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, this.fuelTank.getFluidAmount()));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(nbt, this.stacks);
        if (this.oilTank.getFluid() != null) {
            nbt.func_74782_a("oilTank", (NBTBase)this.oilTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        return nbt;
    }

    protected NonNullList<ItemStack> getContainingItems() {
        return this.stacks;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"container.advanced.refinery.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemCharged((ItemStack)itemStack);
                }
                case 1: {
                    return FluidUtil.isOilContainerAny((ItemStack)itemStack);
                }
                case 2: {
                    return FluidUtil.isPartialContainer((ItemStack)itemStack, (Item)GCItems.fuelCanister);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemStack, EnumFacing side) {
        if (itemStack != null && this.func_94041_b(slotID, itemStack)) {
            switch (slotID) {
                case 0: {
                    return ItemElectricBase.isElectricItemEmpty((ItemStack)itemStack) || !this.shouldPullEnergy();
                }
                case 1: {
                    return FluidUtil.isEmptyContainer((ItemStack)itemStack);
                }
                case 2: {
                    return FluidUtil.isFullContainer((ItemStack)itemStack);
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: 
            case 2: {
                return FluidUtil.isValidContainer((ItemStack)itemStack);
            }
        }
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public EnumFacing getElectricInputDirection() {
        return EnumFacing.UP;
    }

    public EnumFacing getFront() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof AdvancedRefinery) {
            return (EnumFacing)state.func_177229_b((IProperty)AdvancedRefinery.FACING);
        }
        return EnumFacing.NORTH;
    }

    private EnumFacing getOilPipe() {
        return this.getFront().func_176746_e();
    }

    private EnumFacing getFuelPipe() {
        return this.getFront().func_176735_f();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        if (from == this.getFuelPipe()) {
            return this.fuelTank.getFluid() != null && this.fuelTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (from == this.getFuelPipe() && resource != null) {
            return this.fuelTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (from == this.getFuelPipe()) {
            return this.drain(from, new FluidStack(GCFluids.fluidFuel, maxDrain), doDrain);
        }
        return null;
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (from == this.getOilPipe()) {
            return this.oilTank.getFluid() == null || this.oilTank.getFluidAmount() < this.oilTank.getCapacity();
        }
        return false;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from == this.getOilPipe() && resource != null && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && FluidUtil.testOil((String)liquidName)) {
            used = liquidName.equals(GCFluids.fluidOil.getName()) ? this.oilTank.fill(resource, doFill) : this.oilTank.fill(new FluidStack(GCFluids.fluidOil, resource.amount), doFill);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == this.getOilPipe()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.oilTank)};
        } else if (from == this.getFuelPipe()) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
        }
        return tankInfo;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper((IFluidHandlerWrapper)this, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null) {
            return false;
        }
        if (type == NetworkType.POWER) {
            return direction == this.getElectricInputDirection();
        }
        if (type == NetworkType.FLUID) {
            EnumFacing pipeSide = this.getFuelPipe();
            return direction == pipeSide || direction == pipeSide.func_176734_d();
        }
        return false;
    }
}

