/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanets_SolarSystems;
import com.mjr.extraplanets.planets.Ceres.TeleportTypeCeres;
import com.mjr.extraplanets.planets.Ceres.WorldProviderCeres;
import com.mjr.extraplanets.planets.Ceres.worldgen.CeresBiomes;
import com.mjr.extraplanets.planets.Eris.TeleportTypeEris;
import com.mjr.extraplanets.planets.Eris.WorldProviderEris;
import com.mjr.extraplanets.planets.Eris.worldgen.ErisBiomes;
import com.mjr.extraplanets.planets.Jupiter.TeleportTypeJupiter;
import com.mjr.extraplanets.planets.Jupiter.WorldProviderJupiter;
import com.mjr.extraplanets.planets.Jupiter.worldgen.JupiterBiomes;
import com.mjr.extraplanets.planets.Kepler22b.TeleportTypeKepler22b;
import com.mjr.extraplanets.planets.Kepler22b.WorldProviderKepler22b;
import com.mjr.extraplanets.planets.Kepler22b.worldgen.Kepler22bBiomes;
import com.mjr.extraplanets.planets.Mercury.TeleportTypeMercury;
import com.mjr.extraplanets.planets.Mercury.WorldProviderMercury;
import com.mjr.extraplanets.planets.Mercury.worldgen.MercuryBiomes;
import com.mjr.extraplanets.planets.Neptune.TeleportTypeNeptune;
import com.mjr.extraplanets.planets.Neptune.WorldProviderNeptune;
import com.mjr.extraplanets.planets.Neptune.worldgen.NeptuneBiomes;
import com.mjr.extraplanets.planets.Pluto.TeleportTypePluto;
import com.mjr.extraplanets.planets.Pluto.WorldProviderPluto;
import com.mjr.extraplanets.planets.Pluto.worldgen.PlutoBiomes;
import com.mjr.extraplanets.planets.Saturn.TeleportTypeSaturn;
import com.mjr.extraplanets.planets.Saturn.WorldProviderSaturn;
import com.mjr.extraplanets.planets.Saturn.worldgen.SaturnBiomes;
import com.mjr.extraplanets.planets.Uranus.TeleportTypeUranus;
import com.mjr.extraplanets.planets.Uranus.WorldProviderUranus;
import com.mjr.extraplanets.planets.Uranus.worldgen.UranusBiomes;
import com.mjr.extraplanets.util.GCRegisterUtilities;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.world.AtmosphereInfo;
import micdoodle8.mods.galacticraft.api.world.EnumAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedEnderman;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;

public class ExtraPlanets_Planets {
    public static Planet MERCURY;
    public static Planet CERES;
    public static Planet JUPITER;
    public static Planet SATURN;
    public static Planet URANUS;
    public static Planet NEPTUNE;
    public static Planet PLUTO;
    public static Planet HAUNEA;
    public static Planet ERIS;
    public static Planet KUIPER_BELT;
    public static Planet MAKEMAKE;
    public static Planet KEPLER22B;
    public static Planet KEPLER47B;
    public static Planet KEPLER47C;
    public static Planet KEPLER62B;
    public static Planet KEPLER62C;
    public static Planet KEPLER62D;
    public static Planet KEPLER62E;
    public static Planet KEPLER62F;
    public static Planet KEPLER69B;
    public static Planet KEPLER69C;
    public static Planet TATOOINE;
    public static Planet CRAIT;
    public static Planet HOTH;
    public static Planet AQUA;
    public static Planet QUSTROITHEA;
    public static Planet JETRARUTA;
    public static Planet MOSWION;
    public static Planet KETHERTH;
    public static Planet XOVIS;
    public static Planet OARILIA;
    public static Planet STRURONIDES;
    public static Planet BRAJUTOV;
    public static Planet SPESHANI16;
    public static Planet TRARS9;

    public static void init() {
        ExtraPlanets_Planets.initializePlanets();
        ExtraPlanets_Planets.registerPlanets();
        ExtraPlanets_Planets.initializeUnReachablePlanets();
    }

    private static void initializePlanets() {
        if (Config.MERCURY) {
            MERCURY = new Planet(Config.GALAXY_SPACE_COMPATIBILITY ? "MercuryEP" : "Mercury").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            MERCURY.setTierRequired(3);
            MERCURY.setRingColorRGB(0.1f, 0.9f, 0.6f);
            MERCURY.setPhaseShift(Config.GALAXY_SPACE_COMPATIBILITY ? 0.0f : 1.45f);
            MERCURY.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f + Config.MERCURY_DISTANCE_OFFSET, 0.5f + Config.MERCURY_DISTANCE_OFFSET));
            MERCURY.setRelativeOrbitTime(0.24096386f);
            MERCURY.atmosphereComponent(EnumAtmosphericGas.HYDROGEN);
            MERCURY.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/mercury.png"));
            MERCURY.setDimensionInfo(Config.MERCURY_ID, WorldProviderMercury.class);
            MERCURY.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? 50.0f : 5.0f, 0.0f, 0.1f));
            MERCURY.addChecklistKeys(new String[]{"tier_3_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            MERCURY.setBiomeInfo(new Biome[]{MercuryBiomes.mercury});
            MERCURY.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            MERCURY.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            MERCURY.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            MERCURY.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            MERCURY.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.CERES) {
            CERES = new Planet(Config.GALAXY_SPACE_COMPATIBILITY ? "CeresEP" : "Ceres").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            CERES.setTierRequired(4);
            CERES.setRingColorRGB(0.1f, 0.9f, 0.6f);
            CERES.setPhaseShift(Config.GALAXY_SPACE_COMPATIBILITY ? 6.0f : (float)Math.PI);
            CERES.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f + Config.CERES_DISTANCE_OFFSET, 1.5f + Config.CERES_DISTANCE_OFFSET));
            CERES.setRelativeOrbitTime(5.930997f);
            CERES.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM);
            CERES.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/ceres.png"));
            CERES.setDimensionInfo(Config.CERES_ID, WorldProviderCeres.class);
            CERES.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, -1.5f, 5.0f, 0.1f));
            CERES.addChecklistKeys(new String[]{"thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            CERES.setBiomeInfo(new Biome[]{CeresBiomes.ceres});
            CERES.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            CERES.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            CERES.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            CERES.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            CERES.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.JUPITER) {
            JUPITER = new Planet(Config.GALAXY_SPACE_COMPATIBILITY ? "JupiterEP" : "Jupiter").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            JUPITER.setTierRequired(4);
            JUPITER.setRingColorRGB(0.1f, 0.9f, 0.6f);
            JUPITER.setPhaseShift(Config.GALAXY_SPACE_COMPATIBILITY ? 0.0f : (float)Math.PI);
            JUPITER.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f + Config.JUPITER_DISTANCE_OFFSET, 1.75f + Config.JUPITER_DISTANCE_OFFSET));
            JUPITER.setRelativeOrbitTime(11.861994f);
            JUPITER.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM);
            JUPITER.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/jupiter.png"));
            JUPITER.setDimensionInfo(Config.JUPITER_ID, WorldProviderJupiter.class);
            JUPITER.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, true, 100.0f, 3.0f, 0.1f));
            JUPITER.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute", "equip_shield_controller"});
            JUPITER.setBiomeInfo(new Biome[]{JupiterBiomes.jupiter, JupiterBiomes.jupiterMagmaSea, JupiterBiomes.jupiterSands});
            JUPITER.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            JUPITER.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            JUPITER.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            JUPITER.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            JUPITER.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.SATURN) {
            SATURN = new Planet("Saturn").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            SATURN.setTierRequired(5);
            SATURN.setRingColorRGB(0.1f, 0.9f, 0.6f);
            SATURN.setPhaseShift(5.45f);
            SATURN.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f + Config.SATURN_DISTANCE_OFFSET, 2.0f + Config.SATURN_DISTANCE_OFFSET));
            SATURN.setRelativeOrbitTime(29.463308f);
            SATURN.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE);
            SATURN.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/saturn.png"));
            SATURN.setDimensionInfo(Config.SATURN_ID, WorldProviderSaturn.class);
            SATURN.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, true, 80.0f, 0.0f, 0.1f));
            SATURN.addChecklistKeys(new String[]{"tier_4_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute", "equip_shield_controller"});
            SATURN.setBiomeInfo(new Biome[]{SaturnBiomes.saturn, SaturnBiomes.saturnHydroCarbonSea, SaturnBiomes.saturnNuclearLand});
            SATURN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            SATURN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            SATURN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            SATURN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            SATURN.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.URANUS) {
            URANUS = new Planet("Uranus").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            URANUS.setTierRequired(6);
            URANUS.setRingColorRGB(0.1f, 0.9f, 0.6f);
            URANUS.setPhaseShift(1.38f);
            URANUS.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.25f + Config.URANUS_DISTANCE_OFFSET, 2.25f + Config.URANUS_DISTANCE_OFFSET));
            URANUS.setRelativeOrbitTime(84.06353f);
            URANUS.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.METHANE).atmosphereComponent(EnumAtmosphericGas.WATER);
            URANUS.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/uranus.png"));
            URANUS.setDimensionInfo(Config.URANUS_ID, WorldProviderUranus.class);
            URANUS.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, true, -120.0f, 4.0f, 0.1f));
            URANUS.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute", "equip_shield_controller"});
            URANUS.setBiomeInfo(new Biome[]{UranusBiomes.uranus, UranusBiomes.uranusFrozenWaterSea, UranusBiomes.uranusSnowLands});
            URANUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            URANUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            URANUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            URANUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            URANUS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.NEPTUNE) {
            NEPTUNE = new Planet(Config.GALAXY_SPACE_COMPATIBILITY ? "NeptuneEP" : "Neptune").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            NEPTUNE.setTierRequired(7);
            NEPTUNE.setRingColorRGB(0.1f, 0.9f, 0.6f);
            NEPTUNE.setPhaseShift(Config.GALAXY_SPACE_COMPATIBILITY ? 8.0f : 1.0f);
            NEPTUNE.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f + Config.NEPTUNE_DISTANCE_OFFSET, 2.5f + Config.NEPTUNE_DISTANCE_OFFSET));
            NEPTUNE.setRelativeOrbitTime(164.84119f);
            NEPTUNE.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.WATER);
            NEPTUNE.setBodyIcon(new ResourceLocation("galacticraftcore:textures/gui/celestialbodies/neptune.png"));
            NEPTUNE.setDimensionInfo(Config.NEPTUNE_ID, WorldProviderNeptune.class);
            NEPTUNE.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, true, -140.0f, 5.0f, 0.1f));
            NEPTUNE.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute", "equip_shield_controller"});
            NEPTUNE.setBiomeInfo(new Biome[]{NeptuneBiomes.neptune, NeptuneBiomes.neptuneLayeredHills, NeptuneBiomes.neptuneRadioActiveWaterSea});
            NEPTUNE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            NEPTUNE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            NEPTUNE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            NEPTUNE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            NEPTUNE.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.PLUTO) {
            PLUTO = new Planet(Config.GALAXY_SPACE_COMPATIBILITY ? "PlutoEP" : "Pluto").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            PLUTO.setTierRequired(8);
            PLUTO.setRingColorRGB(0.1f, 0.9f, 0.6f);
            PLUTO.setPhaseShift(Config.GALAXY_SPACE_COMPATIBILITY ? 0.0f : 2.0f);
            PLUTO.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.75f + Config.PLUTO_DISTANCE_OFFSET, 2.75f + Config.PLUTO_DISTANCE_OFFSET));
            PLUTO.setRelativeOrbitTime(329.68237f);
            PLUTO.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.WATER);
            PLUTO.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/pluto.png"));
            PLUTO.setDimensionInfo(Config.PLUTO_ID, WorldProviderPluto.class);
            PLUTO.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? -140.0f : 5.0f, 5.0f, 0.1f));
            PLUTO.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            PLUTO.setBiomeInfo(new Biome[]{PlutoBiomes.pluto});
            PLUTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            PLUTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            PLUTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            PLUTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            PLUTO.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.ERIS) {
            ERIS = new Planet("Eris").setParentSolarSystem(GalacticraftCore.solarSystemSol);
            ERIS.setTierRequired(9);
            ERIS.setRingColorRGB(0.1f, 0.9f, 0.6f);
            ERIS.setPhaseShift(1.0f);
            ERIS.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.75f + Config.ERIS_DISTANCE_OFFSET, 3.75f + Config.ERIS_DISTANCE_OFFSET));
            ERIS.setRelativeOrbitTime(494.52356f);
            ERIS.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.WATER);
            ERIS.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/eris.png"));
            ERIS.setDimensionInfo(Config.ERIS_ID, WorldProviderEris.class);
            ERIS.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(false), false, false, Config.THERMAL_PADDINGS ? -150.0f : 5.0f, 5.0f, 0.1f));
            ERIS.addChecklistKeys(new String[]{"tier_5_thermal_padding", "space_suit", "equip_oxygen_suit", "equip_parachute"});
            ERIS.setBiomeInfo(new Biome[]{ErisBiomes.eris});
            ERIS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedZombie.class, 8, 2, 3));
            ERIS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSpider.class, 8, 2, 3));
            ERIS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedSkeleton.class, 8, 2, 3));
            ERIS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedCreeper.class, 8, 2, 3));
            ERIS.addMobInfo(new Biome.SpawnListEntry(EntityEvolvedEnderman.class, 10, 1, 4));
        }
        if (Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            KEPLER22B = new Planet("kepler22b").setParentSolarSystem(ExtraPlanets_SolarSystems.kepler22);
            KEPLER22B.setTierRequired(10);
            KEPLER22B.setRingColorRGB(0.1f, 0.9f, 0.6f);
            KEPLER22B.setPhaseShift(1.45f);
            KEPLER22B.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f));
            KEPLER22B.setRelativeOrbitTime(164.84119f);
            KEPLER22B.atmosphereComponent(EnumAtmosphericGas.HYDROGEN).atmosphereComponent(EnumAtmosphericGas.HELIUM).atmosphereComponent(EnumAtmosphericGas.WATER).atmosphereComponent(EnumAtmosphericGas.OXYGEN);
            KEPLER22B.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler22b.png"));
            KEPLER22B.setDimensionInfo(Config.KEPLER22B_ID, WorldProviderKepler22b.class);
            KEPLER22B.setAtmosphere(new AtmosphereInfo(Boolean.valueOf(true), true, false, 0.0f, 5.0f, 0.05f));
            KEPLER22B.addChecklistKeys(new String[]{"equip_parachute"});
            KEPLER22B.setBiomeInfo(new Biome[]{Kepler22bBiomes.kepler22bBlueForest, Kepler22bBiomes.kepler22bCandyLand, Kepler22bBiomes.kepler22bCoalPlains, Kepler22bBiomes.kepler22bDiamondPlains, Kepler22bBiomes.kepler22bEmeraldPlains, Kepler22bBiomes.kepler22bGoldPlains, Kepler22bBiomes.kepler22bIronPlains, Kepler22bBiomes.kepler22bPlains, Kepler22bBiomes.kepler22bPurpleForest, Kepler22bBiomes.kepler22bRedDesert, Kepler22bBiomes.kepler22bRedForest, Kepler22bBiomes.kepler22bWasteLands, Kepler22bBiomes.kepler22bYellowForest});
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityZombie.class, 100, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntitySpider.class, 100, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntitySkeleton.class, 100, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityCreeper.class, 100, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityEnderman.class, 100, 1, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityWitch.class, 5, 1, 1));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntitySheep.class, 12, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityPig.class, 10, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityChicken.class, 10, 4, 4));
            KEPLER22B.addMobInfo(new Biome.SpawnListEntry(EntityCow.class, 8, 4, 4));
        }
    }

    public static void initializeUnReachablePlanets() {
        if (Config.KUIPER_BELT && !Config.GALAXY_SPACE_COMPATIBILITY && (KUIPER_BELT = GCRegisterUtilities.registerUnreachablePlanet("kuiperBelt", GalacticraftCore.solarSystemSol)) != null) {
            KUIPER_BELT.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.0f + Config.KUIPER_BELT_DISTANCE_OFFSET, 4.0f + Config.KUIPER_BELT_DISTANCE_OFFSET)).setRelativeOrbitTime(164.84119f);
            KUIPER_BELT.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kuiper_belt.png"));
        }
        if (Config.MAKEMAKE && (MAKEMAKE = GCRegisterUtilities.registerUnreachablePlanet("makemake", GalacticraftCore.solarSystemSol)) != null) {
            MAKEMAKE.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.5f + Config.MAKEMAKE_DISTANCE_OFFSET, 4.5f + Config.MAKEMAKE_DISTANCE_OFFSET)).setRelativeOrbitTime(164.84119f);
            MAKEMAKE.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/makemake.png"));
        }
        if (Config.HAUMEA && (HAUNEA = GCRegisterUtilities.registerUnreachablePlanet("haumea", GalacticraftCore.solarSystemSol)) != null) {
            HAUNEA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.5f + Config.HAUMEA_DISTANCE_OFFSET, 3.5f + Config.HAUMEA_DISTANCE_OFFSET)).setRelativeOrbitTime(164.84119f);
            HAUNEA.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/haumea.png"));
        }
        if (Config.KEPLER_SOLAR_SYSTEMS) {
            KEPLER47B = GCRegisterUtilities.registerUnreachablePlanet("kepler47b", ExtraPlanets_SolarSystems.kepler47);
            if (KEPLER47B != null) {
                KEPLER47B.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(164.84119f);
                KEPLER47B.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler47b.png"));
            }
            if ((KEPLER47C = GCRegisterUtilities.registerUnreachablePlanet("kepler47c", ExtraPlanets_SolarSystems.kepler47)) != null) {
                KEPLER47C.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(164.84119f);
                KEPLER47C.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler47c.png"));
            }
            if ((KEPLER62B = GCRegisterUtilities.registerUnreachablePlanet("kepler62b", ExtraPlanets_SolarSystems.kepler62)) != null) {
                KEPLER62B.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(0.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(27.473532f);
                KEPLER62B.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62b.png"));
            }
            if ((KEPLER62C = GCRegisterUtilities.registerUnreachablePlanet("kepler62c", ExtraPlanets_SolarSystems.kepler62)) != null) {
                KEPLER62C.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(32.96824f);
                KEPLER62C.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62c.png"));
            }
            if ((KEPLER62D = GCRegisterUtilities.registerUnreachablePlanet("kepler62d", ExtraPlanets_SolarSystems.kepler62)) != null) {
                KEPLER62D.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f)).setRelativeOrbitTime(41.210297f);
                KEPLER62D.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62d.png"));
            }
            if ((KEPLER62E = GCRegisterUtilities.registerUnreachablePlanet("kepler62e", ExtraPlanets_SolarSystems.kepler62)) != null) {
                KEPLER62E.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(3.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f)).setRelativeOrbitTime(54.947063f);
                KEPLER62E.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62e.png"));
            }
            if ((KEPLER62F = GCRegisterUtilities.registerUnreachablePlanet("kepler62f", ExtraPlanets_SolarSystems.kepler62)) != null) {
                KEPLER62F.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(4.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f)).setRelativeOrbitTime(82.42059f);
                KEPLER62F.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler62f.png"));
            }
            if ((KEPLER69B = GCRegisterUtilities.registerUnreachablePlanet("kepler69b", ExtraPlanets_SolarSystems.kepler69)) != null) {
                KEPLER69B.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(164.84119f);
                KEPLER69B.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler69b.png"));
            }
            if ((KEPLER69C = GCRegisterUtilities.registerUnreachablePlanet("kepler69c", ExtraPlanets_SolarSystems.kepler69)) != null) {
                KEPLER69C.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(6.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(164.84119f);
                KEPLER69C.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/kepler69c.png"));
            }
        }
        if (Config.CUSTOM_GALAXIES) {
            TATOOINE = GCRegisterUtilities.registerUnreachablePlanet("tatooine", ExtraPlanets_SolarSystems.epsilonSolaria);
            if (TATOOINE != null) {
                TATOOINE.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(0.75f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(20.605148f);
                TATOOINE.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/tatooine.png"));
            }
            if ((CRAIT = GCRegisterUtilities.registerUnreachablePlanet("crait", ExtraPlanets_SolarSystems.epsilonSolaria)) != null) {
                CRAIT.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(27.473532f);
                CRAIT.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/crait.png"));
            }
            if ((HOTH = GCRegisterUtilities.registerUnreachablePlanet("hoth", ExtraPlanets_SolarSystems.epsilonSolaria)) != null) {
                HOTH.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f)).setRelativeOrbitTime(41.210297f);
                HOTH.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/hoth.png"));
            }
            if ((AQUA = GCRegisterUtilities.registerUnreachablePlanet("aqua", ExtraPlanets_SolarSystems.epsilonSolaria)) != null) {
                AQUA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f)).setRelativeOrbitTime(82.42059f);
                AQUA.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/aqua.png"));
            }
            if ((QUSTROITHEA = GCRegisterUtilities.registerUnreachablePlanet("qustroithea", ExtraPlanets_SolarSystems.xenos157)) != null) {
                QUSTROITHEA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(20.605148f);
                QUSTROITHEA.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/qustroithea.png"));
            }
            if ((JETRARUTA = GCRegisterUtilities.registerUnreachablePlanet("jetraruta", ExtraPlanets_SolarSystems.xenos157)) != null) {
                JETRARUTA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(27.473532f);
                JETRARUTA.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/jetraruta.png"));
            }
            if ((MOSWION = GCRegisterUtilities.registerUnreachablePlanet("moswion", ExtraPlanets_SolarSystems.xenos157)) != null) {
                MOSWION.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(3.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(3.0f, 3.0f)).setRelativeOrbitTime(41.210297f);
                MOSWION.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/moswion.png"));
            }
            if ((KETHERTH = GCRegisterUtilities.registerUnreachablePlanet("ketherth", ExtraPlanets_SolarSystems.xenos157)) != null) {
                KETHERTH.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(4.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.0f, 4.0f)).setRelativeOrbitTime(82.42059f);
                KETHERTH.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/ketherth.png"));
            }
            if ((XOVIS = GCRegisterUtilities.registerUnreachablePlanet("xovis", ExtraPlanets_SolarSystems.xenos157)) != null) {
                XOVIS.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(4.5f, 4.5f)).setRelativeOrbitTime(164.84119f);
                XOVIS.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/xovis.png"));
            }
            if ((OARILIA = GCRegisterUtilities.registerUnreachablePlanet("oarilia", ExtraPlanets_SolarSystems.vendrizi161)) != null) {
                OARILIA.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(1.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(0.5f, 0.5f)).setRelativeOrbitTime(20.605148f);
                OARILIA.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/oarilia.png"));
            }
            if ((STRURONIDES = GCRegisterUtilities.registerUnreachablePlanet("struronides", ExtraPlanets_SolarSystems.vendrizi161)) != null) {
                STRURONIDES.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(2.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.0f, 1.0f)).setRelativeOrbitTime(27.473532f);
                STRURONIDES.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/struronides.png"));
            }
            if ((BRAJUTOV = GCRegisterUtilities.registerUnreachablePlanet("brajutov", ExtraPlanets_SolarSystems.vendrizi161)) != null) {
                BRAJUTOV.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(3.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.5f, 1.5f)).setRelativeOrbitTime(41.210297f);
                BRAJUTOV.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/brajutov.png"));
            }
            if ((SPESHANI16 = GCRegisterUtilities.registerUnreachablePlanet("speshani16", ExtraPlanets_SolarSystems.vendrizi161)) != null) {
                SPESHANI16.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(4.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.0f, 2.0f)).setRelativeOrbitTime(82.42059f);
                SPESHANI16.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/speshani16.png"));
            }
            if ((TRARS9 = GCRegisterUtilities.registerUnreachablePlanet("trars9", ExtraPlanets_SolarSystems.vendrizi161)) != null) {
                TRARS9.setRingColorRGB(0.1f, 0.9f, 0.6f).setPhaseShift(5.45f).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(2.5f, 2.5f)).setRelativeOrbitTime(164.84119f);
                TRARS9.setBodyIcon(new ResourceLocation("extraplanets:textures/gui/celestialbodies/trars9.png"));
            }
        }
    }

    private static void registerPlanets() {
        if (Config.MERCURY) {
            GalaxyRegistry.registerPlanet((Planet)MERCURY);
            GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new TeleportTypeMercury());
            GalacticraftRegistry.registerRocketGui(WorldProviderMercury.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/mercury_rocket_gui.png"));
        }
        if (Config.CERES) {
            GalaxyRegistry.registerPlanet((Planet)CERES);
            GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeCeres());
            GalacticraftRegistry.registerRocketGui(WorldProviderCeres.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/ceres_rocket_gui.png"));
        }
        if (Config.JUPITER) {
            GalaxyRegistry.registerPlanet((Planet)JUPITER);
            GalacticraftRegistry.registerTeleportType(WorldProviderJupiter.class, (ITeleportType)new TeleportTypeJupiter());
            GalacticraftRegistry.registerRocketGui(WorldProviderJupiter.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/jupiter_rocket_gui.png"));
        }
        if (Config.SATURN) {
            GalaxyRegistry.registerPlanet((Planet)SATURN);
            GalacticraftRegistry.registerTeleportType(WorldProviderSaturn.class, (ITeleportType)new TeleportTypeSaturn());
            GalacticraftRegistry.registerRocketGui(WorldProviderSaturn.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/saturn_rocket_gui.png"));
        }
        if (Config.URANUS) {
            GalaxyRegistry.registerPlanet((Planet)URANUS);
            GalacticraftRegistry.registerTeleportType(WorldProviderUranus.class, (ITeleportType)new TeleportTypeUranus());
            GalacticraftRegistry.registerRocketGui(WorldProviderUranus.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/uranus_rocket_gui.png"));
        }
        if (Config.NEPTUNE) {
            GalaxyRegistry.registerPlanet((Planet)NEPTUNE);
            GalacticraftRegistry.registerTeleportType(WorldProviderNeptune.class, (ITeleportType)new TeleportTypeNeptune());
            GalacticraftRegistry.registerRocketGui(WorldProviderNeptune.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/neptune_rocket_gui.png"));
        }
        if (Config.PLUTO) {
            GalaxyRegistry.registerPlanet((Planet)PLUTO);
            GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new TeleportTypePluto());
            GalacticraftRegistry.registerRocketGui(WorldProviderPluto.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/pluto_rocket_gui.png"));
        }
        if (Config.ERIS) {
            GalaxyRegistry.registerPlanet((Planet)ERIS);
            GalacticraftRegistry.registerTeleportType(WorldProviderEris.class, (ITeleportType)new TeleportTypeEris());
            GalacticraftRegistry.registerRocketGui(WorldProviderEris.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/eris_rocket_gui.png"));
        }
        if (Config.KEPLER22B && Config.KEPLER_SOLAR_SYSTEMS) {
            GalaxyRegistry.registerPlanet((Planet)KEPLER22B);
            GalacticraftRegistry.registerTeleportType(WorldProviderKepler22b.class, (ITeleportType)new TeleportTypeKepler22b());
            GalacticraftRegistry.registerRocketGui(WorldProviderKepler22b.class, (ResourceLocation)new ResourceLocation("extraplanets", "textures/gui/kepler22b_rocket_gui.png"));
        }
    }
}

