/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.network;

import com.mjr.extraplanets.ExtraPlanets;
import com.mjr.extraplanets.api.item.IModularArmor;
import com.mjr.extraplanets.api.prefabs.entity.EntityElectricRocketBase;
import com.mjr.extraplanets.api.prefabs.entity.EntityElectricSpaceshipBase;
import com.mjr.extraplanets.api.prefabs.entity.EntityPoweredVehicleBase;
import com.mjr.extraplanets.api.prefabs.entity.EntityVehicleBase;
import com.mjr.extraplanets.client.gui.GUIModuleManager;
import com.mjr.extraplanets.client.gui.vehicles.GuiPoweredVehicleBase;
import com.mjr.extraplanets.client.gui.vehicles.GuiVehicleBase;
import com.mjr.extraplanets.client.handlers.capabilities.CapabilityStatsClientHandler;
import com.mjr.extraplanets.client.handlers.capabilities.IStatsClientCapability;
import com.mjr.extraplanets.items.armor.modules.ExtraPlanets_Modules;
import com.mjr.extraplanets.items.armor.modules.Module;
import com.mjr.extraplanets.items.armor.modules.ModuleHelper;
import com.mjr.extraplanets.util.ExtraPlanetsUtli;
import com.mjr.mjrlegendslib.network.PacketSimpleBase;
import com.mjr.mjrlegendslib.util.MCUtilities;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSimpleEP
extends PacketSimpleBase {
    private EnumSimplePacket type;
    private List<Object> data;
    private static String spamCheckString;

    public PacketSimpleEP() {
    }

    public PacketSimpleEP(EnumSimplePacket packetType, int dimID, Object[] data) {
        this(packetType, dimID, Arrays.asList(data));
    }

    public PacketSimpleEP(EnumSimplePacket packetType, int dimID, List<Object> data) {
        super(dimID);
        if (packetType.getDecodeClasses().length != data.size()) {
            MessageUtilities.fatalErrorMessageToLog((String)"extraplanets", (String)"Simple Packet Core found data length different than packet type");
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ByteBuf buffer) {
        super.encodeInto(buffer);
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ByteBuf buffer) {
        super.decodeInto(buffer);
        this.type = EnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                MessageUtilities.fatalErrorMessageToLog((String)"extraplanets", (String)("Packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            MessageUtilities.fatalErrorMessageToLog((String)"extraplanets", (String)("Error handling simple packet type: " + this.type.toString() + " " + buffer.toString()));
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityPlayerSP playerBaseClient = null;
        IStatsClientCapability stats = null;
        if (player instanceof EntityPlayerSP) {
            playerBaseClient = (EntityPlayerSP)player;
            stats = (IStatsClientCapability)playerBaseClient.getCapability(CapabilityStatsClientHandler.EP_STATS_CLIENT_CAPABILITY, null);
        }
        switch (this.type) {
            case C_OPEN_PARACHEST_GUI: {
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        if (playerBaseClient.func_184187_bx() instanceof EntityVehicleBase) {
                            MCUtilities.getClient().func_147108_a((GuiScreen)new GuiVehicleBase((IInventory)playerBaseClient.field_71071_by, (IInventory)((EntityVehicleBase)playerBaseClient.func_184187_bx()), ((EntityVehicleBase)playerBaseClient.func_184187_bx()).getType()));
                            playerBaseClient.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                            break;
                        }
                        if (!(playerBaseClient.func_184187_bx() instanceof EntityPoweredVehicleBase)) break;
                        MCUtilities.getClient().func_147108_a((GuiScreen)new GuiPoweredVehicleBase((IInventory)playerBaseClient.field_71071_by, (IInventory)((EntityPoweredVehicleBase)playerBaseClient.func_184187_bx()), ((EntityPoweredVehicleBase)playerBaseClient.func_184187_bx()).getType()));
                        playerBaseClient.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
            case C_UPDATE_SOLAR_RADIATION_LEVEL: {
                stats.setRadiationLevel((Double)this.data.get(0));
                break;
            }
            case C_DISPLAY_ROCKET_CONTROLS: {
                PlayerUtilties.sendMessage((EntityPlayer)playerBaseClient, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.spaceKey.func_151463_i()) + "  - " + GCCoreUtil.translate((String)"gui.rocket.launch.name")));
                PlayerUtilties.sendMessage((EntityPlayer)playerBaseClient, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.leftKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.rightKey.func_151463_i()) + "  - " + GCCoreUtil.translate((String)"gui.rocket.turn.name")));
                PlayerUtilties.sendMessage((EntityPlayer)playerBaseClient, (String)(GameSettings.func_74298_c((int)KeyHandlerClient.accelerateKey.func_151463_i()) + " / " + GameSettings.func_74298_c((int)KeyHandlerClient.decelerateKey.func_151463_i()) + "  - " + GCCoreUtil.translate((String)"gui.rocket.updown.name")));
                PlayerUtilties.sendMessage((EntityPlayer)playerBaseClient, (String)(GameSettings.func_74298_c((int)com.mjr.extraplanets.client.handlers.KeyHandlerClient.openPowerGUI.func_151463_i()) + "       - " + GCCoreUtil.translate((String)"gui.powered.inv.name")));
                break;
            }
            case C_OPEN_MODULE_MANANGER_GUI: {
                switch ((Integer)this.data.get(1)) {
                    case 0: {
                        MCUtilities.getClient().func_147108_a((GuiScreen)new GUIModuleManager((IInventory)playerBaseClient.field_71071_by));
                        playerBaseClient.field_71070_bA.field_75152_c = (Integer)this.data.get(0);
                    }
                }
                break;
            }
            case C_MOVE_PLAYER: {
                BlockPos pos = (BlockPos)this.data.get(0);
                playerBaseClient.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((Entity)playerBase);
        switch (this.type) {
            case S_OPEN_FUEL_GUI: {
                if (!(playerBase.func_184187_bx() instanceof EntityVehicleBase)) break;
                ExtraPlanetsUtli.openFuelVehicleInv(playerBase, (IInventory)((EntityVehicleBase)playerBase.func_184187_bx()), ((EntityVehicleBase)playerBase.func_184187_bx()).getType());
                break;
            }
            case S_OPEN_POWER_GUI: {
                if (playerBase.func_184187_bx() instanceof EntityPoweredVehicleBase) {
                    ExtraPlanetsUtli.openPowerVehicleInv(playerBase, (IInventory)((EntityPoweredVehicleBase)playerBase.func_184187_bx()), ((EntityPoweredVehicleBase)playerBase.func_184187_bx()).getType());
                    break;
                }
                if (!(playerBase.func_184187_bx() instanceof EntityElectricRocketBase)) break;
                playerBase.openGui((Object)ExtraPlanets.instance, 4, playerBase.field_70170_p, (int)playerBase.field_70165_t, (int)playerBase.field_70163_u, (int)playerBase.field_70161_v);
                break;
            }
            case S_IGNITE_ROCKET: {
                if (playerBase.field_70170_p.field_72995_K || playerBase.field_70128_L || playerBase.func_184187_bx() == null || playerBase.func_184187_bx().field_70128_L || !(playerBase.func_184187_bx() instanceof EntityElectricRocketBase)) break;
                EntityElectricRocketBase ship = (EntityElectricRocketBase)playerBase.func_184187_bx();
                if (ship.launchPhase == EntityElectricSpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) break;
                if (ship.hasValidPower()) {
                    ItemStack stack2 = GCPlayerStats.get((Entity)playerBase).getExtendedInventory().func_70301_a(4);
                    if (stack2 != null && stack2.func_77973_b() instanceof ItemParaChute || stats.getLaunchAttempts() > 0) {
                        ship.igniteCheckingCooldown();
                        GCPlayerStats.get((Entity)playerBase).setLaunchAttempts(0);
                        break;
                    }
                    if (stats.getChatCooldown() != 0 || GCPlayerStats.get((Entity)playerBase).getLaunchAttempts() != 0) break;
                    PlayerUtilties.sendMessage((EntityPlayer)playerBase, (String)TranslateUtilities.translate((String)"gui.rocket.warning.noparachute"));
                    stats.setChatCooldown(250);
                    GCPlayerStats.get((Entity)playerBase).setLaunchAttempts(1);
                    break;
                }
                if (stats.getChatCooldown() != 0) break;
                PlayerUtilties.sendMessage((EntityPlayer)playerBase, (String)TranslateUtilities.translate((String)"gui.rocket.warning.nofuel"));
                stats.setChatCooldown(250);
                break;
            }
            case S_UPDATE_JETPACK: {
                if ((Integer)this.data.get(0) == 1) {
                    ItemStack jetpack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(2);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74757_a("active", true);
                    jetpack.func_77982_d(tag);
                    break;
                }
                if ((Integer)this.data.get(0) != 0) break;
                ItemStack jetpack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(2);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74757_a("active", false);
                jetpack.func_77982_d(tag);
                break;
            }
            case S_OPEN_MODULE_MANANGER_GUI: {
                ExtraPlanetsUtli.openModuleManagerGUI(playerBase);
                break;
            }
            case S_UNINSTALL_MODULE: {
                Module uninstallModule = null;
                for (Module temp : ExtraPlanets_Modules.getModules()) {
                    if (!temp.getName().equalsIgnoreCase((String)this.data.get(0))) continue;
                    uninstallModule = temp;
                }
                if (uninstallModule == null) break;
                ItemStack stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(3);
                if (stack.func_77973_b() instanceof IModularArmor && ModuleHelper.checkModuleCompact(stack, uninstallModule)) {
                    ModuleHelper.uninstallModule(stack, uninstallModule, (EntityPlayer)playerBase);
                }
                if ((stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(2)).func_77973_b() instanceof IModularArmor && ModuleHelper.checkModuleCompact(stack, uninstallModule)) {
                    ModuleHelper.uninstallModule(stack, uninstallModule, (EntityPlayer)playerBase);
                }
                if ((stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(1)).func_77973_b() instanceof IModularArmor && ModuleHelper.checkModuleCompact(stack, uninstallModule)) {
                    ModuleHelper.uninstallModule(stack, uninstallModule, (EntityPlayer)playerBase);
                }
                if (!((stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(0)).func_77973_b() instanceof IModularArmor) || !ModuleHelper.checkModuleCompact(stack, uninstallModule)) break;
                ModuleHelper.uninstallModule(stack, uninstallModule, (EntityPlayer)playerBase);
                break;
            }
            case S_INSTALL_MODULE: {
                Module installModule = null;
                for (Module temp : ExtraPlanets_Modules.getModules()) {
                    if (!temp.getName().equalsIgnoreCase((String)this.data.get(0))) continue;
                    installModule = temp;
                }
                if (installModule == null) break;
                boolean missingArmour = true;
                boolean meetRequirements = true;
                boolean alreadyHas = false;
                ItemStack stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(3);
                if (ModuleHelper.checkModuleCompact(stack, installModule)) {
                    if (stack.func_77973_b() instanceof IModularArmor) {
                        missingArmour = false;
                        if (!ModuleHelper.hasModule(stack, installModule)) {
                            if (playerBase.field_71075_bZ.field_75098_d) {
                                ModuleHelper.addModule(stack, installModule);
                            } else {
                                meetRequirements = ModuleHelper.installModule(stack, installModule, (EntityPlayer)playerBase);
                            }
                        } else {
                            alreadyHas = true;
                        }
                    } else {
                        meetRequirements = false;
                    }
                }
                if (ModuleHelper.checkModuleCompact(stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(2), installModule)) {
                    if (stack.func_77973_b() instanceof IModularArmor) {
                        missingArmour = false;
                        if (!ModuleHelper.hasModule(stack, installModule)) {
                            if (playerBase.field_71075_bZ.field_75098_d) {
                                ModuleHelper.addModule(stack, installModule);
                            } else {
                                meetRequirements = ModuleHelper.installModule(stack, installModule, (EntityPlayer)playerBase);
                            }
                        } else {
                            alreadyHas = true;
                        }
                    } else {
                        meetRequirements = false;
                    }
                }
                if (ModuleHelper.checkModuleCompact(stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(1), installModule)) {
                    if (stack.func_77973_b() instanceof IModularArmor) {
                        missingArmour = false;
                        if (!ModuleHelper.hasModule(stack, installModule)) {
                            if (playerBase.field_71075_bZ.field_75098_d) {
                                ModuleHelper.addModule(stack, installModule);
                            } else {
                                meetRequirements = ModuleHelper.installModule(stack, installModule, (EntityPlayer)playerBase);
                            }
                        } else {
                            alreadyHas = true;
                        }
                    } else {
                        meetRequirements = false;
                    }
                }
                if (ModuleHelper.checkModuleCompact(stack = (ItemStack)playerBase.field_71071_by.field_70460_b.get(0), installModule)) {
                    if (stack.func_77973_b() instanceof IModularArmor) {
                        missingArmour = false;
                        if (!ModuleHelper.hasModule(stack, installModule)) {
                            if (playerBase.field_71075_bZ.field_75098_d) {
                                ModuleHelper.addModule(stack, installModule);
                            } else {
                                meetRequirements = ModuleHelper.installModule(stack, installModule, (EntityPlayer)playerBase);
                            }
                        } else {
                            alreadyHas = true;
                        }
                    } else {
                        meetRequirements = false;
                    }
                }
                if (missingArmour) {
                    PlayerUtilties.sendMessage((EntityPlayer)playerBase, (String)TranslateUtilities.translate((String)"gui.module.missing_armour.name"));
                    break;
                }
                if (!meetRequirements && !alreadyHas) {
                    PlayerUtilties.sendMessage((EntityPlayer)playerBase, (String)TranslateUtilities.translate((String)"gui.module.missing_requirements.name"));
                    break;
                }
                if (alreadyHas) {
                    PlayerUtilties.sendMessage((EntityPlayer)playerBase, (String)TranslateUtilities.translate((String)"gui.module.already_installed.name"));
                    break;
                }
                PlayerUtilties.sendMessage((EntityPlayer)playerBase, (String)TranslateUtilities.translate((String)"gui.module.installed.name"));
                break;
            }
            case S_UPDATE_MODULE_STATE: {
                Module installModule2 = null;
                for (Module temp : ExtraPlanets_Modules.getModules()) {
                    if (!temp.getName().equalsIgnoreCase((String)this.data.get(0))) continue;
                    installModule2 = temp;
                }
                if (installModule2 == null) break;
                ItemStack temp = (ItemStack)playerBase.field_71071_by.field_70460_b.get(installModule2.getSlotType());
                ModuleHelper.updateModuleActiveState(temp, installModule2, !installModule2.isActive());
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (MCUtilities.isClient()) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum EnumSimplePacket {
        S_OPEN_FUEL_GUI(Side.SERVER, String.class),
        S_OPEN_POWER_GUI(Side.SERVER, String.class),
        S_IGNITE_ROCKET(Side.SERVER, new Class[0]),
        S_UPDATE_JETPACK(Side.SERVER, Integer.class),
        S_OPEN_MODULE_MANANGER_GUI(Side.SERVER, String.class),
        S_UNINSTALL_MODULE(Side.SERVER, String.class),
        S_INSTALL_MODULE(Side.SERVER, String.class),
        S_UPDATE_MODULE_STATE(Side.SERVER, String.class),
        C_DISPLAY_ROCKET_CONTROLS(Side.CLIENT, new Class[0]),
        C_OPEN_PARACHEST_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_UPDATE_SOLAR_RADIATION_LEVEL(Side.CLIENT, Double.class),
        C_OPEN_MODULE_MANANGER_GUI(Side.CLIENT, Integer.class, Integer.class, Integer.class),
        C_MOVE_PLAYER(Side.CLIENT, BlockPos.class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private EnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

