/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation;

import com.creativemd.littletiles.common.utils.animation.Animation;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.transformation.OffsetTransformation;

public class OffsetAnimation
extends Animation {
    public final double startX;
    public final double startY;
    public final double startZ;
    public final double endX;
    public final double endY;
    public final double endZ;

    public OffsetAnimation(long duration, double startX, double startY, double startZ, double endX, double endY, double endZ) {
        super(duration);
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.endX = endX;
        this.endY = endY;
        this.endZ = endZ;
    }

    public OffsetAnimation(long duration, OffsetTransformation start, double endX, double endY, double endZ) {
        this(duration, start.x, start.y, start.z, endX, endY, endZ);
    }

    public OffsetAnimation(int[] array) {
        super((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL);
        this.startX = Double.longBitsToDouble((long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
        this.startY = Double.longBitsToDouble((long)array[4] << 32 | (long)array[5] & 0xFFFFFFFFL);
        this.startZ = Double.longBitsToDouble((long)array[6] << 32 | (long)array[7] & 0xFFFFFFFFL);
        this.endX = Double.longBitsToDouble((long)array[8] << 32 | (long)array[9] & 0xFFFFFFFFL);
        this.endY = Double.longBitsToDouble((long)array[10] << 32 | (long)array[11] & 0xFFFFFFFFL);
        this.endZ = Double.longBitsToDouble((long)array[12] << 32 | (long)array[13] & 0xFFFFFFFFL);
    }

    @Override
    public void tick(AnimationState state) {
        if (state.offset == null) {
            return;
        }
        state.offset.x = this.startX + (this.endX - this.startX) / (double)this.duration * (double)this.tick;
        state.offset.y = this.startY + (this.endY - this.startY) / (double)this.duration * (double)this.tick;
        state.offset.z = this.startZ + (this.endZ - this.startZ) / (double)this.duration * (double)this.tick;
    }

    @Override
    public void end(AnimationState state) {
        if (state.offset == null) {
            return;
        }
        state.offset.x = this.endX;
        state.offset.y = this.endY;
        state.offset.z = this.endZ;
    }

    public int[] getArray() {
        long startX = Double.doubleToLongBits(this.startX);
        long startY = Double.doubleToLongBits(this.startY);
        long startZ = Double.doubleToLongBits(this.startZ);
        long endX = Double.doubleToLongBits(this.endX);
        long endY = Double.doubleToLongBits(this.endY);
        long endZ = Double.doubleToLongBits(this.endZ);
        return new int[]{(int)(this.duration >> 32), (int)this.duration, (int)(startX >> 32), (int)startX, (int)(startY >> 32), (int)startY, (int)(startZ >> 32), (int)startZ, (int)(endX >> 32), (int)endX, (int)(endY >> 32), (int)endY, (int)(endZ >> 32), (int)endZ};
    }
}

