/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.LittleStructureParser;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiStructure
extends SubGui {
    public ItemStack stack;
    public LittleStructure structure;
    public Object lastListener = null;

    public SubGuiStructure(ItemStack stack) {
        this.stack = stack;
    }

    public void createControls() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("none");
        lines.addAll(LittleStructure.getStructureTypeNames());
        this.controls.add(new GuiLabel("type:", 2, 7));
        GuiComboBox comboBox = new GuiComboBox("types", 32, 5, 70, lines);
        LittleStructure structure = ItemMultiTiles.getLTStructure((ItemStack)this.stack);
        if (structure != null) {
            this.structure = structure;
            comboBox.index = lines.indexOf(structure.getIDOfStructure());
            if (comboBox.index == -1) {
                comboBox.index = 0;
            } else {
                comboBox.caption = structure.getIDOfStructure();
            }
        }
        this.controls.add(comboBox);
        this.controls.add(new GuiButton("save", 115, 140, 50){

            public void onClicked(int x, int y, int button) {
                String id = ((GuiComboBox)SubGuiStructure.this.get((String)"types")).caption;
                Class<? extends LittleStructureParser> parser = null;
                LittleStructure.LittleStructureEntry entry = LittleStructure.getStructureEntryByID((String)id);
                if (entry != null) {
                    parser = entry.parser;
                }
                if (parser != null) {
                    LittleStructure structure = parser.parseStructure((SubGui)this.getParent());
                    if (structure != null) {
                        NBTTagCompound structureNBT = new NBTTagCompound();
                        structure.writeToNBT(structureNBT);
                        SubGuiStructure.this.stack.func_77978_p().func_74782_a("structure", (NBTBase)structureNBT);
                    } else {
                        SubGuiStructure.this.stack.func_77978_p().func_82580_o("structure");
                    }
                } else {
                    SubGuiStructure.this.stack.func_77978_p().func_82580_o("structure");
                }
                SubGuiStructure.this.sendPacketToServer(SubGuiStructure.this.stack.func_77978_p());
                SubGuiStructure.this.closeGui();
            }
        });
        this.onChanged();
    }

    public void onChanged() {
        LittleStructure saved;
        this.removeControls(new String[]{"type:", "types", "save"});
        String id = ((GuiComboBox)this.get((String)"types")).caption;
        if (this.lastListener != null) {
            this.removeListener(this.lastListener);
        }
        if ((saved = this.structure) != null && !saved.getIDOfStructure().equals(id)) {
            saved = null;
        }
        Class<? extends LittleStructureParser> parser = null;
        LittleStructure.LittleStructureEntry entry = LittleStructure.getStructureEntryByID((String)id);
        if (entry != null) {
            parser = entry.parser;
        }
        if (parser != null) {
            parser.createControls(this, saved);
            this.refreshControls();
            this.addListener(parser);
            this.lastListener = parser;
        }
    }

    @CustomEventSubscribe
    public void onComboChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"types"})) {
            this.onChanged();
        }
    }
}

