/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity.old;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.BoxPlane;
import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.CollidingPlane;
import com.creativemd.creativecore.common.utils.math.box.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.utils.math.vec.MatrixUtils;
import com.creativemd.creativecore.common.utils.math.vec.VecOrigin;
import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorld;
import com.creativemd.creativecore.common.world.SubWorld;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.client.render.entity.LittleRenderChunk;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.entity.AABBCombiner;
import com.creativemd.littletiles.common.events.LittleDoorHandler;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.google.common.base.Predicate;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Deprecated
public abstract class EntityOldAnimation
extends Entity {
    protected static Predicate<Entity> NO_ANIMATION = new Predicate<Entity>(){

        public boolean apply(Entity input) {
            return !(input instanceof EntityOldAnimation);
        }
    };
    protected LittleTilePos center;
    protected LittleTileVecContext inBlockCenter;
    protected BlockPos baseOffset;
    protected BlockPos chunkOffset;
    protected BlockPos inChunkOffset;
    protected LittleTileVec additionalAxis;
    public Vector3d rotationCenter;
    public Vector3d rotationCenterInsideBlock;
    public CreativeWorld fakeWorld;
    public VecOrigin origin;
    public LittleAbsolutePreviewsStructure previews;
    public ArrayList<TileEntityLittleTiles> blocks;
    public double prevWorldRotX = 0.0;
    public double prevWorldRotY = 0.0;
    public double prevWorldRotZ = 0.0;
    public double worldRotX = 0.0;
    public double worldRotY = 0.0;
    public double worldRotZ = 0.0;
    public boolean preventPush = false;
    public boolean noCollision = false;
    public AABBCombiner collisionBoxWorker;
    public List<OrientatedBoundingBox> worldCollisionBoxes;
    public OrientatedBoundingBox worldBoundingBox;
    @SideOnly(value=Side.CLIENT)
    public LinkedHashMap<BlockPos, LittleRenderChunk> renderChunks;
    @SideOnly(value=Side.CLIENT)
    public ArrayList<TileEntityLittleTiles> renderQueue;
    @SideOnly(value=Side.CLIENT)
    public boolean spawnedInWorld;
    public boolean addedDoor = false;

    public static int intFloorDiv(int p_76137_0_, int p_76137_1_) {
        return p_76137_0_ < 0 ? -((-p_76137_0_ - 1) / p_76137_1_) - 1 : p_76137_0_ / p_76137_1_;
    }

    public void setCenterVec(LittleTilePos axis, LittleTileVec additional) {
        axis.removeInternalBlockOffset();
        this.center = axis;
        this.baseOffset = axis.pos;
        this.inBlockCenter = axis.contextVec;
        this.chunkOffset = EntityOldAnimation.getRenderChunkPos(this.baseOffset);
        int chunkX = EntityOldAnimation.intFloorDiv(this.baseOffset.func_177958_n(), 16);
        int chunkY = EntityOldAnimation.intFloorDiv(this.baseOffset.func_177956_o(), 16);
        int chunkZ = EntityOldAnimation.intFloorDiv(this.baseOffset.func_177952_p(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.func_177958_n() - chunkX * 16, this.baseOffset.func_177956_o() - chunkY * 16, this.baseOffset.func_177952_p() - chunkZ * 16);
        this.additionalAxis = additional;
        this.rotationCenter = new Vector3d(axis.getPosX() + this.additionalAxis.getPosX(axis.getContext()) / 2.0, axis.getPosY() + this.additionalAxis.getPosY(axis.getContext()) / 2.0, axis.getPosZ() + this.additionalAxis.getPosZ(axis.getContext()) / 2.0);
        this.rotationCenterInsideBlock = new Vector3d(this.inBlockCenter.getPosX() + this.additionalAxis.getPosX(this.inBlockCenter.context) / 2.0, this.inBlockCenter.getPosY() + this.additionalAxis.getPosY(this.inBlockCenter.context) / 2.0, this.inBlockCenter.getPosZ() + this.additionalAxis.getPosZ(this.inBlockCenter.context) / 2.0);
        this.origin = new VecOrigin(this.rotationCenter);
        this.fakeWorld.setOrigin((IVecOrigin)this.origin);
    }

    public static BlockPos getRenderChunkPos(BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n() >> 4, blockPos.func_177956_o() >> 4, blockPos.func_177952_p() >> 4);
    }

    public LittleTilePos getCenter() {
        return this.center;
    }

    public LittleTileVecContext getInsideBlockCenter() {
        return this.inBlockCenter;
    }

    public BlockPos getAxisPos() {
        return this.baseOffset;
    }

    public BlockPos getAxisChunkPos() {
        return this.chunkOffset;
    }

    public BlockPos getInsideChunkPos() {
        return this.inChunkOffset;
    }

    public Vec3d getRotVector(float partialTicks) {
        return new Vec3d(this.prevWorldRotX + (this.worldRotX - this.prevWorldRotX) * (double)partialTicks, this.prevWorldRotY + (this.worldRotY - this.prevWorldRotY) * (double)partialTicks, this.prevWorldRotZ + (this.worldRotZ - this.prevWorldRotZ) * (double)partialTicks);
    }

    public void updateWorldCollision() {
        double minX = 2.147483647E9;
        double minY = 2.147483647E9;
        double minZ = 2.147483647E9;
        double maxX = -2.147483648E9;
        double maxY = -2.147483648E9;
        double maxZ = -2.147483648E9;
        this.worldCollisionBoxes = new ArrayList<OrientatedBoundingBox>();
        for (TileEntityLittleTiles te : this.blocks) {
            this.onScanningTE(te);
            AxisAlignedBB bb = te.getSelectionBox();
            minX = Math.min(minX, bb.field_72340_a);
            minY = Math.min(minY, bb.field_72338_b);
            minZ = Math.min(minZ, bb.field_72339_c);
            maxX = Math.max(maxX, bb.field_72336_d);
            maxY = Math.max(maxY, bb.field_72337_e);
            maxZ = Math.max(maxZ, bb.field_72334_f);
            ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
            for (LittleTile tile : te.getTiles()) {
                List<LittleTileBox> tileBoxes = tile.getCollisionBoxes();
                for (LittleTileBox box : tileBoxes) {
                    boxes.add(box.getBox(te.getContext(), te.func_174877_v()));
                }
            }
            for (AxisAlignedBB box : boxes) {
                this.worldCollisionBoxes.add(new OrientatedBoundingBox((IVecOrigin)this.origin, box));
            }
        }
        this.collisionBoxWorker = new AABBCombiner(this.worldCollisionBoxes, 0.0);
        this.worldBoundingBox = new OrientatedBoundingBox((IVecOrigin)this.origin, minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static double minIgnore(double par1, double par2) {
        if (Math.abs(par2) < Math.abs(par1)) {
            return par2;
        }
        return par1;
    }

    private static double maxIgnore(double par1, double par2) {
        if (Math.abs(par2) > Math.abs(par1)) {
            return par2;
        }
        return par1;
    }

    public double getRot(EnumFacing.Axis axis) {
        switch (axis) {
            case X: {
                return this.worldRotX;
            }
            case Y: {
                return this.worldRotY;
            }
            case Z: {
                return this.worldRotZ;
            }
        }
        return 0.0;
    }

    public void rotXTo(double x) {
        this.rotateAnimation(x - this.worldRotX, 0.0, 0.0);
    }

    public void rotYTo(double y) {
        this.rotateAnimation(0.0, y - this.worldRotY, 0.0);
    }

    public void rotZTo(double z) {
        this.rotateAnimation(0.0, 0.0, z - this.worldRotZ);
    }

    public void rotateAnimation(double rotX, double rotY, double rotZ) {
        this.moveAndRotateAnimation(0.0, 0.0, 0.0, rotX, rotY, rotZ);
    }

    public void moveAndRotateAnimation(double x, double y, double z, double rotX, double rotY, double rotZ) {
        boolean moved = false;
        if (!this.preventPush) {
            Vector3d translation;
            Matrix3d rotationX = rotX != 0.0 ? MatrixUtils.createRotationMatrixX((double)rotX) : null;
            Matrix3d rotationY = rotY != 0.0 ? MatrixUtils.createRotationMatrixY((double)rotY) : null;
            Matrix3d rotationZ = rotZ != 0.0 ? MatrixUtils.createRotationMatrixZ((double)rotZ) : null;
            Object object = translation = x != 0.0 || y != 0.0 || z != 0.0 ? new Vector3d(x, y, z) : null;
            if (rotationX != null || rotationY != null || rotationZ != null || translation != null) {
                AxisAlignedBB moveBB = BoxUtils.getRotatedSurrounding((AxisAlignedBB)this.worldBoundingBox, (Vector3d)this.rotationCenter, (Matrix3d)this.origin.rotation(), (Vector3d)this.origin.translation(), (Matrix3d)rotationX, (double)rotX, (Matrix3d)rotationY, (double)rotY, (Matrix3d)rotationZ, (double)rotZ, (Vector3d)translation);
                this.noCollision = true;
                List entities = this.field_70170_p.func_175647_a(Entity.class, moveBB, NO_ANIMATION);
                if (!entities.isEmpty()) {
                    Entity entity;
                    ArrayList<AxisAlignedBB> surroundingBoxes = new ArrayList<AxisAlignedBB>(this.worldCollisionBoxes.size());
                    for (OrientatedBoundingBox box : this.worldCollisionBoxes) {
                        if (box.cache == null) {
                            box.buildCache();
                        }
                        box.cache.reset();
                        surroundingBoxes.add(BoxUtils.getRotatedSurrounding((AxisAlignedBB)box, (Vector3d)this.rotationCenter, (Matrix3d)this.origin.rotation(), (Vector3d)this.origin.translation(), (Matrix3d)rotationX, (double)rotX, (Matrix3d)rotationY, (double)rotY, (Matrix3d)rotationZ, (double)rotZ, (Vector3d)translation));
                    }
                    MatrixUtils.MatrixLookupTable table = new MatrixUtils.MatrixLookupTable(x, y, z, rotX, rotY, rotZ, this.rotationCenter, (IVecOrigin)this.origin);
                    CollidingPlane.PushCache[] caches = new CollidingPlane.PushCache[entities.size()];
                    for (int j = 0; j < entities.size(); ++j) {
                        entity = (Entity)entities.get(j);
                        AxisAlignedBB entityBox = entity.func_174813_aQ();
                        Vector3d center = new Vector3d(entityBox.field_72340_a + (entityBox.field_72336_d - entityBox.field_72340_a) * 0.5, entityBox.field_72338_b + (entityBox.field_72337_e - entityBox.field_72338_b) * 0.5, entityBox.field_72339_c + (entityBox.field_72334_f - entityBox.field_72339_c) * 0.5);
                        Vector3d temp = new Vector3d(entityBox.field_72340_a, entityBox.field_72338_b, entityBox.field_72339_c);
                        temp.sub((Tuple3d)center);
                        double radius = temp.lengthSquared();
                        this.origin.transformPointToFakeWorld(center);
                        Double t = null;
                        OrientatedBoundingBox pushingBox = null;
                        EnumFacing facing = null;
                        block2: for (int i = 0; i < surroundingBoxes.size(); ++i) {
                            if (!((AxisAlignedBB)surroundingBoxes.get(i)).func_72326_a(entityBox)) continue;
                            OrientatedBoundingBox box = this.worldCollisionBoxes.get(i);
                            if (!box.cache.isCached()) {
                                box.cache.planes = CollidingPlane.getPlanes((CreativeAxisAlignedBB)box, (CollidingPlane.PlaneCache)box.cache, (MatrixUtils.MatrixLookupTable)table);
                            }
                            for (CollidingPlane plane : box.cache.planes) {
                                Double tempT = plane.binarySearch(t, entityBox, radius, center, table);
                                if (tempT == null) continue;
                                t = tempT;
                                pushingBox = box;
                                facing = plane.facing;
                                if (t == 0.0) break block2;
                            }
                        }
                        if (t == null) continue;
                        CollidingPlane.PushCache cache = new CollidingPlane.PushCache();
                        cache.facing = facing;
                        Vector3d newCenter = new Vector3d(center);
                        table.transform(newCenter, Double.valueOf(1.0 - t));
                        this.origin.transformPointToWorld(center);
                        this.origin.transformPointToWorld(newCenter);
                        cache.pushBox = pushingBox;
                        cache.entityBox = entityBox.func_72317_d(newCenter.x - center.x, newCenter.y - center.y, newCenter.z - center.z);
                        caches[j] = cache;
                    }
                    this.field_70165_t += x;
                    this.field_70163_u += y;
                    this.field_70161_v += z;
                    this.worldRotX += rotX;
                    this.worldRotY += rotY;
                    this.worldRotZ += rotZ;
                    this.updateOrigin();
                    moved = true;
                    for (int i = 0; i < entities.size(); ++i) {
                        boolean cached;
                        entity = (Entity)entities.get(i);
                        CollidingPlane.PushCache cache = caches[i];
                        boolean bl = cached = cache != null;
                        if (!cached) {
                            cache = new CollidingPlane.PushCache();
                            cache.entityBox = entity.func_174813_aQ();
                        }
                        Vector3d[] corners = BoxUtils.getCorners((AxisAlignedBB)cache.entityBox);
                        double minX = Double.MAX_VALUE;
                        double minY = Double.MAX_VALUE;
                        double minZ = Double.MAX_VALUE;
                        double maxX = -1.7976931348623157E308;
                        double maxY = -1.7976931348623157E308;
                        double maxZ = -1.7976931348623157E308;
                        for (int h = 0; h < corners.length; ++h) {
                            Vector3d vec = corners[h];
                            vec.sub((Tuple3d)this.origin.translation());
                            vec.sub((Tuple3d)this.rotationCenter);
                            this.origin.rotationInv().transform((Tuple3d)vec);
                            vec.add((Tuple3d)this.rotationCenter);
                            minX = Math.min(minX, vec.x);
                            minY = Math.min(minY, vec.y);
                            minZ = Math.min(minZ, vec.z);
                            maxX = Math.max(maxX, vec.x);
                            maxY = Math.max(maxY, vec.y);
                            maxZ = Math.max(maxZ, vec.z);
                        }
                        OrientatedBoundingBox fakeBox = new OrientatedBoundingBox((IVecOrigin)this.origin, minX, minY, minZ, maxX, maxY, maxZ);
                        Vector3d center = fakeBox.getCenter3d();
                        EnumFacing.Axis one = cached ? RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)cache.facing.func_176740_k()) : null;
                        EnumFacing.Axis two = cached ? RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)cache.facing.func_176740_k()) : null;
                        boolean ignoreOne = false;
                        Boolean positiveOne = null;
                        boolean ignoreTwo = false;
                        Boolean positiveTwo = null;
                        double maxVolume = 0.0;
                        ArrayList<OrientatedBoundingBox> intersecting = new ArrayList<OrientatedBoundingBox>();
                        ArrayList<EnumFacing> intersectingFacing = new ArrayList<EnumFacing>();
                        if (cached) {
                            intersecting.add(cache.pushBox);
                            intersectingFacing.add(cache.facing);
                        }
                        for (OrientatedBoundingBox box : this.worldCollisionBoxes) {
                            boolean add;
                            if (cached && box == cache.pushBox || !box.func_72326_a((AxisAlignedBB)fakeBox)) continue;
                            if (!box.cache.isCached()) {
                                box.cache.planes = CollidingPlane.getPlanes((CreativeAxisAlignedBB)box, (CollidingPlane.PlaneCache)box.cache, (MatrixUtils.MatrixLookupTable)table);
                            }
                            boolean bl2 = add = !cached;
                            EnumFacing facing = CollidingPlane.getDirection((OrientatedBoundingBox)box, (CollidingPlane[])box.cache.planes, (Vector3d)center);
                            if (facing == null || !table.hasOneRotation && RotationUtils.get((EnumFacing.Axis)facing.func_176740_k(), (Tuple3d)translation) == 0.0) continue;
                            if (cached) {
                                if (facing == cache.facing) {
                                    add = true;
                                } else if (!ignoreOne && facing.func_176740_k() == one) {
                                    add = true;
                                    if (positiveOne == null) {
                                        positiveOne = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                                    } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveOne) {
                                        ignoreOne = true;
                                        add = false;
                                    }
                                } else if (!ignoreTwo && facing.func_176740_k() == two) {
                                    add = true;
                                    if (positiveTwo == null) {
                                        positiveTwo = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                                    } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveTwo) {
                                        ignoreTwo = true;
                                        add = false;
                                    }
                                }
                            }
                            if (!add) continue;
                            double intersectingVolume = box.getIntersectionVolume((AxisAlignedBB)fakeBox);
                            if (intersectingVolume > maxVolume) {
                                cache.pushBox = box;
                                maxVolume = intersectingVolume;
                                cache.facing = facing;
                            }
                            intersecting.add(box);
                            intersectingFacing.add(facing);
                        }
                        if (intersecting.isEmpty()) continue;
                        if (!cached) {
                            one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)cache.facing.func_176740_k());
                            two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)cache.facing.func_176740_k());
                            positiveOne = null;
                            positiveTwo = null;
                            for (EnumFacing facing : intersectingFacing) {
                                if (!ignoreOne && facing.func_176740_k() == one) {
                                    if (positiveOne == null) {
                                        positiveOne = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                                    } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveOne) {
                                        ignoreOne = true;
                                    }
                                } else if (!ignoreTwo && facing.func_176740_k() == two) {
                                    if (positiveTwo == null) {
                                        positiveTwo = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
                                    } else if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE != positiveTwo) {
                                        ignoreTwo = true;
                                    }
                                }
                                if (!ignoreOne || !ignoreTwo) continue;
                                break;
                            }
                        }
                        Vector3d pushVec = new Vector3d();
                        RotationUtils.setValue((Tuple3d)pushVec, (double)cache.facing.func_176743_c().func_179524_a(), (EnumFacing.Axis)cache.facing.func_176740_k());
                        if (!ignoreOne && positiveOne != null) {
                            RotationUtils.setValue((Tuple3d)pushVec, (double)(positiveOne != false ? 1.0 : -1.0), (EnumFacing.Axis)one);
                        }
                        if (!ignoreTwo && positiveTwo != null) {
                            RotationUtils.setValue((Tuple3d)pushVec, (double)(positiveTwo != false ? 1.0 : -1.0), (EnumFacing.Axis)two);
                        }
                        Vector3d pushInv = new Vector3d(-pushVec.x, -pushVec.y, -pushVec.z);
                        Vector3d rotatedVec = new Vector3d(pushVec);
                        this.origin.rotation().transform((Tuple3d)rotatedVec);
                        BoxPlane xPlane = BoxPlane.createOppositePlane((EnumFacing.Axis)EnumFacing.Axis.X, (Vector3d)rotatedVec, (Vector3d[])corners);
                        BoxPlane yPlane = BoxPlane.createOppositePlane((EnumFacing.Axis)EnumFacing.Axis.Y, (Vector3d)rotatedVec, (Vector3d[])corners);
                        BoxPlane zPlane = BoxPlane.createOppositePlane((EnumFacing.Axis)EnumFacing.Axis.Z, (Vector3d)rotatedVec, (Vector3d[])corners);
                        double scale = 0.0;
                        for (int j = 0; j < intersecting.size(); ++j) {
                            EnumFacing facing = (EnumFacing)intersectingFacing.get(j);
                            if (ignoreOne && facing.func_176740_k() == one || ignoreTwo && facing.func_176740_k() == two) continue;
                            scale = ((OrientatedBoundingBox)intersecting.get(j)).getPushOutScale(scale, fakeBox, cache.entityBox, pushVec, pushInv, xPlane, yPlane, zPlane);
                        }
                        boolean collidedHorizontally = entity.field_70123_F;
                        boolean collidedVertically = entity.field_70124_G;
                        boolean onGround = entity.field_70122_E;
                        AxisAlignedBB originalBox = entity.func_174813_aQ();
                        double moveX = cache.entityBox.field_72340_a - originalBox.field_72340_a + rotatedVec.x * scale;
                        double moveY = cache.entityBox.field_72338_b - originalBox.field_72338_b + rotatedVec.y * scale;
                        double moveZ = cache.entityBox.field_72339_c - originalBox.field_72339_c + rotatedVec.z * scale;
                        entity.func_70091_d(MoverType.PISTON, moveX, moveY, moveZ);
                        if (entity instanceof EntityPlayerMP) {
                            LittleDoorHandler.setPushedByDoor((EntityPlayerMP)entity);
                        }
                        if (moveX != 0.0 || moveZ != 0.0) {
                            collidedHorizontally = true;
                        }
                        if (moveY != 0.0) {
                            collidedVertically = true;
                            onGround = true;
                        }
                        entity.field_70123_F = collidedHorizontally;
                        entity.field_70124_G = collidedVertically;
                        entity.field_70122_E = onGround;
                        entity.field_70132_H = collidedHorizontally || collidedVertically;
                    }
                }
                this.noCollision = false;
            }
        }
        if (!moved) {
            this.field_70165_t += x;
            this.field_70163_u += y;
            this.field_70161_v += z;
            this.worldRotX += rotX;
            this.worldRotY += rotY;
            this.worldRotZ += rotZ;
            this.updateOrigin();
        }
    }

    public void moveXTo(double x) {
        this.moveAnimation(x - this.field_70165_t, 0.0, 0.0);
    }

    public void moveYTo(double y) {
        this.moveAnimation(0.0, y - this.field_70163_u, 0.0);
    }

    public void moveZTo(double z) {
        this.moveAnimation(0.0, 0.0, z - this.field_70161_v);
    }

    public void moveAnimation(double x, double y, double z) {
        this.moveAndRotateAnimation(x, y, z, 0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void unloadRenderCache() {
        if (this.renderChunks == null) {
            return;
        }
        for (LittleRenderChunk chunk : this.renderChunks.values()) {
            chunk.unload();
        }
    }

    public EntityOldAnimation(World worldIn) {
        super(worldIn);
    }

    public EntityOldAnimation(World world, CreativeWorld fakeWorld, ArrayList<TileEntityLittleTiles> blocks, LittleAbsolutePreviewsStructure previews, UUID uuid, LittleTilePos center, LittleTileVec additional) {
        this(world);
        this.blocks = blocks;
        this.previews = previews;
        this.field_96093_i = uuid;
        this.field_189513_ar = this.field_96093_i.toString();
        this.fakeWorld = fakeWorld;
        this.fakeWorld.parent = this;
        this.setCenterVec(center, additional);
        this.updateWorldCollision();
        this.func_70107_b(this.baseOffset.func_177958_n(), this.baseOffset.func_177956_o(), this.baseOffset.func_177952_p());
    }

    @SideOnly(value=Side.CLIENT)
    public void createClient() {
        if (this.blocks != null) {
            this.renderChunks = new LinkedHashMap();
            this.renderQueue = new ArrayList<TileEntityLittleTiles>(this.blocks);
        }
    }

    public void onScanningTE(TileEntityLittleTiles te) {
        te.setLoaded();
        if (this.field_70170_p.field_72995_K) {
            if (te.rendering == null) {
                te.rendering = new AtomicBoolean(false);
            }
            RenderingThread.addCoordToUpdate(te, 0.0, false);
        }
    }

    protected void handleForces() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public void updateBoundingBox() {
        boolean moved;
        if (this.worldBoundingBox == null || this.fakeWorld == null) {
            return;
        }
        boolean rotated = this.prevWorldRotX != this.worldRotX || this.prevWorldRotY != this.worldRotY || this.field_70166_s != this.worldRotZ;
        boolean bl = moved = this.field_70169_q != this.field_70165_t || this.field_70167_r != this.field_70163_u || this.field_70166_s != this.field_70161_v;
        if (rotated || moved) {
            this.func_174826_a(this.origin.getAxisAlignedBox((AxisAlignedBB)this.worldBoundingBox));
        }
    }

    public void updateOrigin() {
        this.origin.off(this.field_70165_t - (double)this.getAxisPos().func_177958_n(), this.field_70163_u - (double)this.getAxisPos().func_177956_o(), this.field_70161_v - (double)this.getAxisPos().func_177952_p());
        this.origin.rot(this.worldRotX, this.worldRotY, this.worldRotZ);
    }

    public void onTick() {
    }

    public void onPostTick() {
    }

    public void func_70071_h_() {
        this.onUpdateForReal();
    }

    public void onUpdateForReal() {
        if (this.blocks == null && !this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
        if (this.blocks == null) {
            return;
        }
        if (this.collisionBoxWorker != null) {
            this.collisionBoxWorker.work();
            if (this.collisionBoxWorker.hasFinished()) {
                this.collisionBoxWorker = null;
            }
        }
        this.prevWorldRotX = this.worldRotX;
        this.prevWorldRotY = this.worldRotY;
        this.prevWorldRotZ = this.worldRotZ;
        this.handleForces();
        super.func_70071_h_();
        this.onTick();
        this.onPostTick();
        this.updateBoundingBox();
        for (TileEntity te : this.fakeWorld.field_175730_i) {
            ((ITickable)te).func_73660_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
    }

    public void func_70634_a(double x, double y, double z) {
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
    }

    public void setInitialPosition(double x, double y, double z) {
        this.func_70107_b(x, y, z);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.updateBoundingBox();
    }

    public void func_70106_y() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70128_L = true;
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return null;
    }

    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return true;
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        return EnumActionResult.SUCCESS;
    }

    protected abstract void copyExtra(EntityOldAnimation var1);

    public EntityOldAnimation copy() {
        EntityOldAnimation animation = null;
        try {
            animation = (EntityOldAnimation)((Object)((Object)((Object)this)).getClass().getConstructor(World.class).newInstance(this.field_70170_p));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        animation.func_184221_a(this.func_110124_au());
        animation.fakeWorld = this.fakeWorld;
        animation.setCenterVec(this.center.copy(), this.additionalAxis.copy());
        animation.previews = this.previews.copy();
        animation.blocks = this.blocks;
        animation.worldBoundingBox = this.worldBoundingBox;
        animation.worldCollisionBoxes = new ArrayList<OrientatedBoundingBox>(this.worldCollisionBoxes);
        if (this.field_70170_p.field_72995_K) {
            animation.renderChunks = this.renderChunks;
            animation.renderQueue = this.renderQueue;
        }
        animation.prevWorldRotX = this.prevWorldRotX;
        animation.prevWorldRotY = this.prevWorldRotY;
        animation.prevWorldRotZ = this.prevWorldRotZ;
        animation.worldRotX = this.worldRotX;
        animation.worldRotY = this.worldRotY;
        animation.worldRotZ = this.worldRotZ;
        this.copyExtra(animation);
        return animation;
    }

    protected void reloadPreviews(LittleStructure parent, BlockPos pos) {
        this.previews = parent.getAbsolutePreviews(pos);
    }

    public LittleStructure getParentStructure() {
        for (TileEntityLittleTiles te : this.blocks) {
            for (LittleTile tile : te.getTiles()) {
                if (tile.connection.isLink()) continue;
                LittleStructure structure = tile.connection.getStructureWithoutLoading();
                if (structure.parent != null && !structure.parent.isLinkToAnotherWorld()) continue;
                return structure;
            }
        }
        return null;
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.fakeWorld = compound.func_74767_n("subworld") ? SubWorld.createFakeWorld((World)this.field_70170_p) : FakeWorld.createFakeWorld((String)this.func_189512_bd(), (boolean)this.field_70170_p.field_72995_K);
        this.setCenterVec(new LittleTilePos("axis", compound), new LittleTileVec("additional", compound));
        NBTTagList list = compound.func_150295_c("tileEntity", (int)compound.func_74732_a());
        this.blocks = new ArrayList();
        LittleStructure parent = null;
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt = list.func_150305_b(i);
            TileEntityLittleTiles te = (TileEntityLittleTiles)TileEntity.func_190200_a((World)this.fakeWorld, (NBTTagCompound)nbt);
            te.func_145834_a((World)this.fakeWorld);
            this.blocks.add(te);
            for (LittleTile tile : te.getTiles()) {
                if (tile.connection.isLink()) continue;
                LittleStructure structure = tile.connection.getStructureWithoutLoading();
                if (structure.parent != null && !structure.parent.isLinkToAnotherWorld()) continue;
                parent = structure;
            }
            this.fakeWorld.func_175656_a(te.func_174877_v(), BlockTile.getState(te.isTicking(), te.isRendered()));
            this.fakeWorld.func_175690_a(te.func_174877_v(), (TileEntity)te);
        }
        int[] array = compound.func_74759_k("previewPos");
        BlockPos pos = array.length == 3 ? new BlockPos(array[0], array[1], array[2]) : this.baseOffset;
        this.reloadPreviews(parent, pos);
        this.updateWorldCollision();
        this.updateBoundingBox();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        this.center.writeToNBT("axis", compound);
        this.additionalAxis.writeToNBT("additional", compound);
        compound.func_74757_a("subworld", this.fakeWorld.hasParent());
        NBTTagList list = new NBTTagList();
        for (TileEntityLittleTiles te : this.blocks) {
            list.func_74742_a((NBTBase)te.func_189515_b(new NBTTagCompound()));
        }
        compound.func_74782_a("tileEntity", (NBTBase)list);
        compound.func_74783_a("previewPos", new int[]{this.previews.pos.func_177958_n(), this.previews.pos.func_177956_o(), this.previews.pos.func_177952_p()});
    }
}

