/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorld;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AnimationPreview {
    public final EntityAnimation animation;
    public final LittlePreviews previews;
    public final LittleTileBox entireBox;
    public final LittleGridContext context;
    public final AxisAlignedBB box;

    public AnimationPreview(LittlePreviews previews) {
        this.previews = previews;
        BlockPos pos = new BlockPos(0, 75, 0);
        FakeWorld fakeWorld = FakeWorld.createFakeWorld((String)"animationViewer", (boolean)true);
        ArrayList<PlacePreviewTile> placePreviews = new ArrayList<PlacePreviewTile>();
        previews.getPlacePreviews(placePreviews, null, true, LittleTileVec.ZERO);
        previews.deleteCachedStructure();
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, pos);
        ArrayList<TileEntityLittleTiles> blocks = new ArrayList<TileEntityLittleTiles>();
        LittleActionPlaceStack.placeTilesWithoutPlayer((World)fakeWorld, previews.context, splitted, previews.getStructure(), PlacementMode.all, pos, null, null, null, null);
        for (TileEntity te : fakeWorld.field_147482_g) {
            if (!(te instanceof TileEntityLittleTiles)) continue;
            blocks.add((TileEntityLittleTiles)te);
        }
        this.entireBox = previews.getSurroundingBox();
        this.context = previews.context;
        this.box = this.entireBox.getBox(this.context);
        this.animation = new EntityAnimation((World)fakeWorld, (CreativeWorld)fakeWorld, (EntityAnimationController)new EntityAnimationController(){

            @Override
            protected void writeToNBTExtra(NBTTagCompound nbt) {
            }

            @Override
            protected void readFromNBT(NBTTagCompound nbt) {
            }

            @Override
            public boolean onRightClick() {
                return false;
            }
        }.addStateAndSelect("nothing", new AnimationState()), pos, UUID.randomUUID(), new StructureAbsolute(pos, this.entireBox, previews.context)){

            @Override
            public boolean shouldAddDoor() {
                return false;
            }
        };
        previews.deleteCachedStructure();
    }
}

