/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.LittleActionInteract;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionReplace
extends LittleActionInteract {
    public LittleTilePreview toReplace;
    public LittleAbsolutePreviews replacedTiles;
    public LittleBoxes boxes;

    public LittleActionReplace(BlockPos blockPos, EntityPlayer player, LittleTilePreview toReplace) {
        super(blockPos, player);
        this.toReplace = toReplace;
    }

    public LittleActionReplace() {
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        super.writeBytes(buf);
        NBTTagCompound nbt = new NBTTagCompound();
        this.toReplace.writeToNBT(nbt);
        LittleActionReplace.writeNBT((ByteBuf)buf, (NBTTagCompound)nbt);
    }

    @Override
    public void readBytes(ByteBuf buf) {
        super.readBytes(buf);
        this.toReplace = LittleTilePreview.loadPreviewFromNBT(LittleActionReplace.readNBT((ByteBuf)buf));
    }

    @Override
    protected boolean isRightClick() {
        return false;
    }

    @Override
    protected boolean action(World world, TileEntityLittleTiles te, LittleTile tile, ItemStack stack, EntityPlayer player, RayTraceResult moving, BlockPos pos, boolean secondMode) throws LittleActionException {
        if (!world.field_72995_K) {
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, te.func_174877_v(), te.getBlockTileState(), player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                LittleActionReplace.sendBlockResetToClient((EntityPlayerMP)player, pos, te);
                return false;
            }
        }
        this.replacedTiles = new LittleAbsolutePreviews(pos, te.getContext());
        this.boxes = new LittleBoxes(pos, te.getContext());
        if (SpecialServerConfig.isTransparencyRestricted(player)) {
            LittleActionReplace.isAllowedToPlacePreview(player, this.toReplace);
        }
        if (BlockTile.selectEntireBlock(player, secondMode)) {
            ArrayList<LittleTile> toRemove = new ArrayList<LittleTile>();
            for (LittleTile littleTile : te.getTiles()) {
                if (littleTile.isChildOfStructure() || !tile.canBeCombined(littleTile) || !littleTile.canBeCombined(tile)) continue;
                this.replacedTiles.addTile(littleTile);
                this.boxes.addBox(littleTile);
                toRemove.add(littleTile);
            }
            if (toRemove.isEmpty()) {
                return false;
            }
            LittleActionReplace.addPreviewToInventory(player, this.replacedTiles);
            ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
            for (LittleTile littleTile : toRemove) {
                littleTile.destroy();
                LittleTilePreview preview = this.toReplace.copy();
                preview.box = littleTile.box;
                previews.add(preview.getPlaceableTile(null, true, null, null));
            }
            ArrayList<LittleTile> arrayList = new ArrayList<LittleTile>();
            LittleActionPlaceStack.placeTiles(world, player, te.getContext(), previews, null, PlacementMode.normal, pos, stack, arrayList, null, EnumFacing.EAST);
            LittleActionReplace.addTilesToInventoryOrDrop(player, arrayList);
        } else {
            if (tile.isChildOfStructure()) {
                return false;
            }
            this.replacedTiles.addTile(tile);
            this.boxes.addBox(tile);
            LittleActionReplace.addPreviewToInventory(player, this.replacedTiles);
            tile.destroy();
            LittlePreviews toBePlaced = new LittlePreviews(te.getContext());
            this.toReplace.box = tile.box;
            toBePlaced.addPreview(null, this.toReplace, te.getContext());
            LittleActionReplace.drain(player, IngredientUtils.getIngredients(toBePlaced));
            ArrayList<PlacePreviewTile> previews = new ArrayList<PlacePreviewTile>();
            previews.add(this.toReplace.getPlaceableTile(null, true, null, null));
            ArrayList<LittleTile> arrayList = new ArrayList<LittleTile>();
            LittleActionPlaceStack.placeTiles(world, player, te.getContext(), previews, null, PlacementMode.normal, pos, stack, arrayList, null, EnumFacing.EAST);
            LittleActionReplace.addTilesToInventoryOrDrop(player, arrayList);
        }
        world.func_184133_a((EntityPlayer)null, pos, tile.getSound().func_185845_c(), SoundCategory.BLOCKS, (tile.getSound().func_185843_a() + 1.0f) / 2.0f, tile.getSound().func_185847_b() * 0.8f);
        return true;
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() throws LittleActionException {
        return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.replacedTiles, PlacementMode.normal));
    }
}

