/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.config.SpecialServerConfig;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleBoxes;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.ingredients.IngredientUtils;
import com.creativemd.littletiles.common.utils.placing.PlacementHelper;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionPlaceStack
extends LittleAction {
    public PlacementHelper.PositionResult position;
    public boolean centered;
    public boolean fixed;
    public PlacementMode mode;
    public LittlePreviews previews;
    public LittleBoxes boxes;
    public LittleAbsolutePreviews destroyed;

    public LittleActionPlaceStack(ItemStack stack, LittlePreviews previews, PlacementHelper.PositionResult position, boolean centered, boolean fixed, PlacementMode mode) {
        this.position = position;
        this.centered = centered;
        this.fixed = fixed;
        this.mode = mode;
        this.previews = previews;
    }

    public LittleActionPlaceStack() {
    }

    public void checkMode(LittlePreviews previews) {
        if (previews.hasStructure() && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    public void checkMode(LittleStructure structure) {
        if (structure != null && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        this.boxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.destroyed, PlacementMode.normal, true));
        }
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        ItemStack stack = player.func_184614_ca();
        if (!LittleActionPlaceStack.isAllowedToInteract(player, this.position.pos, true, EnumFacing.EAST)) {
            LittleActionPlaceStack.sendBlockResetToClient((EntityPlayerMP)player, this.position.pos, null);
            return false;
        }
        if (PlacementHelper.getLittleInterface(stack) != null) {
            LittlePlaceResult tiles = this.placeTile(player, stack, player.field_70170_p, this.position, this.centered, this.fixed, this.mode);
            if (!player.field_70170_p.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
            }
            return tiles != null;
        }
        return false;
    }

    public void writeBytes(ByteBuf buf) {
        this.position.writeToBytes(buf);
        buf.writeBoolean(this.centered);
        buf.writeBoolean(this.fixed);
        LittleActionPlaceStack.writePlacementMode(this.mode, buf);
        LittleActionPlaceStack.writePreviews(this.previews, buf);
    }

    public void readBytes(ByteBuf buf) {
        this.position = PlacementHelper.PositionResult.readFromBytes(buf);
        this.centered = buf.readBoolean();
        this.fixed = buf.readBoolean();
        this.mode = LittleActionPlaceStack.readPlacementMode(buf);
        this.previews = LittleActionPlaceStack.readPreviews(buf);
    }

    public LittlePlaceResult placeTile(EntityPlayer player, ItemStack stack, World world, PlacementHelper.PositionResult position, boolean centered, boolean fixed, PlacementMode mode) throws LittleActionException {
        LittlePlaceResult placedTiles;
        PlacementHelper.PreviewResult result;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        this.checkMode(this.previews);
        if (this.previews.hasStructure()) {
            this.previews.getStructure().setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        }
        if ((result = PlacementHelper.getPreviews(world, this.previews, iTile.getPreviewsContext(stack), stack, position, centered, fixed, false, mode)) == null) {
            return null;
        }
        ArrayList<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
        ArrayList<LittleTile> removedTiles = new ArrayList<LittleTile>();
        ItemStack toPlace = stack.func_77946_l();
        if (LittleActionPlaceStack.needIngredients(player) && !iTile.containsIngredients(stack)) {
            LittleActionPlaceStack.canDrain(player, result.previews);
        }
        if ((placedTiles = LittleActionPlaceStack.placeTiles(world, player, result.context, result.placePreviews, this.previews.getStructure(), mode, position.pos, toPlace, unplaceableTiles, removedTiles, position.facing)) != null) {
            this.boxes = placedTiles.placedBoxes;
            if (LittleActionPlaceStack.needIngredients(player)) {
                LittleActionPlaceStack.addTilesToInventoryOrDrop(player, removedTiles);
                if (iTile.containsIngredients(stack)) {
                    stack.func_190918_g(1);
                    LittleActionPlaceStack.addTilesToInventoryOrDrop(player, unplaceableTiles);
                } else {
                    LittleActionPlaceStack.drain(player, IngredientUtils.getStructureIngredients(this.previews).add(IngredientUtils.getIngredients(placedTiles.placedPreviews)));
                }
            }
            if (!removedTiles.isEmpty()) {
                this.destroyed = new LittleAbsolutePreviews(position.pos, result.context);
                for (LittleTile tile : removedTiles) {
                    this.destroyed.addTile(tile);
                }
            }
        } else {
            this.boxes = new LittleBoxes(position.pos, result.context);
        }
        return placedTiles;
    }

    public static LittlePlaceResult placeTilesWithoutPlayer(World world, LittleGridContext context, HashMap<BlockPos, PlacePreviews> splitted, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) {
        try {
            return LittleActionPlaceStack.placeTiles(world, null, context, splitted, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    public static LittlePlaceResult placeTilesWithoutPlayer(World world, LittleGridContext context, List<PlacePreviewTile> previews, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) {
        try {
            return LittleActionPlaceStack.placeTiles(world, null, context, previews, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    private static LittlePlaceResult placeTiles(World world, EntityPlayer player, LittleGridContext context, HashMap<BlockPos, PlacePreviews> splitted, LittleStructure parentStructure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) throws LittleActionException {
        if (splitted == null) {
            return null;
        }
        List<BlockPos> coordsToCheck = mode.getCoordsToCheck(splitted, pos);
        if (LittleActionPlaceStack.canPlaceTiles(player, world, splitted, coordsToCheck, mode)) {
            LittlePlaceResult placed = new LittlePlaceResult(pos, context);
            ArrayList<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
            ArrayList<LastPlacedTile> lastPlacedTiles = new ArrayList<LastPlacedTile>();
            for (Map.Entry<BlockPos, PlacePreviews> entry : splitted.entrySet()) {
                TileEntityLittleTiles te;
                BlockPos coord = entry.getKey();
                PlacePreviews placeTiles = entry.getValue();
                boolean hascollideBlock = false;
                int i = 0;
                while (i < placeTiles.size()) {
                    if (((PlacePreviewTile)placeTiles.get(i)).needsCollisionTest()) {
                        hascollideBlock = true;
                        ++i;
                        continue;
                    }
                    lastPlacedTiles.add(new LastPlacedTile((PlacePreviewTile)placeTiles.get(i), coord, placeTiles.context));
                    placeTiles.remove(i);
                }
                if (!hascollideBlock) continue;
                boolean requiresCollisionTest = true;
                if (!(world.func_180495_p(coord).func_177230_c() instanceof BlockTile) && world.func_180495_p(coord).func_185904_a().func_76222_j()) {
                    requiresCollisionTest = false;
                    world.func_175656_a(coord, BlockTile.getState(false, false));
                }
                if ((te = LittleActionPlaceStack.loadTe(player, world, coord, mode.shouldConvertBlock())) == null) continue;
                te.preventUpdate = true;
                if (te.getTiles().isEmpty()) {
                    requiresCollisionTest = false;
                }
                placeTiles.ensureBothAreEqual(te);
                for (PlacePreviewTile placeTile : placeTiles) {
                    for (LittleTile LT : placeTile.placeTile(player, stack, coord, te.getContext(), te, unplaceableTiles, removedTiles, mode, facing, requiresCollisionTest)) {
                        if (placeTile.structurePreview != null && !placeTile.structurePreview.getStructure().shouldPlaceTile(LT)) continue;
                        if (!soundsToBePlayed.contains(LT.getSound())) {
                            soundsToBePlayed.add(LT.getSound());
                        }
                        if (placeTile.structurePreview != null) {
                            if (!placeTile.structurePreview.getStructure().hasMainTile()) {
                                placeTile.structurePreview.getStructure().setMainTile(LT);
                            } else {
                                LT.connection = placeTile.structurePreview.getStructure().getStructureLink(LT);
                                LT.connection.setLoadedStructure(placeTile.structurePreview.getStructure(), placeTile.structurePreview.getStructure().attribute);
                                placeTile.structurePreview.getStructure().addTile(LT);
                            }
                        }
                        placed.addPlacedTile(LT);
                    }
                }
                te.preventUpdate = false;
                if (parentStructure != null) {
                    te.combineTiles(parentStructure);
                } else {
                    te.combineTiles();
                }
                if (parentStructure == null || te.getTiles().size() != 1 || !te.convertBlockToVanilla()) continue;
                placed.tileEntities.remove(placed.tileEntities.size() - 1);
            }
            for (LastPlacedTile lastPlacedTile : lastPlacedTiles) {
                for (LittleTile tile : lastPlacedTile.tile.placeTile(player, stack, lastPlacedTile.pos, lastPlacedTile.context, null, unplaceableTiles, removedTiles, mode, facing, true)) {
                    if (tile == null) continue;
                    placed.addPlacedTile(tile);
                }
            }
            if (parentStructure != null) {
                if (parentStructure.getMainTile() == null) {
                    throw new LittleActionException("Missing maintile of structure. Placed " + placed.placedPreviews.size() + " tile(s).");
                }
                parentStructure.placedStructure(stack);
            }
            for (int i = 0; i < soundsToBePlayed.size(); ++i) {
                world.func_184133_a((EntityPlayer)null, pos, ((SoundType)soundsToBePlayed.get(i)).func_185841_e(), SoundCategory.BLOCKS, (((SoundType)soundsToBePlayed.get(i)).func_185843_a() + 1.0f) / 2.0f, ((SoundType)soundsToBePlayed.get(i)).func_185847_b() * 0.8f);
            }
            return placed;
        }
        return null;
    }

    public static LittlePlaceResult placeTiles(World world, EntityPlayer player, LittleGridContext context, List<PlacePreviewTile> previews, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) throws LittleActionException {
        if (player != null) {
            if (SpecialServerConfig.isPlaceLimited(player) && LittleActionPlaceStack.getVolume(context, previews) > (double)SpecialServerConfig.maxPlaceBlocks) {
                throw new SpecialServerConfig.NotAllowedToPlaceException();
            }
            if (SpecialServerConfig.isTransparencyRestricted(player)) {
                for (PlacePreviewTile placePreview : previews) {
                    LittleActionPlaceStack.isAllowedToPlacePreview(player, placePreview.preview);
                }
            }
        }
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(context, previews, pos);
        if (player != null && !world.field_72995_K) {
            ArrayList<BlockSnapshot> snaps = new ArrayList<BlockSnapshot>();
            for (BlockPos snapPos : splitted.keySet()) {
                snaps.add(new BlockSnapshot(world, snapPos, BlockTile.getState(false, false)));
            }
            BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(snaps, world.func_180495_p(facing == null ? pos : pos.func_177972_a(facing)), player, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                for (BlockPos snapPos : splitted.keySet()) {
                    LittleActionPlaceStack.sendBlockResetToClient((EntityPlayerMP)player, pos, null);
                }
                return null;
            }
        }
        return LittleActionPlaceStack.placeTiles(world, player, context, splitted, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
    }

    public static double getVolume(LittleGridContext context, List<PlacePreviewTile> tiles) {
        double volume = 0.0;
        for (PlacePreviewTile preview : tiles) {
            volume += preview.box.getPercentVolume(context);
        }
        return volume;
    }

    public static HashMap<BlockPos, PlacePreviews> getSplittedTiles(LittleGridContext context, List<PlacePreviewTile> tiles, BlockPos pos) {
        HashMapList splitted = new HashMapList();
        for (int i = 0; i < tiles.size(); ++i) {
            if (tiles.get(i).split(context, (HashMapList<BlockPos, PlacePreviewTile>)splitted, pos)) continue;
            return null;
        }
        HashMap<BlockPos, PlacePreviews> previews = new HashMap<BlockPos, PlacePreviews>();
        for (Map.Entry entry : splitted.entrySet()) {
            previews.put((BlockPos)entry.getKey(), new PlacePreviews(context, (List)entry.getValue()));
        }
        return previews;
    }

    public static boolean canPlaceTiles(EntityPlayer player, World world, HashMap<BlockPos, PlacePreviews> splitted, List<BlockPos> coordsToCheck, PlacementMode mode) {
        for (BlockPos pos : splitted.keySet()) {
            if (LittleActionPlaceStack.isAllowedToInteract(player, pos, true, EnumFacing.EAST)) continue;
            LittleActionPlaceStack.sendBlockResetToClient((EntityPlayerMP)player, pos, null);
            return false;
        }
        if (coordsToCheck != null) {
            for (BlockPos pos : coordsToCheck) {
                PlacePreviews tiles = splitted.get(pos);
                if (tiles == null) continue;
                boolean needsCollisionCheck = false;
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest()) continue;
                    needsCollisionCheck = true;
                    break;
                }
                if (!needsCollisionCheck) continue;
                TileEntityLittleTiles te = LittleActionPlaceStack.loadTe(player, world, pos, false);
                if (te != null) {
                    LittleGridContext contextBefore = te.getContext();
                    tiles.ensureBothAreEqual(te);
                    for (int j = 0; j < tiles.size(); ++j) {
                        if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest()) continue;
                        if (mode.checkAll()) {
                            if (te.isSpaceForLittleTile(((PlacePreviewTile)tiles.get((int)j)).box)) continue;
                            if (te.getContext() != contextBefore) {
                                te.convertTo(contextBefore);
                            }
                            return false;
                        }
                        if (te.isSpaceForLittleTileStructure(((PlacePreviewTile)tiles.get((int)j)).box)) continue;
                        if (te.getContext() != contextBefore) {
                            te.convertTo(contextBefore);
                        }
                        return false;
                    }
                    continue;
                }
                IBlockState state = world.func_180495_p(pos);
                if (state.func_185904_a().func_76222_j()) {
                    return false;
                }
                if (state.func_177230_c() instanceof BlockTile || !mode.checkAll() && LittleActionPlaceStack.isBlockValid(state.func_177230_c()) && LittleActionPlaceStack.canConvertBlock(player, world, pos, state)) continue;
                return false;
            }
        }
        return true;
    }

    public static class LittlePlaceResult {
        public final LittleAbsolutePreviews placedPreviews;
        public final LittleBoxes placedBoxes;
        private BlockPos lastPos = null;
        public final List<TileEntityLittleTiles> tileEntities = new ArrayList<TileEntityLittleTiles>();

        public LittlePlaceResult(BlockPos pos, LittleGridContext context) {
            this.placedPreviews = new LittleAbsolutePreviews(pos, context);
            this.placedBoxes = new LittleBoxes(pos, context);
        }

        public void addPlacedTile(LittleTile tile) {
            if (this.lastPos == null || !this.lastPos.equals((Object)tile.te.func_174877_v())) {
                this.lastPos = tile.te.func_174877_v();
                this.tileEntities.add(tile.te);
            }
            this.placedPreviews.addTile(tile);
            this.placedBoxes.addBox(tile);
        }
    }

    public static class LastPlacedTile {
        public final PlacePreviewTile tile;
        public final BlockPos pos;
        public final LittleGridContext context;

        public LastPlacedTile(PlacePreviewTile tile, BlockPos pos, LittleGridContext context) {
            this.tile = tile;
            this.pos = pos;
            this.context = context;
        }
    }
}

