/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.api.attribute;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.zeitheron.solarflux.api.attribute.AttributeModAdd;
import com.zeitheron.solarflux.api.attribute.AttributeModMultiply;
import com.zeitheron.solarflux.api.attribute.IAttributeMod;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AttributeModRegistry {
    private static final Map<String, Function<Float, ? extends IAttributeMod>> registry = new HashMap<String, Function<Float, ? extends IAttributeMod>>();
    private static final BiMap<String, Class<? extends IAttributeMod>> typeRegistry = HashBiMap.create();

    public static <T extends IAttributeMod> void register(String id, Class<T> type, Function<Float, T> generator) {
        if (registry.containsKey(id = id.toLowerCase())) {
            throw new IllegalArgumentException("Duplicate entry for '" + id + "'!");
        }
        registry.put(id, generator);
        typeRegistry.put((Object)id, type);
    }

    public static String getId(IAttributeMod mod) {
        if (mod == null) {
            return null;
        }
        return (String)typeRegistry.inverse().get(mod.getClass());
    }

    public static IAttributeMod create(String id, float value) {
        return registry.containsKey(id = id.toLowerCase()) ? registry.get(id).apply(Float.valueOf(value)) : null;
    }

    static {
        AttributeModRegistry.register("add", AttributeModAdd.class, AttributeModAdd::new);
        AttributeModRegistry.register("mult", AttributeModMultiply.class, AttributeModMultiply::new);
    }
}

