/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.solarflux.api;

import com.google.common.reflect.TypeToken;
import com.zeitheron.solarflux.api.RegistryDelegate;
import com.zeitheron.solarflux.api.SolarInstance;
import com.zeitheron.solarflux.block.BlockBaseSolar;
import com.zeitheron.solarflux.block.tile.TileBaseSolar;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

public class SolarInfo
implements Consumer<SolarInstance>,
IForgeRegistryEntry<SolarInfo> {
    public String compatMod;
    public long maxGeneration;
    public int maxTransfer;
    public long maxCapacity;
    public boolean connectTextures = true;
    private BlockBaseSolar block;
    protected ResourceLocation tex;
    private TypeToken<SolarInfo> token = new TypeToken<SolarInfo>(this.getClass()){};
    public final IRegistryDelegate<SolarInfo> delegate = new RegistryDelegate<SolarInfo>(this, this.token.getRawType());
    private ResourceLocation registryName = null;

    public SolarInfo(long mgen, int mtranf, long mcap) {
        this.maxGeneration = mgen;
        this.maxTransfer = mtranf;
        this.maxCapacity = mcap;
    }

    public SolarInfo noConnectTexture() {
        this.connectTextures = false;
        return this;
    }

    protected BlockBaseSolar createBlock() {
        return new BlockBaseSolar(this);
    }

    public BlockBaseSolar getBlock() {
        if (this.block == null) {
            this.block = this.createBlock();
        }
        return this.block;
    }

    public ResourceLocation getTexture() {
        if (this.tex != null) {
            return this.tex;
        }
        this.tex = new ResourceLocation(this.getRegistryName().func_110624_b(), "blocks/solar_topf_" + this.getRegistryName().func_110623_a());
        return this.tex;
    }

    @Override
    public void accept(SolarInstance t) {
        t.gen = this.maxGeneration;
        t.cap = this.maxCapacity;
        t.transfer = this.maxTransfer;
        t.delegate = this.getRegistryName();
    }

    public SolarInfo setCompatMod(String compatMod) {
        this.compatMod = compatMod;
        return this;
    }

    public String getCompatMod() {
        return this.compatMod;
    }

    public void read(PacketBuffer buf) {
        this.maxGeneration = buf.readLong();
        this.maxTransfer = buf.readInt();
        this.maxCapacity = buf.readLong();
    }

    public void write(PacketBuffer buf) {
        buf.writeLong(this.maxGeneration);
        buf.writeInt(this.maxTransfer);
        buf.writeLong(this.maxCapacity);
    }

    public float computeSunIntensity(TileBaseSolar solar) {
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.func_145831_w().func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return MathHelper.func_76131_a((float)(multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public final SolarInfo setRegistryName(String name) {
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        this.registryName = SolarInfo.checkPrefix(name);
        return this;
    }

    public static ResourceLocation checkPrefix(String name) {
        String prefix;
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index).toLowerCase(Locale.ROOT);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "solarflux" : mc.getModId().toLowerCase(Locale.ROOT);
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            prefix = oldPrefix;
        }
        return new ResourceLocation(prefix, name);
    }

    public final SolarInfo setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public final SolarInfo setRegistryName(String modID, String name) {
        return this.setRegistryName(modID + ":" + name);
    }

    @Nullable
    public final ResourceLocation getRegistryName() {
        if (this.delegate.name() != null) {
            return this.delegate.name();
        }
        return this.registryName != null ? this.registryName : null;
    }

    public final Class<SolarInfo> getRegistryType() {
        return SolarInfo.class;
    }
}

