/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.network.tile.client;

import com.codetaylor.mc.athenaeum.ModAthenaeumConfig;
import com.codetaylor.mc.athenaeum.network.tile.TileDataServiceLogger;
import com.codetaylor.mc.athenaeum.network.tile.TileDataTracker;
import com.codetaylor.mc.athenaeum.network.tile.client.TileDataTrackerUpdateMonitor;
import com.codetaylor.mc.athenaeum.network.tile.spi.ITileData;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class TileDataServiceClientMonitor {
    private static final short TOTAL_INTERVAL_COUNT = 120;
    private static final int CACHE_CLEANUP_INTERVAL_TICKS = 200;
    private static final TileDataTrackerUpdateMonitor TRACKER_UPDATE_MONITOR;
    public static final TileDataServiceClientMonitor TOTAL;
    private static final LoadingCache<BlockPos, TileDataServiceClientMonitor> PER_POS_TOTAL;
    private static final CacheLoader<BlockPos, TileDataServiceClientMonitor> CACHE_LOADER;
    private static int cacheCleanupCounter;
    private final IntArrayList totalBytesReceivedPerSecond;
    private final UpdateIntervalProvider updateIntervalTicks;
    private final int totalIntervalCount;
    private int totalBytesReceived;
    private short tickCounter;

    @SubscribeEvent
    public static void onEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!Minecraft.func_71410_x().func_147113_T() && ModAthenaeumConfig.TILE_DATA_SERVICE.ENABLED) {
                TOTAL.update();
                for (TileDataServiceClientMonitor value : PER_POS_TOTAL.asMap().values()) {
                    value.update();
                }
                TRACKER_UPDATE_MONITOR.update();
            }
            if (++cacheCleanupCounter >= 200) {
                cacheCleanupCounter = 0;
                PER_POS_TOTAL.cleanUp();
            }
        }
    }

    public static void onClientPacketReceived(TileDataTracker tracker, BlockPos pos, int size) {
        if (ModAthenaeumConfig.TILE_DATA_SERVICE.ENABLED) {
            TOTAL.receiveBytes(size);
            TileDataServiceClientMonitor monitor = null;
            try {
                monitor = (TileDataServiceClientMonitor)PER_POS_TOTAL.get((Object)pos);
            }
            catch (ExecutionException e) {
                TileDataServiceLogger.LOGGER.error("", (Throwable)e);
            }
            if (monitor != null) {
                monitor.receiveBytes(size);
            }
        }
    }

    public static void onClientTrackerUpdateReceived(BlockPos pos, Class<? extends ITileData> tileDataClass) {
        if (ModAthenaeumConfig.TILE_DATA_SERVICE.ENABLED) {
            TRACKER_UPDATE_MONITOR.onClientTrackerUpdateReceived(pos, tileDataClass);
        }
    }

    @Nullable
    public static TileDataServiceClientMonitor findMonitorForPosition(BlockPos pos) {
        if (PER_POS_TOTAL.asMap().containsKey(pos)) {
            try {
                return (TileDataServiceClientMonitor)PER_POS_TOTAL.get((Object)pos);
            }
            catch (ExecutionException e) {
                TileDataServiceLogger.LOGGER.error("", (Throwable)e);
            }
        }
        return null;
    }

    public static TileDataTrackerUpdateMonitor getTrackerUpdateMonitor() {
        return TRACKER_UPDATE_MONITOR;
    }

    public TileDataServiceClientMonitor(UpdateIntervalProvider updateIntervalTicks, short totalIntervalCount) {
        this.totalBytesReceivedPerSecond = new IntArrayList((int)totalIntervalCount);
        this.updateIntervalTicks = updateIntervalTicks;
        this.totalIntervalCount = totalIntervalCount;
    }

    public void update() {
        this.tickCounter = (short)(this.tickCounter + 1);
        if (this.tickCounter >= this.updateIntervalTicks.getUpdateInterval()) {
            this.tickCounter = 0;
            this.totalBytesReceivedPerSecond.add(0, this.totalBytesReceived);
            this.totalBytesReceived = 0;
            if (this.totalBytesReceivedPerSecond.size() > this.totalIntervalCount) {
                this.totalBytesReceivedPerSecond.removeInt(this.totalBytesReceivedPerSecond.size() - 1);
            }
        }
    }

    private void receiveBytes(int size) {
        this.totalBytesReceived += size;
    }

    public int size() {
        return this.totalBytesReceivedPerSecond.size();
    }

    public int get(int index) {
        return this.totalBytesReceivedPerSecond.getInt(index);
    }

    public int getTotalIntervalCount() {
        return this.totalIntervalCount;
    }

    static {
        CACHE_LOADER = new CacheLoader<BlockPos, TileDataServiceClientMonitor>(){

            public TileDataServiceClientMonitor load(@Nonnull BlockPos pos) {
                return new TileDataServiceClientMonitor(() -> ModAthenaeumConfig.TILE_DATA_SERVICE.UPDATE_INTERVAL_TICKS, 120);
            }
        };
        TRACKER_UPDATE_MONITOR = new TileDataTrackerUpdateMonitor();
        TOTAL = new TileDataServiceClientMonitor(() -> ModAthenaeumConfig.TILE_DATA_SERVICE.UPDATE_INTERVAL_TICKS, 120);
        PER_POS_TOTAL = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build(CACHE_LOADER);
    }

    static interface UpdateIntervalProvider {
        public short getUpdateInterval();
    }
}

