/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.inventory;

import com.codetaylor.mc.athenaeum.inventory.DynamicStackHandler;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;

public class DynamicItemLimitedStackHandler
extends DynamicStackHandler {
    private final int itemCapacity;

    public DynamicItemLimitedStackHandler(int initialSize, int itemCapacity) {
        super(initialSize);
        this.itemCapacity = itemCapacity;
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int totalItemCount = this.getTotalItemCount();
        int remainingCapacity = this.itemCapacity - totalItemCount;
        if (remainingCapacity == 0) {
            return stack;
        }
        int stackCount = stack.func_190916_E();
        if (remainingCapacity < stackCount) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(remainingCapacity);
            ItemStack rejectedItems = super.insertItem(slot, copy, simulate);
            ItemStack result = stack.func_77946_l();
            int rejectedCount = rejectedItems.func_190916_E();
            int insertedCount = remainingCapacity - rejectedCount;
            result.func_190920_e(stackCount - insertedCount);
            return result;
        }
        return super.insertItem(slot, stack, simulate);
    }

    @Override
    public ItemStack insertItem(ItemStack itemStack, boolean simulate) {
        int totalItemCount = this.getTotalItemCount();
        int remainingCapacity = this.itemCapacity - totalItemCount;
        if (remainingCapacity == 0) {
            return itemStack;
        }
        int stackCount = itemStack.func_190916_E();
        if (remainingCapacity < stackCount) {
            ItemStack copy = itemStack.func_77946_l();
            copy.func_190920_e(remainingCapacity);
            super.insertItem(copy, simulate);
            ItemStack result = itemStack.func_77946_l();
            result.func_190920_e(stackCount - remainingCapacity);
            return result;
        }
        return super.insertItem(itemStack, simulate);
    }
}

