/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.athenaeum.gui;

import com.codetaylor.mc.athenaeum.gui.ContainerBase;
import com.codetaylor.mc.athenaeum.gui.GuiHelper;
import com.codetaylor.mc.athenaeum.gui.element.GuiElementBase;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementClickable;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementTooltipExtendedProvider;
import com.codetaylor.mc.athenaeum.gui.element.IGuiElementTooltipProvider;
import com.codetaylor.mc.athenaeum.util.TooltipHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.Container;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public abstract class GuiContainerBase
extends GuiContainer {
    private List<GuiElementBase> guiElementList;
    private List<IGuiElementClickable> guiElementClickableList;
    private List<IGuiElementTooltipProvider> tooltipProviderList;
    private List<String> tooltipTextList;
    protected ScaledResolution scaledResolution;

    public GuiContainerBase(ContainerBase container, int width, int height) {
        super((Container)container);
        this.field_146999_f = width;
        this.field_147000_g = height;
        this.guiElementList = new ArrayList<GuiElementBase>();
        this.guiElementClickableList = new ArrayList<IGuiElementClickable>();
        this.tooltipProviderList = new ArrayList<IGuiElementTooltipProvider>();
        this.tooltipTextList = new ArrayList<String>();
        this.scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }

    public RenderItem getItemRender() {
        return this.field_146296_j;
    }

    protected void guiContainerElementAdd(GuiElementBase ... elements) {
        for (GuiElementBase element : elements) {
            this.guiElementList.add(element);
            if (!(element instanceof IGuiElementClickable)) continue;
            this.guiElementClickableList.add((IGuiElementClickable)((Object)element));
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        for (GuiElementBase element : this.guiElementList) {
            element.handleMouseInput();
        }
    }

    public int guiContainerOffsetXGet() {
        return (this.scaledResolution.func_78326_a() - this.field_146999_f) / 2;
    }

    public int guiContainerOffsetYGet() {
        return (this.scaledResolution.func_78328_b() - this.field_147000_g) / 2;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glStencilMask((int)255);
        GL11.glClearStencil((int)0);
        GlStateManager.func_179086_m((int)1024);
        this.scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (GuiElementBase element : this.guiElementList) {
            element.update(partialTicks);
            if (!element.elementIsVisible(mouseX, mouseY)) continue;
            element.drawBackgroundLayer(partialTicks, mouseX, mouseY);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.tooltipProviderList.clear();
        for (GuiElementBase guiElementBase : this.guiElementList) {
            if (!guiElementBase.elementIsVisible(mouseX, mouseY)) continue;
            guiElementBase.drawForegroundLayer(mouseX, mouseY);
            if (!(guiElementBase instanceof IGuiElementTooltipProvider) || !guiElementBase.elementIsMouseInside(mouseX, mouseY)) continue;
            this.tooltipProviderList.add((IGuiElementTooltipProvider)((Object)guiElementBase));
        }
        for (IGuiElementTooltipProvider iGuiElementTooltipProvider : this.tooltipProviderList) {
            this.tooltipTextList.clear();
            if (!iGuiElementTooltipProvider.elementIsVisible(mouseX, mouseY) || !iGuiElementTooltipProvider.elementIsMouseInside(mouseX, mouseY)) continue;
            iGuiElementTooltipProvider.tooltipTextGet(this.tooltipTextList);
            if (iGuiElementTooltipProvider instanceof IGuiElementTooltipExtendedProvider) {
                if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                    ((IGuiElementTooltipExtendedProvider)iGuiElementTooltipProvider).tooltipTextExtendedGet(this.tooltipTextList);
                } else {
                    this.tooltipTextList.add(TooltipHelper.tooltipHoldShiftStringGet());
                }
            }
            this.func_146283_a(this.tooltipTextList, mouseX - this.guiContainerOffsetXGet(), mouseY - this.guiContainerOffsetYGet());
        }
    }

    public boolean func_146978_c(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        return (pointX -= i) >= rectX - 1 && pointX < rectX + rectWidth + 1 && (pointY -= j) >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (IGuiElementClickable element : this.guiElementClickableList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (!((GuiElementBase)((Object)element)).elementIsMouseInside(mouseX, mouseY) || !((GuiElementBase)((Object)element)).elementIsVisible(mouseX, mouseY)) continue;
            element.elementClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void drawScaledTexturedModalRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        GuiHelper.drawScaledTexturedModalRectFromIcon(x, y, this.field_73735_i, icon, width, height);
    }

    public void drawScaledTexturedModalRectFromIconAnchorBottomLeft(int x, int y, TextureAtlasSprite icon, int width, int height) {
        GuiHelper.drawVerticalScaledTexturedModalRectFromIconAnchorBottomLeft(x, y, this.field_73735_i, icon, width, height);
    }

    public void drawSizedModalRect(int x1, int y1, int x2, int y2, Color color) {
        GuiHelper.drawSizedModalRect(x1, y1, x2, y2, this.field_73735_i, color);
    }

    public void drawRotatedTexturedModalSquare(int x, int y, int textureX, int textureY, int size, int rotation) {
        GuiHelper.drawRotatedTexturedModalSquare(x, y, this.field_73735_i, textureX, textureY, size, rotation);
    }

    public void drawString(String format, int x, int y) {
        this.drawString(format, x, y, Color.WHITE.getRGB());
    }

    public void drawString(String format, int x, int y, int color) {
        this.field_146289_q.func_78276_b(format, x, y, color);
    }

    public int getGuiLeft() {
        return this.field_147003_i;
    }

    public int getGuiTop() {
        return this.field_147009_r;
    }
}

